/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.HashableStructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMdRecordToOafMapper {
    protected final VocabularyGroup vocs;
    protected static final UrlValidator URL_VALIDATOR = new UrlValidator(2L);
    private final boolean invisible;
    private final boolean shouldHashId;
    private final boolean forceOriginalId;
    protected static final String DATACITE_SCHEMA_KERNEL_4 = "http://datacite.org/schema/kernel-4";
    protected static final String DATACITE_SCHEMA_KERNEL_4_SLASH = "http://datacite.org/schema/kernel-4/";
    protected static final String DATACITE_SCHEMA_KERNEL_3 = "http://datacite.org/schema/kernel-3";
    protected static final String DATACITE_SCHEMA_KERNEL_3_SLASH = "http://datacite.org/schema/kernel-3/";
    protected static final Qualifier ORCID_PID_TYPE = OafMapperUtils.qualifier((String)"orcid_pending", (String)"Open Researcher and Contributor ID", (String)"dnet:pid_types", (String)"dnet:pid_types");
    protected static final Qualifier MAG_PID_TYPE = OafMapperUtils.qualifier((String)"MAGIdentifier", (String)"Microsoft Academic Graph Identifier", (String)"dnet:pid_types", (String)"dnet:pid_types");
    protected static final String DEFAULT_TRUST_FOR_VALIDATED_RELS = "0.999";
    protected static final Map<String, String> nsContext = new HashMap<String, String>();
    private static final Logger log = LoggerFactory.getLogger(AbstractMdRecordToOafMapper.class);
    protected static final Map<String, String> pidTypeWithAuthority;

    protected AbstractMdRecordToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId, boolean forceOriginalId) {
        this.vocs = vocs;
        this.invisible = invisible;
        this.shouldHashId = shouldHashId;
        this.forceOriginalId = forceOriginalId;
    }

    protected AbstractMdRecordToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId) {
        this.vocs = vocs;
        this.invisible = invisible;
        this.shouldHashId = shouldHashId;
        this.forceOriginalId = false;
    }

    public List<Oaf> processMdRecord(String xml) {
        DocumentFactory.getInstance().setXPathNamespaceURIs(nsContext);
        try {
            KeyValue hostedBy;
            Document doc = DocumentHelper.parseText((String)xml.replaceAll(DATACITE_SCHEMA_KERNEL_4, DATACITE_SCHEMA_KERNEL_3).replaceAll(DATACITE_SCHEMA_KERNEL_4_SLASH, DATACITE_SCHEMA_KERNEL_3).replaceAll(DATACITE_SCHEMA_KERNEL_3_SLASH, DATACITE_SCHEMA_KERNEL_3));
            KeyValue collectedFrom = this.getProvenanceDatasource(doc, "//oaf:collectedFrom/@id", "//oaf:collectedFrom/@name");
            if (collectedFrom == null) {
                return Lists.newArrayList();
            }
            KeyValue keyValue = hostedBy = StringUtils.isBlank((CharSequence)doc.valueOf("//oaf:hostedBy/@id")) ? collectedFrom : this.getProvenanceDatasource(doc, "//oaf:hostedBy/@id", "//oaf:hostedBy/@name");
            if (hostedBy == null) {
                return Lists.newArrayList();
            }
            DataInfo entityInfo = this.prepareDataInfo(doc, this.invisible);
            long lastUpdateTimestamp = new Date().getTime();
            Instance instance = this.prepareInstances(doc, entityInfo, collectedFrom, hostedBy);
            if (!Optional.ofNullable(instance.getInstancetype()).map(Qualifier::getClassid).filter(StringUtils::isNotBlank).isPresent()) {
                return Lists.newArrayList();
            }
            String type = this.getResultType(instance);
            return this.createOafs(doc, type, instance, collectedFrom, entityInfo, lastUpdateTimestamp);
        }
        catch (DocumentException e) {
            log.error("Error with record:\n" + xml);
            return Lists.newArrayList();
        }
    }

    protected String getResultType(Instance instance) {
        if (this.vocs.vocabularyExists("dnet:result_typologies")) {
            return Optional.ofNullable(instance.getInstancetype()).map(Qualifier::getClassid).map(instanceType -> Optional.ofNullable(this.vocs.getSynonymAsQualifier("dnet:result_typologies", instanceType)).map(Qualifier::getClassid).orElse("0000")).orElse("0000");
        }
        throw new IllegalStateException("Missing vocabulary: dnet:result_typologies");
    }

    private KeyValue getProvenanceDatasource(Document doc, String xpathId, String xpathName) {
        String dsId = doc.valueOf(xpathId);
        String dsName = doc.valueOf(xpathName);
        if (StringUtils.isBlank((CharSequence)dsId) || StringUtils.isBlank((CharSequence)dsName)) {
            return null;
        }
        return OafMapperUtils.keyValue((String)OafMapperUtils.createOpenaireId((int)10, (String)dsId, (boolean)true), (String)dsName);
    }

    protected List<Oaf> createOafs(Document doc, String type, Instance instance, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        String id;
        OafEntity entity = this.createEntity(doc, type, instance, collectedFrom, info, lastUpdateTimestamp);
        HashSet originalId = Sets.newHashSet((Iterable)entity.getOriginalId());
        originalId.add(entity.getId());
        entity.setOriginalId((List)Lists.newArrayList((Iterable)originalId));
        if (!this.forceOriginalId && !(id = IdentifierFactory.createIdentifier((OafEntity)entity, (boolean)this.shouldHashId)).equals(entity.getId())) {
            entity.setId(id);
        }
        ArrayList oafs = Lists.newArrayList((Object[])new Oaf[]{entity});
        DataInfo relationInfo = this.prepareDataInfo(doc, false);
        if (!oafs.isEmpty()) {
            HashSet rels = Sets.newHashSet();
            rels.addAll(this.addProjectRels(doc, entity, relationInfo));
            rels.addAll(this.addOtherResultRels(doc, entity, relationInfo));
            rels.addAll(this.addRelations(doc, entity, relationInfo));
            rels.addAll(this.addAffiliations(doc, entity, relationInfo));
            oafs.addAll(rels);
        }
        return oafs;
    }

    private OafEntity createEntity(Document doc, String type, Instance instance, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        switch (type.toLowerCase()) {
            case "publication": {
                Publication p = new Publication();
                this.populateResultFields((Result)p, doc, instance, collectedFrom, info, lastUpdateTimestamp);
                p.setJournal(this.prepareJournal(doc, info));
                return p;
            }
            case "dataset": {
                Dataset d = new Dataset();
                this.populateResultFields((Result)d, doc, instance, collectedFrom, info, lastUpdateTimestamp);
                d.setStoragedate(this.prepareDatasetStorageDate(doc, info));
                d.setDevice(this.prepareDatasetDevice(doc, info));
                d.setSize(this.prepareDatasetSize(doc, info));
                d.setVersion(this.prepareDatasetVersion(doc, info));
                d.setLastmetadataupdate(this.prepareDatasetLastMetadataUpdate(doc, info));
                d.setMetadataversionnumber(this.prepareDatasetMetadataVersionNumber(doc, info));
                d.setGeolocation(this.prepareDatasetGeoLocations(doc, info));
                return d;
            }
            case "software": {
                Software s = new Software();
                this.populateResultFields((Result)s, doc, instance, collectedFrom, info, lastUpdateTimestamp);
                s.setDocumentationUrl(this.prepareSoftwareDocumentationUrls(doc, info));
                s.setLicense(this.prepareSoftwareLicenses(doc, info));
                s.setCodeRepositoryUrl(this.prepareSoftwareCodeRepositoryUrl(doc, info));
                s.setProgrammingLanguage(this.prepareSoftwareProgrammingLanguage(doc, info));
                return s;
            }
        }
        OtherResearchProduct o = new OtherResearchProduct();
        this.populateResultFields((Result)o, doc, instance, collectedFrom, info, lastUpdateTimestamp);
        o.setContactperson(this.prepareOtherResearchProductContactPersons(doc, info));
        o.setContactgroup(this.prepareOtherResearchProductContactGroups(doc, info));
        o.setTool(this.prepareOtherResearchProductTools(doc, info));
        return o;
    }

    private List<Oaf> addProjectRels(Document doc, OafEntity entity, DataInfo info) {
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        String docId = entity.getId();
        for (Object o : doc.selectNodes("//oaf:projectid")) {
            String originalId = ((Node)o).getText();
            String validationdDate = ((Node)o).valueOf("@validationDate");
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String projectId = OafMapperUtils.createOpenaireId((int)40, (String)originalId, (boolean)true);
            res.add((Oaf)OafMapperUtils.getRelation((String)docId, (String)projectId, (String)"resultProject", (String)"outcome", (String)"isProducedBy", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), (String)validationdDate, null));
            res.add((Oaf)OafMapperUtils.getRelation((String)projectId, (String)docId, (String)"resultProject", (String)"outcome", (String)"produces", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), (String)validationdDate, null));
        }
        return res;
    }

    private List<Oaf> addRelations(Document doc, OafEntity entity, DataInfo info) {
        ArrayList rels = Lists.newArrayList();
        for (Object o : doc.selectNodes("//oaf:relation")) {
            String targetType;
            Element element = (Element)o;
            String target = StringUtils.trim((String)element.getText());
            String relType = element.attributeValue("relType");
            String subRelType = element.attributeValue("subRelType");
            String relClass = element.attributeValue("relClass");
            if (!StringUtils.isNotBlank((CharSequence)target) || !StringUtils.isNotBlank((CharSequence)relType) || !StringUtils.isNotBlank((CharSequence)subRelType) || !StringUtils.isNotBlank((CharSequence)relClass)) continue;
            String relClassInverse = ModelSupport.findInverse((String)ModelSupport.rel((String)relType, (String)subRelType, (String)relClass)).getInverseRelClass();
            String validationDate = ((Node)o).valueOf("@validationDate");
            if (!StringUtils.isNotBlank((CharSequence)target) || !StringUtils.isNotBlank((CharSequence)(targetType = element.attributeValue("targetType")))) continue;
            String targetId = OafMapperUtils.createOpenaireId((String)targetType, (String)target, (boolean)true);
            rels.add(OafMapperUtils.getRelation((String)entity.getId(), (String)targetId, (String)relType, (String)subRelType, (String)relClass, (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), (String)validationDate, null));
            rels.add(OafMapperUtils.getRelation((String)targetId, (String)entity.getId(), (String)relType, (String)subRelType, (String)relClassInverse, (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), (String)validationDate, null));
        }
        return rels;
    }

    private List<Oaf> addAffiliations(Document doc, OafEntity entity, DataInfo info) {
        ArrayList rels = Lists.newArrayList();
        for (Object o : doc.selectNodes("//datacite:affiliation[@affiliationIdentifierScheme='ROR']")) {
            Element element = (Element)o;
            String rorId = element.attributeValue("affiliationIdentifier");
            if (!StringUtils.isNotBlank((CharSequence)rorId)) continue;
            String fullRorId = "ror_________::" + rorId;
            String resultId = entity.getId();
            String orgId = OafMapperUtils.createOpenaireId((String)"organization", (String)fullRorId, (boolean)true);
            ArrayList properties = Lists.newArrayList();
            String apcAmount = doc.valueOf("//oaf:processingchargeamount");
            String apcCurrency = doc.valueOf("//oaf:processingchargeamount/@currency");
            if (StringUtils.isNotBlank((CharSequence)apcAmount) && StringUtils.isNotBlank((CharSequence)apcCurrency)) {
                properties.add(OafMapperUtils.keyValue((String)"apc_amount", (String)apcAmount));
                properties.add(OafMapperUtils.keyValue((String)"apc_currency", (String)apcCurrency));
            }
            rels.add(OafMapperUtils.getRelation((String)resultId, (String)orgId, (String)"resultOrganization", (String)"affiliation", (String)"hasAuthorInstitution", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, (List)properties));
            rels.add(OafMapperUtils.getRelation((String)orgId, (String)resultId, (String)"resultOrganization", (String)"affiliation", (String)"isAuthorInstitutionOf", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, (List)properties));
        }
        return rels;
    }

    protected abstract List<Oaf> addOtherResultRels(Document var1, OafEntity var2, DataInfo var3);

    private void populateResultFields(Result r, Document doc, Instance instance, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        r.setDataInfo(info);
        r.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
        r.setId(OafMapperUtils.createOpenaireId((int)50, (String)doc.valueOf("//dri:objIdentifier"), (boolean)false));
        r.setOriginalId(this.findOriginalId(doc));
        r.setCollectedfrom(Arrays.asList(collectedFrom));
        r.setPid(IdentifierFactory.getPids(this.prepareResultPids(doc, info), (KeyValue)collectedFrom));
        r.setDateofcollection(doc.valueOf("//dr:dateOfCollection/text()|//dri:dateOfCollection/text()"));
        r.setDateoftransformation(doc.valueOf("//dr:dateOfTransformation/text()|//dri:dateOfTransformation/text()"));
        r.setExtraInfo(new ArrayList());
        r.setOaiprovenance(this.prepareOAIprovenance(doc));
        r.setAuthor(this.prepareAuthors(doc, info));
        r.setLanguage(this.prepareLanguages(doc));
        r.setCountry(this.prepareCountries(doc, info));
        r.setSubject(this.prepareSubjects(doc, info));
        r.setTitle(this.prepareTitles(doc, info));
        r.setRelevantdate(this.prepareRelevantDates(doc, info));
        r.setDescription(this.prepareDescriptions(doc, info));
        r.setDateofacceptance(this.prepareField((Node)doc, "//oaf:dateAccepted", info));
        r.setPublisher(this.preparePublisher(doc, info));
        r.setEmbargoenddate(this.prepareField((Node)doc, "//oaf:embargoenddate", info));
        r.setSource(this.prepareSources(doc, info));
        r.setFulltext(this.prepareListURL((Node)doc, "//oaf:fulltext", info));
        r.setFormat(this.prepareFormats(doc, info));
        r.setContributor(this.prepareContributors(doc, info));
        r.setResourcetype(this.prepareResourceType(doc, info));
        r.setCoverage(this.prepareCoverages(doc, info));
        r.setContext(this.prepareContexts(doc, info));
        r.setExternalReference(new ArrayList());
        r.setProcessingchargeamount(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount"), (DataInfo)info));
        r.setProcessingchargecurrency(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount/@currency"), (DataInfo)info));
        r.setInstance(Arrays.asList(instance));
        r.setBestaccessright(OafMapperUtils.createBestAccessRights(Arrays.asList(instance)));
        r.setEoscifguidelines(this.prepareEOSCIfGuidelines(doc, info));
    }

    private List<Country> prepareCountries(Document doc, DataInfo info) {
        ArrayList<Country> list = new ArrayList<Country>();
        for (Object n : doc.selectNodes("//oaf:country")) {
            String code = ((Node)n).getText().trim();
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            Qualifier q = this.vocs.getTermAsQualifier("dnet:countries", code);
            Country country = new Country();
            country.setClassid(q.getClassid());
            country.setClassname(q.getClassname());
            country.setSchemeid(q.getSchemeid());
            country.setSchemename(q.getSchemename());
            country.setDataInfo(info);
            list.add(country);
        }
        return list;
    }

    protected abstract List<StructuredProperty> prepareResultPids(Document var1, DataInfo var2);

    private List<Context> prepareContexts(Document doc, DataInfo info) {
        ArrayList<Context> list = new ArrayList<Context>();
        for (Object o : doc.selectNodes("//oaf:concept")) {
            String cid = ((Node)o).valueOf("@id");
            if (!StringUtils.isNotBlank((CharSequence)cid)) continue;
            Context c = new Context();
            c.setId(cid);
            c.setDataInfo(Arrays.asList(info));
            list.add(c);
        }
        return list;
    }

    private List<EoscIfGuidelines> prepareEOSCIfGuidelines(Document doc, DataInfo info) {
        HashSet set = Sets.newHashSet();
        for (Object o : doc.selectNodes("//oaf:eoscifguidelines")) {
            String code = ((Node)o).valueOf("@code");
            String label = ((Node)o).valueOf("@label");
            String url = ((Node)o).valueOf("@url");
            String semrel = ((Node)o).valueOf("@semanticrelation");
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            EoscIfGuidelines eig = new EoscIfGuidelines();
            eig.setCode(code);
            eig.setLabel(label);
            eig.setUrl(url);
            eig.setSemanticRelation(semrel);
            set.add(eig);
        }
        return Lists.newArrayList((Iterable)set);
    }

    protected abstract Qualifier prepareResourceType(Document var1, DataInfo var2);

    protected abstract Instance prepareInstances(Document var1, DataInfo var2, KeyValue var3, KeyValue var4);

    protected abstract List<Field<String>> prepareSources(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareRelevantDates(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareCoverages(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareContributors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareFormats(Document var1, DataInfo var2);

    protected abstract Field<String> preparePublisher(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareDescriptions(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareTitles(Document var1, DataInfo var2);

    protected abstract List<Subject> prepareSubjects(Document var1, DataInfo var2);

    protected abstract Qualifier prepareLanguages(Document var1);

    protected abstract List<Author> prepareAuthors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductTools(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactGroups(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactPersons(Document var1, DataInfo var2);

    protected abstract Qualifier prepareSoftwareProgrammingLanguage(Document var1, DataInfo var2);

    protected abstract Field<String> prepareSoftwareCodeRepositoryUrl(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareSoftwareLicenses(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareSoftwareDocumentationUrls(Document var1, DataInfo var2);

    protected abstract List<GeoLocation> prepareDatasetGeoLocations(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetMetadataVersionNumber(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetLastMetadataUpdate(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetVersion(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetSize(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetDevice(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetStorageDate(Document var1, DataInfo var2);

    protected abstract String findOriginalType(Document var1);

    protected List<InstanceTypeMapping> prepareInstanceTypeMapping(Document doc) {
        return Optional.ofNullable(this.findOriginalType(doc)).map(originalType -> {
            ArrayList mappings = Lists.newArrayList();
            mappings.add(OafMapperUtils.instanceTypeMapping((String)originalType, (String)"openaire::coar_resource_types_3_1"));
            return mappings;
        }).orElse(new ArrayList());
    }

    private Journal prepareJournal(Document doc, DataInfo info) {
        Node n = doc.selectSingleNode("//oaf:journal");
        if (n != null) {
            String name = n.getText();
            String issnPrinted = n.valueOf("@issn");
            String issnOnline = n.valueOf("@eissn");
            String issnLinking = n.valueOf("@lissn");
            String ep = n.valueOf("@ep");
            String iss = n.valueOf("@iss");
            String sp = n.valueOf("@sp");
            String vol = n.valueOf("@vol");
            String edition = n.valueOf("@edition");
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return OafMapperUtils.journal((String)name, (String)issnPrinted, (String)issnOnline, (String)issnLinking, (String)ep, (String)iss, (String)sp, (String)vol, (String)edition, null, null, (DataInfo)info);
            }
        }
        return null;
    }

    private List<String> findOriginalId(Document doc) {
        String id;
        Node n = doc.selectSingleNode("//*[local-name()='provenance']/*[local-name()='originDescription']");
        if (n != null && StringUtils.isNotBlank((CharSequence)(id = n.valueOf("./*[local-name()='identifier']")))) {
            return Lists.newArrayList((Object[])new String[]{id});
        }
        List idList = doc.selectNodes("normalize-space(//*[local-name()='header']/*[local-name()='identifier' or local-name()='recordIdentifier']/text())");
        HashSet originalIds = Sets.newHashSet((Iterable)idList);
        if (originalIds.isEmpty()) {
            throw new IllegalStateException("missing originalID on " + doc.asXML());
        }
        return Lists.newArrayList((Iterable)originalIds);
    }

    protected AccessRight prepareAccessRight(Node node, String xpath, String schemeId) {
        Qualifier qualifier = this.prepareQualifier(node.valueOf(xpath).trim(), schemeId);
        AccessRight accessRight = new AccessRight();
        accessRight.setClassid(qualifier.getClassid());
        accessRight.setClassname(qualifier.getClassname());
        accessRight.setSchemeid(qualifier.getSchemeid());
        accessRight.setSchemename(qualifier.getSchemename());
        return accessRight;
    }

    protected Qualifier prepareQualifier(Node node, String xpath, String schemeId) {
        return this.prepareQualifier(node.valueOf(xpath).trim(), schemeId);
    }

    protected Qualifier prepareQualifier(String classId, String schemeId) {
        return this.vocs.getTermAsQualifier(schemeId, classId);
    }

    protected List<HashableStructuredProperty> prepareListStructPropsWithValidQualifier(Node node, String xpath, String xpathClassId, String schemeId, DataInfo info) {
        HashSet<HashableStructuredProperty> res = new HashSet<HashableStructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            String value;
            Node n = (Node)o;
            String classId = n.valueOf(xpathClassId).trim();
            if (!this.vocs.termExists(schemeId, classId) || !StringUtils.isNotBlank((CharSequence)(value = n.getText()))) continue;
            res.add(HashableStructuredProperty.newInstance((String)value, (Qualifier)this.vocs.getTermAsQualifier(schemeId, classId), (DataInfo)info));
        }
        return res.stream().filter(Objects::nonNull).filter(p -> StringUtils.isNotBlank((CharSequence)p.getValue())).filter(p -> StringUtils.isNotBlank((CharSequence)p.getValue().trim())).collect(Collectors.toList());
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, Qualifier qualifier, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(OafMapperUtils.structuredProperty((String)n.getText(), (Qualifier)qualifier, (DataInfo)info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(OafMapperUtils.structuredProperty((String)n.getText(), (String)n.valueOf("@classid"), (String)n.valueOf("@classname"), (String)n.valueOf("@schemeid"), (String)n.valueOf("@schemename"), (DataInfo)info));
        }
        return res;
    }

    protected List<Subject> prepareSubjectList(Node node, String xpath, DataInfo info) {
        ArrayList<Subject> res = new ArrayList<Subject>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(OafMapperUtils.subject((String)n.getText(), (String)n.valueOf("@classid"), (String)n.valueOf("@classname"), (String)n.valueOf("@schemeid"), (String)n.valueOf("@schemename"), (DataInfo)info));
        }
        return res;
    }

    protected OAIProvenance prepareOAIprovenance(Document doc) {
        Node n = doc.selectSingleNode("//*[local-name()='provenance']/*[local-name()='originDescription']");
        if (n == null) {
            return null;
        }
        String identifier = n.valueOf("./*[local-name()='identifier']");
        String baseURL = n.valueOf("./*[local-name()='baseURL']");
        String metadataNamespace = n.valueOf("./*[local-name()='metadataNamespace']");
        boolean altered = "true".equalsIgnoreCase(n.valueOf("@altered"));
        String datestamp = n.valueOf("./*[local-name()='datestamp']");
        String harvestDate = n.valueOf("@harvestDate");
        return OafMapperUtils.oaiIProvenance((String)identifier, (String)baseURL, (String)metadataNamespace, (Boolean)altered, (String)datestamp, (String)harvestDate);
    }

    protected DataInfo prepareDataInfo(Document doc, boolean invisible) {
        Node n = doc.selectSingleNode("//oaf:datainfo");
        if (n == null) {
            return OafMapperUtils.dataInfo((Boolean)false, null, (Boolean)false, (Boolean)invisible, (Qualifier)ModelConstants.REPOSITORY_PROVENANCE_ACTIONS, (String)"0.9");
        }
        String paClassId = n.valueOf("./oaf:provenanceaction/@classid");
        String paClassName = n.valueOf("./oaf:provenanceaction/@classname");
        String paSchemeId = n.valueOf("./oaf:provenanceaction/@schemeid");
        String paSchemeName = n.valueOf("./oaf:provenanceaction/@schemename");
        boolean deletedbyinference = Boolean.parseBoolean(n.valueOf("./oaf:deletedbyinference"));
        String inferenceprovenance = n.valueOf("./oaf:inferenceprovenance");
        Boolean inferred = Boolean.parseBoolean(n.valueOf("./oaf:inferred"));
        String trust = n.valueOf("./oaf:trust");
        return OafMapperUtils.dataInfo((Boolean)deletedbyinference, (String)inferenceprovenance, (Boolean)inferred, (Boolean)invisible, (Qualifier)OafMapperUtils.qualifier((String)paClassId, (String)paClassName, (String)paSchemeId, (String)paSchemeName), (String)trust);
    }

    protected List<Field<String>> prepareListURL(Node node, String xpath, DataInfo info) {
        return OafMapperUtils.listFields((DataInfo)info, this.prepareListString(node, xpath).stream().filter(arg_0 -> ((UrlValidator)URL_VALIDATOR).isValid(arg_0)).collect(Collectors.toList()));
    }

    protected Field<String> prepareField(Node node, String xpath, DataInfo info) {
        return OafMapperUtils.field((Object)node.valueOf(xpath), (DataInfo)info);
    }

    protected List<Field<String>> prepareListFields(Node node, String xpath, DataInfo info) {
        return OafMapperUtils.listFields((DataInfo)info, this.prepareListString(node, xpath));
    }

    protected List<String> prepareListString(Node node, String xpath) {
        ArrayList<String> res = new ArrayList<String>();
        for (Object o : node.selectNodes(xpath)) {
            String s = ((Node)o).getText().trim();
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            res.add(s);
        }
        return res;
    }

    protected Set<String> validateUrl(Collection<String> url) {
        if (Objects.isNull(url)) {
            return new HashSet<String>();
        }
        return url.stream().filter(arg_0 -> ((UrlValidator)URL_VALIDATOR).isValid(arg_0)).collect(Collectors.toCollection(HashSet::new));
    }

    static {
        nsContext.put("dr", "http://www.driver-repository.eu/namespace/dr");
        nsContext.put("dri", "http://www.driver-repository.eu/namespace/dri");
        nsContext.put("oaf", "http://namespace.openaire.eu/oaf");
        nsContext.put("oai", "http://www.openarchives.org/OAI/2.0/");
        nsContext.put("prov", "http://www.openarchives.org/OAI/2.0/provenance");
        nsContext.put("dc", "http://purl.org/dc/elements/1.1/");
        nsContext.put("datacite", DATACITE_SCHEMA_KERNEL_3);
        pidTypeWithAuthority = new HashMap<String, String>();
        IdentifierFactory.PID_AUTHORITY.keySet().stream().forEach(entry -> pidTypeWithAuthority.put(entry.toString().toLowerCase(), entry.toString()));
    }
}

