/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.reflections;

import eu.dnetlib.dhp.oa.graph.reflections.Prop;
import java.lang.reflect.Field;

class Cleaner {
    Cleaner() {
    }

    public void clean(Object o) throws IllegalArgumentException, IllegalAccessException {
        if (this.isPrimitive(o)) {
            return;
        }
        if (this.isIterable(o.getClass())) {
            for (Object elem : (Iterable)o) {
                this.clean(elem);
            }
        } else if (this.hasMapping(o)) {
            this.mapObject(o);
        } else {
            for (Field f : o.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object val = f.get(o);
                if (this.isPrimitive(val)) {
                    f.set(o, this.cleanValue(f.get(o)));
                    continue;
                }
                if (this.hasMapping(val)) {
                    this.mapObject(val);
                    continue;
                }
                this.clean(f.get(o));
            }
        }
    }

    private boolean hasMapping(Object o) {
        return o.getClass() == Prop.class;
    }

    private void mapObject(Object o) {
        if (o.getClass() == Prop.class) {
            ((Prop)o).setId("dnet:" + ((Prop)o).getId());
            ((Prop)o).setName("dnet:" + ((Prop)o).getName());
        }
    }

    private Object cleanValue(Object o) {
        if (o.getClass() == String.class) {
            return ((String)o).toUpperCase();
        }
        return o;
    }

    private boolean isIterable(Class<?> cl) {
        return Iterable.class.isAssignableFrom(cl);
    }

    private boolean isPrimitive(Object o) {
        return o.getClass() == String.class;
    }
}

