/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkConvertRDDtoDataset$ {
    public static final SparkConvertRDDtoDataset$ MODULE$ = new SparkConvertRDDtoDataset$();

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/convert_dataset_json_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master(parser.get("master")).getOrCreate();
        String sourcePath = parser.get("sourcePath");
        log.info("sourcePath  -> " + sourcePath);
        String t = parser.get("targetPath");
        log.info("targetPath  -> " + t);
        String subRelTypeFilter = parser.get("filterRelation");
        log.info("filterRelation  -> " + subRelTypeFilter);
        String entityPath = t + "/entities";
        String relPath = t + "/relation";
        ObjectMapper mapper = new ObjectMapper();
        Encoder datasetEncoder = Encoders$.MODULE$.kryo(Dataset.class);
        Encoder publicationEncoder = Encoders$.MODULE$.kryo(Publication.class);
        Encoder relationEncoder = Encoders$.MODULE$.kryo(Relation.class);
        Encoder orpEncoder = Encoders$.MODULE$.kryo(OtherResearchProduct.class);
        Encoder softwareEncoder = Encoders$.MODULE$.kryo(Software.class);
        log.info("Converting dataset");
        SparkContext qual$1 = spark.sparkContext();
        String x$1 = sourcePath + "/dataset";
        int x$2 = qual$1.textFile$default$2();
        RDD rddDataset = qual$1.textFile(x$1, x$2).map((Function1 & Serializable)s -> (Dataset)mapper.readValue(s, Dataset.class), ClassTag$.MODULE$.apply(Dataset.class)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$2(r)));
        spark.createDataset(rddDataset, datasetEncoder).as(datasetEncoder).write().mode(SaveMode.Overwrite).save(entityPath + "/dataset");
        log.info("Converting publication");
        SparkContext qual$2 = spark.sparkContext();
        String x$3 = sourcePath + "/publication";
        int x$4 = qual$2.textFile$default$2();
        RDD rddPublication = qual$2.textFile(x$3, x$4).map((Function1 & Serializable)s -> (Publication)mapper.readValue(s, Publication.class), ClassTag$.MODULE$.apply(Publication.class)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$4(r)));
        spark.createDataset(rddPublication, publicationEncoder).as(publicationEncoder).write().mode(SaveMode.Overwrite).save(entityPath + "/publication");
        log.info("Converting software");
        SparkContext qual$3 = spark.sparkContext();
        String x$5 = sourcePath + "/software";
        int x$6 = qual$3.textFile$default$2();
        RDD rddSoftware = qual$3.textFile(x$5, x$6).map((Function1 & Serializable)s -> (Software)mapper.readValue(s, Software.class), ClassTag$.MODULE$.apply(Software.class)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$6(r)));
        spark.createDataset(rddSoftware, softwareEncoder).as(softwareEncoder).write().mode(SaveMode.Overwrite).save(entityPath + "/software");
        log.info("Converting otherresearchproduct");
        SparkContext qual$4 = spark.sparkContext();
        String x$7 = sourcePath + "/otherresearchproduct";
        int x$8 = qual$4.textFile$default$2();
        RDD rddOtherResearchProduct = qual$4.textFile(x$7, x$8).map((Function1 & Serializable)s -> (OtherResearchProduct)mapper.readValue(s, OtherResearchProduct.class), ClassTag$.MODULE$.apply(OtherResearchProduct.class)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$8(r)));
        spark.createDataset(rddOtherResearchProduct, orpEncoder).as(orpEncoder).write().mode(SaveMode.Overwrite).save(entityPath + "/otherresearchproduct");
        log.info("Converting Relation");
        .colon.colon relClassFilter = new .colon.colon((Object)"merges", (List)new .colon.colon((Object)"isMergedIn", (List)new .colon.colon((Object)"HasAmongTopNSimilarDocuments", (List)new .colon.colon((Object)"IsAmongTopNSimilarDocuments", (List)Nil$.MODULE$))));
        SparkContext qual$5 = spark.sparkContext();
        String x$9 = sourcePath + "/relation";
        int x$10 = qual$5.textFile$default$2();
        RDD rddRelation = qual$5.textFile(x$9, x$10).map((Function1 & Serializable)s -> (Relation)mapper.readValue(s, Relation.class), ClassTag$.MODULE$.apply(Relation.class)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$10(r))).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$11(r))).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.MODULE$.filterRelations(r)));
        spark.createDataset(rddRelation, relationEncoder).as(relationEncoder).write().mode(SaveMode.Overwrite).save(String.valueOf(relPath));
    }

    private boolean filterRelations(Relation r) {
        .colon.colon relClassFilter = new .colon.colon((Object)"merges", (List)new .colon.colon((Object)"isMergedIn", (List)new .colon.colon((Object)"HasAmongTopNSimilarDocuments", (List)new .colon.colon((Object)"IsAmongTopNSimilarDocuments", (List)Nil$.MODULE$))));
        if (relClassFilter.exists((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)k.equalsIgnoreCase(r.getRelClass())))) {
            return false;
        }
        if (r.getCollectedfrom() == null || r.getCollectedfrom().size() == 0) {
            return false;
        }
        if (r.getCollectedfrom().size() > 1) {
            return true;
        }
        return r.getCollectedfrom().size() != 1 || r.getCollectedfrom().get(0) == null || !"OpenCitations".equalsIgnoreCase(((KeyValue)r.getCollectedfrom().get(0)).getValue());
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Dataset r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$4(Publication r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$6(Software r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$8(OtherResearchProduct r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Relation r) {
        return r.getDataInfo() != null && !Predef$.MODULE$.Boolean2boolean(r.getDataInfo().getDeletedbyinference());
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Relation r) {
        return r.getSource().startsWith("50") && r.getTarget().startsWith("50");
    }

    private SparkConvertRDDtoDataset$() {
    }
}

