/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.oa.graph.hostedbymap.DownloadCSV;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.UnibiGoldModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCsvTest {
    private static final Logger log = LoggerFactory.getLogger(DownloadCsvTest.class);
    private static String workingDir;
    private static LocalFileSystem fs;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(DownloadCsvTest.class.getSimpleName(), new FileAttribute[0]).toString();
        fs = FileSystem.getLocal((Configuration)new Configuration());
    }

    @Disabled
    @Test
    void getUnibiFileTest() throws CollectorException, IOException, ClassNotFoundException {
        String line;
        String fileURL = "https://pub.uni-bielefeld.de/download/2944717/2944718/issn_gold_oa_version_5.csv";
        String outputFile = workingDir + "/unibi_gold.json";
        new DownloadCSV().doDownload(fileURL, outputFile, UnibiGoldModel.class.getName(), ',', (FileSystem)fs);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(outputFile))));
        int count = 0;
        while ((line = in.readLine()) != null) {
            UnibiGoldModel unibi = (UnibiGoldModel)new ObjectMapper().readValue(line, UnibiGoldModel.class);
            if (count == 0) {
                Assertions.assertTrue((boolean)unibi.getIssn().equals("0001-625X"));
                Assertions.assertTrue((boolean)unibi.getIssnL().equals("0001-625X"));
                Assertions.assertTrue((boolean)unibi.getTitle().equals("Acta Mycologica"));
            }
            if (count == 43158) {
                Assertions.assertTrue((boolean)unibi.getIssn().equals("2088-6330"));
                Assertions.assertTrue((boolean)unibi.getIssnL().equals("2088-6330"));
                Assertions.assertTrue((boolean)unibi.getTitle().equals("Religi\u00f3: Jurnal Studi Agama-agama"));
            }
            if (count == 67027) {
                Assertions.assertTrue((boolean)unibi.getIssn().equals("2658-7068"));
                Assertions.assertTrue((boolean)unibi.getIssnL().equals("2308-2488"));
                Assertions.assertTrue((boolean)unibi.getTitle().equals("Istoriko-\u00e8konomi\u010deskie issledovani\u00e2."));
            }
            ++count;
        }
        Assertions.assertEquals((int)67028, (int)count);
    }

    @AfterAll
    public static void cleanup() {
        FileUtils.deleteQuietly((File)new File(workingDir));
    }
}

