/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.graph.hostedbymap.Aggregators$;
import eu.dnetlib.dhp.oa.graph.hostedbymap.HostedByItemType;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.EntityInfo;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.Publication;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class SparkPrepareHostedByInfoToApply$ {
    public static final SparkPrepareHostedByInfoToApply$ MODULE$;
    private final Encoder<EntityInfo> mapEncoderPInfo;

    static {
        new SparkPrepareHostedByInfoToApply$();
    }

    public Encoder<EntityInfo> mapEncoderPInfo() {
        return this.mapEncoderPInfo;
    }

    public List<EntityInfo> getList(String id, Journal j, String name) {
        Nil$ lst = Nil$.MODULE$;
        if (j.getIssnLinking() != null && !j.getIssnLinking().equals("")) {
            EntityInfo entityInfo = EntityInfo.newInstance(id, j.getIssnLinking(), name);
            lst = lst.$colon$colon((Object)entityInfo);
        }
        if (j.getIssnOnline() != null && !j.getIssnOnline().equals("")) {
            EntityInfo entityInfo = EntityInfo.newInstance(id, j.getIssnOnline(), name);
            lst = lst.$colon$colon((Object)entityInfo);
        }
        if (j.getIssnPrinted() != null && !j.getIssnPrinted().equals("")) {
            EntityInfo entityInfo = EntityInfo.newInstance(id, j.getIssnPrinted(), name);
            lst = lst.$colon$colon((Object)entityInfo);
        }
        return lst;
    }

    public Dataset<EntityInfo> prepareResultInfo(SparkSession spark, String publicationPath) {
        Encoder mapEncoderPubs = Encoders$.MODULE$.bean(Publication.class);
        ObjectMapper mapper = new ObjectMapper();
        Dataset dd = spark.read().textFile(publicationPath).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Publication apply(String r) {
                return (Publication)this.mapper$1.readValue(r, Publication.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, mapEncoderPubs);
        return dd.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Publication p) {
                return p.getJournal() != null;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<EntityInfo> apply(Publication p) {
                return SparkPrepareHostedByInfoToApply$.MODULE$.getList(p.getId(), p.getJournal(), "");
            }
        }, this.mapEncoderPInfo());
    }

    public EntityInfo toEntityInfo(String input) {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Map c = (Map)package$.MODULE$.jvalue2extractable(this.json$1(input, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(HostedByItemType.class)})));
        return this.toEntityItem((String)c.keys().head(), (HostedByItemType)c.values().head());
    }

    public EntityInfo toEntityItem(String journal_id, HostedByItemType hbi) {
        return EntityInfo.newInstance(hbi.id(), journal_id, hbi.officialname(), Predef$.MODULE$.boolean2Boolean(hbi.openAccess()));
    }

    public Dataset<EntityInfo> joinResHBM(Dataset<EntityInfo> res, Dataset<EntityInfo> hbm) {
        return Aggregators$.MODULE$.resultToSingleId((Dataset<EntityInfo>)res.joinWith(hbm, res.col("journalId").equalTo((Object)hbm.col("journalId")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final EntityInfo apply(Tuple2<EntityInfo, EntityInfo> t2) {
                void var2_2;
                EntityInfo res = (EntityInfo)t2._1();
                if (t2._2() != null) {
                    EntityInfo ds = (EntityInfo)t2._2();
                    res.setHostedById(ds.getId());
                    res.setOpenAccess(ds.getOpenAccess());
                    res.setName(ds.getName());
                }
                return var2_2;
            }
        }, this.mapEncoderPInfo()));
    }

    public void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hostedbymap/hostedby_prepare_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String graphPath = parser.get("graphPath");
        String outputPath = parser.get("preparedInfoPath");
        String hostedByMapPath = parser.get("hostedByMapPath");
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        logger.info("Getting the Datasources");
        Dataset hostedByInfo = spark.createDataset(spark.sparkContext().textFile(hostedByMapPath, spark.sparkContext().textFile$default$2()), spark.implicits().newStringEncoder()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EntityInfo apply(String input) {
                return SparkPrepareHostedByInfoToApply$.MODULE$.toEntityInfo(input);
            }
        }, this.mapEncoderPInfo());
        Dataset<EntityInfo> resultInfoDataset = this.prepareResultInfo(spark, new StringBuilder().append((Object)graphPath).append((Object)"/publication").toString());
        this.joinResHBM(resultInfoDataset, (Dataset<EntityInfo>)hostedByInfo).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        SparkPrepareHostedByInfoToApply$ sparkPrepareHostedByInfoToApply$ = this;
        synchronized (sparkPrepareHostedByInfoToApply$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        SparkPrepareHostedByInfoToApply$ sparkPrepareHostedByInfoToApply$ = this;
        synchronized (sparkPrepareHostedByInfoToApply$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private SparkPrepareHostedByInfoToApply$() {
        MODULE$ = this;
        this.mapEncoderPInfo = Encoders$.MODULE$.bean(EntityInfo.class);
    }
}

