/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.reflections;

import eu.dnetlib.dhp.oa.graph.reflections.Author;
import eu.dnetlib.dhp.oa.graph.reflections.Cleaner;
import eu.dnetlib.dhp.oa.graph.reflections.Prop;
import eu.dnetlib.dhp.oa.graph.reflections.Publication;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReflectionTest {
    private final Cleaner cleaner = new Cleaner();

    ReflectionTest() {
    }

    @Test
    void testObject() throws Exception {
        Publication pub = new Publication();
        pub.setTitle("openaire guidelines");
        pub.getAuthors().add(new Author("Michele Artini", new Prop("aa-001", "orcid")));
        pub.getAuthors().add(new Author("Claudio Atzori", new Prop("aa-002", "orcid")));
        pub.getAuthors().add(new Author("Alessia Bardi", new Prop("aa-003", "orcid")));
        pub.getSubjects().add(new Prop("infrastructures", "keyword"));
        pub.getSubjects().add(new Prop("digital libraries", "keyword"));
        this.cleaner.clean(pub);
        System.out.println(pub);
        Assertions.assertEquals((Object)"OPENAIRE GUIDELINES", (Object)pub.getTitle());
        Assertions.assertEquals((Object)"MICHELE ARTINI", (Object)pub.getAuthors().get(0).getName());
        Assertions.assertEquals((Object)"CLAUDIO ATZORI", (Object)pub.getAuthors().get(1).getName());
        Assertions.assertEquals((Object)"ALESSIA BARDI", (Object)pub.getAuthors().get(2).getName());
        Assertions.assertEquals((Object)"dnet:aa-001", (Object)pub.getAuthors().get(0).getId().getId());
        Assertions.assertEquals((Object)"dnet:aa-002", (Object)pub.getAuthors().get(1).getId().getId());
        Assertions.assertEquals((Object)"dnet:aa-003", (Object)pub.getAuthors().get(2).getId().getId());
        Assertions.assertEquals((Object)"dnet:orcid", (Object)pub.getAuthors().get(0).getId().getName());
        Assertions.assertEquals((Object)"dnet:orcid", (Object)pub.getAuthors().get(1).getId().getName());
        Assertions.assertEquals((Object)"dnet:orcid", (Object)pub.getAuthors().get(2).getId().getName());
        Assertions.assertEquals((Object)"dnet:infrastructures", (Object)pub.getSubjects().get(0).getId());
        Assertions.assertEquals((Object)"dnet:keyword", (Object)pub.getSubjects().get(0).getName());
        Assertions.assertEquals((Object)"dnet:digital libraries", (Object)pub.getSubjects().get(1).getId());
        Assertions.assertEquals((Object)"dnet:keyword", (Object)pub.getSubjects().get(1).getName());
    }
}

