/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.clean.CleaningRuleMap;
import eu.dnetlib.dhp.oa.graph.clean.OafCleaner;
import eu.dnetlib.dhp.oa.graph.raw.OafToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.OdfToOafMapper;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MappersTest {
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private VocabularyGroup vocs;

    MappersTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(this.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(this.synonyms());
        this.vocs = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
    }

    @Test
    void testPublication() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_record.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((long)1L, (long)list.stream().filter(o -> o instanceof Publication).count());
        Assertions.assertEquals((long)4L, (long)list.stream().filter(o -> o instanceof Relation).count());
        Publication p = (Publication)list.stream().filter(o -> o instanceof Publication).findFirst().get();
        this.assertValidId(p.getId());
        Assertions.assertEquals((int)2, (int)p.getOriginalId().size());
        Assertions.assertTrue((boolean)p.getOriginalId().contains("10.3897/oneeco.2.e13718"));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertFalse((boolean)p.getDataInfo().getInvisible());
        Assertions.assertEquals((int)1, (int)p.getSource().size());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getDateofcollection()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getDateoftransformation()));
        Assertions.assertFalse((boolean)p.getAuthor().isEmpty());
        Optional<Author> author = p.getAuthor().stream().filter(a -> a.getPid() != null && !a.getPid().isEmpty()).findFirst();
        Assertions.assertTrue((boolean)author.isPresent());
        StructuredProperty pid = (StructuredProperty)author.get().getPid().stream().findFirst().orElseThrow(() -> new IllegalStateException("missing author pid"));
        Assertions.assertEquals((Object)"0000-0001-6651-1178", (Object)pid.getValue());
        Assertions.assertEquals((Object)"orcid_pending", (Object)pid.getQualifier().getClassid());
        Assertions.assertEquals((Object)"Open Researcher and Contributor ID", (Object)pid.getQualifier().getClassname());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemeid());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemename());
        Assertions.assertEquals((Object)"Votsi,Nefta", (Object)author.get().getFullname());
        Assertions.assertEquals((Object)"Votsi", (Object)author.get().getSurname());
        Assertions.assertEquals((Object)"Nefta", (Object)author.get().getName());
        Assertions.assertFalse((boolean)p.getSubject().isEmpty());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getJournal().getIssnOnline()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getJournal().getName()));
        Assertions.assertTrue((boolean)p.getPid().isEmpty());
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        p.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getAccessright());
            Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        });
        Instance instance = (Instance)p.getInstance().get(0);
        Assertions.assertEquals((Object)"0001", (Object)instance.getRefereed().getClassid());
        Assertions.assertNotNull((Object)instance.getPid());
        Assertions.assertTrue((boolean)instance.getPid().isEmpty());
        Assertions.assertNotNull((Object)instance.getInstanceTypeMapping());
        Assertions.assertEquals((int)1, (int)instance.getInstanceTypeMapping().size());
        Optional<InstanceTypeMapping> coarType = instance.getInstanceTypeMapping().stream().filter(itm -> "openaire::coar_resource_types_3_1".equals(itm.getVocabularyName())).findFirst();
        Assertions.assertTrue((boolean)coarType.isPresent());
        Assertions.assertNull((Object)coarType.get().getTypeCode());
        Assertions.assertNull((Object)coarType.get().getTypeLabel());
        Optional<InstanceTypeMapping> userType = instance.getInstanceTypeMapping().stream().filter(itm -> "openaire::user_resource_types".equals(itm.getVocabularyName())).findFirst();
        Assertions.assertFalse((boolean)userType.isPresent());
        Assertions.assertFalse((boolean)instance.getAlternateIdentifier().isEmpty());
        Assertions.assertEquals((Object)"doi", (Object)((StructuredProperty)instance.getAlternateIdentifier().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"10.3897/oneeco.2.e13718", (Object)((StructuredProperty)instance.getAlternateIdentifier().get(0)).getValue());
        Assertions.assertNotNull((Object)instance.getFulltext());
        Assertions.assertEquals((Object)"https://oneecosystem.pensoft.net/article/13718/", (Object)instance.getFulltext());
        Assertions.assertNotNull((Object)p.getBestaccessright());
        Assertions.assertEquals((Object)"OPEN", (Object)p.getBestaccessright().getClassid());
        Assertions.assertNotNull((Object)p.getFulltext());
        Assertions.assertEquals((int)1, (int)p.getFulltext().size());
        Assertions.assertEquals((Object)"https://oneecosystem.pensoft.net/article/13718/", (Object)((Field)p.getFulltext().get(0)).getValue());
        List resultProject = list.stream().filter(o -> o instanceof Relation).map(o -> (Relation)o).filter(r -> "resultProject".equals(r.getRelType())).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)resultProject.size());
        Relation rp1 = (Relation)resultProject.get(0);
        Relation rp2 = (Relation)resultProject.get(1);
        this.verifyRelation(rp1);
        this.verifyRelation(rp2);
        Assertions.assertTrue((boolean)rp1.getValidated());
        Assertions.assertTrue((boolean)rp2.getValidated());
        Assertions.assertEquals((Object)"2020-01-01", (Object)rp1.getValidationDate());
        Assertions.assertEquals((Object)"2020-01-01", (Object)rp2.getValidationDate());
        Assertions.assertEquals((Object)rp1.getSource(), (Object)rp2.getTarget());
        Assertions.assertEquals((Object)rp2.getSource(), (Object)rp1.getTarget());
        List affiliation = list.stream().filter(o -> o instanceof Relation).map(o -> (Relation)o).filter(r -> "resultOrganization".equals(r.getRelType())).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)affiliation.size());
        Relation aff1 = (Relation)affiliation.get(0);
        Relation aff2 = (Relation)affiliation.get(1);
        this.verifyRelation(aff1);
        this.verifyRelation(aff2);
        Assertions.assertEquals((Object)aff1.getSource(), (Object)aff2.getTarget());
        Assertions.assertEquals((Object)aff2.getSource(), (Object)aff1.getTarget());
        Assertions.assertEquals((int)3, (int)p.getCountry().size());
        Assertions.assertEquals((Object)"IT", (Object)((Country)p.getCountry().get(0)).getClassid());
        Assertions.assertEquals((Object)"FR", (Object)((Country)p.getCountry().get(1)).getClassid());
        Assertions.assertEquals((Object)"DE", (Object)((Country)p.getCountry().get(2)).getClassid());
    }

    private void verifyRelation(Relation r) {
        this.assertValidId(r.getSource());
        this.assertValidId(r.getTarget());
        this.assertValidId(((KeyValue)r.getCollectedfrom().get(0)).getKey());
        Assertions.assertNotNull((Object)r.getDataInfo());
        Assertions.assertNotNull((Object)r.getDataInfo().getTrust());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r.getRelType()));
    }

    @Test
    void testPublication_PubMed() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_record_pubmed.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Publication));
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        Assertions.assertEquals((int)2, (int)p.getOriginalId().size());
        Assertions.assertTrue((boolean)p.getOriginalId().contains("oai:pubmedcentral.nih.gov:1517292"));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertFalse((boolean)p.getDataInfo().getInvisible());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getDateofcollection()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)p.getDateoftransformation()));
        Assertions.assertFalse((boolean)p.getAuthor().isEmpty());
        Optional<Author> author = p.getAuthor().stream().filter(a -> a.getPid() != null && !a.getPid().isEmpty()).findFirst();
        Assertions.assertTrue((boolean)author.isPresent());
        StructuredProperty pid = (StructuredProperty)author.get().getPid().stream().findFirst().get();
        Assertions.assertEquals((Object)"0000-0001-6651-1178", (Object)pid.getValue());
        Assertions.assertEquals((Object)"orcid_pending", (Object)pid.getQualifier().getClassid());
        Assertions.assertEquals((Object)"Open Researcher and Contributor ID", (Object)pid.getQualifier().getClassname());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemeid());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemename());
        Assertions.assertEquals((Object)"Votsi,Nefta", (Object)author.get().getFullname());
        Assertions.assertEquals((Object)"Votsi", (Object)author.get().getSurname());
        Assertions.assertEquals((Object)"Nefta", (Object)author.get().getName());
        Assertions.assertFalse((boolean)p.getSubject().isEmpty());
        Assertions.assertFalse((boolean)p.getPid().isEmpty());
        Assertions.assertTrue((boolean)p.getPid().stream().anyMatch(pi -> "pmc".equals(pi.getQualifier().getClassid())));
        Assertions.assertEquals((Object)"PMC1517292", (Object)p.getPid().stream().filter(pi -> "pmc".equals(pi.getQualifier().getClassid())).findFirst().get().getValue());
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        p.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getAccessright());
            Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        });
        Publication p_cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p, (VocabularyGroup)this.vocs);
        Assertions.assertEquals((Object)"0002", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"nonPeerReviewed", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassname());
        Assertions.assertNotNull((Object)((Instance)p.getInstance().get(0)).getPid());
        Assertions.assertEquals((int)2, (int)((Instance)p.getInstance().get(0)).getPid().size());
        Assertions.assertEquals((int)1, (int)((Instance)p.getInstance().get(0)).getAlternateIdentifier().size());
        Assertions.assertEquals((Object)"doi", (Object)((StructuredProperty)((Instance)p.getInstance().get(0)).getAlternateIdentifier().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"10.3897/oneeco.2.e13718", (Object)((StructuredProperty)((Instance)p.getInstance().get(0)).getAlternateIdentifier().get(0)).getValue());
        Assertions.assertNotNull((Object)p.getBestaccessright());
        Assertions.assertEquals((Object)"OPEN", (Object)p.getBestaccessright().getClassid());
    }

    @Test
    void testPublicationInvisible() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_record.xml")));
        List list = new OafToOafMapper(this.vocs, true, true).processMdRecord(xml);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Publication));
        Publication p = (Publication)list.get(0);
        Assertions.assertTrue((boolean)p.getDataInfo().getInvisible());
    }

    @Test
    void testPublicationInvisible_BASE() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_record_base.xml")));
        List list = new OdfToOafMapper(this.vocs, true, true).processMdRecord(xml);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Publication));
        Publication p = (Publication)list.get(0);
        Assertions.assertTrue((boolean)p.getDataInfo().getInvisible());
        System.out.println(new ObjectMapper().writeValueAsString((Object)p));
    }

    @Test
    void testOdfFwfEBookLibrary() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_fwfebooklibrary.xml")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml));
    }

    @Test
    void testDataset() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_dataset.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Dataset));
        Assertions.assertTrue((boolean)(list.get(1) instanceof Relation));
        Assertions.assertTrue((boolean)(list.get(2) instanceof Relation));
        Dataset d = (Dataset)list.get(0);
        Relation r1 = (Relation)list.get(1);
        Relation r2 = (Relation)list.get(2);
        Assertions.assertEquals((Object)d.getId(), (Object)r1.getTarget());
        Assertions.assertEquals((Object)"40|corda_______::e06332dee33bec6c2ba4c98601053229", (Object)r1.getSource());
        Assertions.assertEquals((Object)"resultProject", (Object)r1.getRelType());
        Assertions.assertEquals((Object)"outcome", (Object)r1.getSubRelType());
        Assertions.assertEquals((Object)"produces", (Object)r1.getRelClass());
        Assertions.assertTrue((boolean)r1.getValidated());
        Assertions.assertEquals((Object)"2020-01-01", (Object)r1.getValidationDate());
        Assertions.assertEquals((Object)d.getId(), (Object)r2.getSource());
        Assertions.assertEquals((Object)"40|corda_______::e06332dee33bec6c2ba4c98601053229", (Object)r2.getTarget());
        Assertions.assertEquals((Object)"resultProject", (Object)r2.getRelType());
        Assertions.assertEquals((Object)"outcome", (Object)r2.getSubRelType());
        Assertions.assertEquals((Object)"isProducedBy", (Object)r2.getRelClass());
        Assertions.assertTrue((boolean)r2.getValidated());
        Assertions.assertEquals((Object)"2020-01-01", (Object)r2.getValidationDate());
        this.assertValidId(d.getId());
        Assertions.assertEquals((Object)"50|doi_________::000374d100a9db469bd42b69dbb40b36", (Object)d.getId());
        Assertions.assertEquals((int)2, (int)d.getOriginalId().size());
        Assertions.assertTrue((boolean)d.getOriginalId().stream().anyMatch(oid -> oid.equals("oai:zenodo.org:3234526")));
        this.assertValidId(((KeyValue)d.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)d.getTitle().get(0)).getValue()));
        Assertions.assertFalse((boolean)d.getAuthor().isEmpty());
        Optional<Author> author = d.getAuthor().stream().filter(a -> a.getPid() != null && !a.getPid().isEmpty()).findFirst();
        Assertions.assertTrue((boolean)author.isPresent());
        Optional oPid = author.get().getPid().stream().findFirst();
        Assertions.assertTrue((boolean)oPid.isPresent());
        StructuredProperty pid = (StructuredProperty)oPid.get();
        Assertions.assertEquals((Object)"0000-0001-9074-1619", (Object)pid.getValue());
        Assertions.assertEquals((Object)"orcid_pending", (Object)pid.getQualifier().getClassid());
        Assertions.assertEquals((Object)"Open Researcher and Contributor ID", (Object)pid.getQualifier().getClassname());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemeid());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)pid.getQualifier().getSchemename());
        Assertions.assertEquals((Object)"Baracchini, Theo", (Object)author.get().getFullname());
        Assertions.assertEquals((Object)"Baracchini", (Object)author.get().getSurname());
        Assertions.assertEquals((Object)"Theo", (Object)author.get().getName());
        Assertions.assertEquals((int)1, (int)author.get().getRawAffiliationString().size());
        Optional opAff = author.get().getRawAffiliationString().stream().findFirst();
        Assertions.assertTrue((boolean)opAff.isPresent());
        String affiliation = (String)opAff.get();
        Assertions.assertEquals((Object)"ISTI-CNR", (Object)affiliation);
        Assertions.assertFalse((boolean)d.getSubject().isEmpty());
        Assertions.assertFalse((boolean)d.getInstance().isEmpty());
        Assertions.assertFalse((boolean)d.getContext().isEmpty());
        Assertions.assertFalse((boolean)((Context)d.getContext().get(0)).getId().isEmpty());
        Assertions.assertNotNull((Object)d.getInstance());
        Assertions.assertFalse((boolean)d.getInstance().isEmpty());
        d.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getAccessright());
            Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        });
        Assertions.assertEquals((Object)"0001", (Object)((Instance)d.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertNotNull((Object)((Instance)d.getInstance().get(0)).getPid());
        Assertions.assertFalse((boolean)((Instance)d.getInstance().get(0)).getPid().isEmpty());
        Assertions.assertEquals((Object)"doi", (Object)((StructuredProperty)((Instance)d.getInstance().get(0)).getPid().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"10.5281/zenodo.3234526", (Object)((StructuredProperty)((Instance)d.getInstance().get(0)).getPid().get(0)).getValue());
        Assertions.assertTrue((boolean)((Instance)d.getInstance().get(0)).getAlternateIdentifier().isEmpty());
        this.assertValidId(r1.getSource());
        this.assertValidId(r1.getTarget());
        this.assertValidId(r2.getSource());
        this.assertValidId(r2.getTarget());
        Assertions.assertNotNull((Object)r1.getDataInfo());
        Assertions.assertNotNull((Object)r2.getDataInfo());
        Assertions.assertNotNull((Object)r1.getDataInfo().getTrust());
        Assertions.assertNotNull((Object)r2.getDataInfo().getTrust());
        Assertions.assertEquals((Object)r1.getSource(), (Object)r2.getTarget());
        Assertions.assertEquals((Object)r2.getSource(), (Object)r1.getTarget());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelType()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelType()));
        Assertions.assertTrue((boolean)r1.getValidated());
        Assertions.assertTrue((boolean)r2.getValidated());
        Assertions.assertEquals((Object)"2020-01-01", (Object)r1.getValidationDate());
        Assertions.assertEquals((Object)"2020-01-01", (Object)r2.getValidationDate());
        Assertions.assertNotNull((Object)d.getTitle());
        Assertions.assertEquals((int)2, (int)d.getTitle().size());
        this.verifyTitle(d, "main title", "Temperature and ADCP data collected on Lake Geneva between 2015 and 2017");
        this.verifyTitle(d, "Subtitle", "survey");
    }

    private void verifyTitle(Dataset d, String titleType, String title) {
        Optional.of(d.getTitle().stream().filter(t -> titleType.equals(t.getQualifier().getClassid())).collect(Collectors.toList())).ifPresent(t -> {
            Assertions.assertEquals((int)1, (int)t.size());
            Assertions.assertEquals((Object)title, (Object)((StructuredProperty)t.get(0)).getValue());
        });
    }

    @Test
    void testOdfBielefeld() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_bielefeld.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Publication));
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        Assertions.assertEquals((int)2, (int)p.getOriginalId().size());
        Assertions.assertTrue((boolean)p.getOriginalId().stream().anyMatch(oid -> oid.equals("oai:pub.uni-bielefeld.de:2949739")));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertFalse((boolean)p.getAuthor().isEmpty());
        Optional author = p.getAuthor().stream().findFirst();
        Assertions.assertTrue((boolean)author.isPresent());
        Assertions.assertEquals((Object)"Potwarka, Luke R.", (Object)((Author)author.get()).getFullname());
        Assertions.assertEquals((Object)"Potwarka", (Object)((Author)author.get()).getSurname());
        Assertions.assertEquals((Object)"Luke R.", (Object)((Author)author.get()).getName());
        Assertions.assertFalse((boolean)p.getSubject().isEmpty());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        Assertions.assertNotNull((Object)p.getTitle());
        Assertions.assertFalse((boolean)p.getTitle().isEmpty());
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        p.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getAccessright());
            Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        });
        Publication p_cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p, (VocabularyGroup)this.vocs);
        Assertions.assertEquals((Object)"0002", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"nonPeerReviewed", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassname());
    }

    @Test
    void testOpentrial() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_opentrial.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Dataset));
        Dataset d = (Dataset)list.get(0);
        Assertions.assertNotNull((Object)d.getDateofcollection());
        Assertions.assertEquals((Object)"2019-03-27T15:15:22.22Z", (Object)d.getDateofcollection());
        Assertions.assertNotNull((Object)d.getDateoftransformation());
        Assertions.assertEquals((Object)"2019-04-17T16:04:20.586Z", (Object)d.getDateoftransformation());
        Assertions.assertNotNull((Object)d.getDataInfo());
        Assertions.assertFalse((boolean)d.getDataInfo().getInvisible());
        Assertions.assertFalse((boolean)d.getDataInfo().getDeletedbyinference());
        Assertions.assertEquals((Object)"0.9", (Object)d.getDataInfo().getTrust());
        Assertions.assertEquals((Object)"", (Object)d.getDataInfo().getInferenceprovenance());
        Assertions.assertEquals((Object)"sysimport:crosswalk:datasetarchive", (Object)d.getDataInfo().getProvenanceaction().getClassid());
        Assertions.assertEquals((Object)"sysimport:crosswalk:datasetarchive", (Object)d.getDataInfo().getProvenanceaction().getClassname());
        Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)d.getDataInfo().getProvenanceaction().getSchemeid());
        Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)d.getDataInfo().getProvenanceaction().getSchemename());
        this.assertValidId(d.getId());
        Assertions.assertEquals((int)2, (int)d.getOriginalId().size());
        Assertions.assertEquals((Object)"feabb67c-1fd1-423b-aec6-606d04ce53c6", d.getOriginalId().get(0));
        this.assertValidId(((KeyValue)d.getCollectedfrom().get(0)).getKey());
        Assertions.assertNotNull((Object)d.getTitle());
        Assertions.assertEquals((int)1, (int)d.getTitle().size());
        Assertions.assertEquals((Object)"Validation of the Goodstrength System for Assessment of Abdominal Wall Strength in Patients With Incisional Hernia", (Object)((StructuredProperty)d.getTitle().get(0)).getValue());
        Assertions.assertNotNull((Object)d.getDescription());
        Assertions.assertEquals((int)1, (int)d.getDescription().size());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)d.getDescription().get(0)).getValue())));
        Assertions.assertEquals((int)1, (int)d.getAuthor().size());
        Assertions.assertEquals((Object)"Jensen, Kristian K", (Object)((Author)d.getAuthor().get(0)).getFullname());
        Assertions.assertEquals((Object)"Kristian K.", (Object)((Author)d.getAuthor().get(0)).getName());
        Assertions.assertEquals((Object)"Jensen", (Object)((Author)d.getAuthor().get(0)).getSurname());
        Assertions.assertNotNull((Object)((Author)d.getAuthor().get(0)).getPid());
        Assertions.assertTrue((boolean)((Author)d.getAuthor().get(0)).getPid().isEmpty());
        Assertions.assertNotNull((Object)d.getPid());
        Assertions.assertEquals((int)0, (int)d.getPid().size());
        Assertions.assertNotNull((Object)d.getPublisher());
        Assertions.assertEquals((Object)"nct", (Object)d.getPublisher().getValue());
        Assertions.assertTrue((boolean)d.getSubject().isEmpty());
        Assertions.assertTrue((boolean)d.getContext().isEmpty());
        Assertions.assertNotNull((Object)d.getInstance());
        Assertions.assertEquals((int)1, (int)d.getInstance().size());
        Instance i = (Instance)d.getInstance().get(0);
        Assertions.assertNotNull((Object)i.getAccessright());
        Assertions.assertEquals((Object)"dnet:access_modes", (Object)i.getAccessright().getSchemeid());
        Assertions.assertEquals((Object)"dnet:access_modes", (Object)i.getAccessright().getSchemename());
        Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        Assertions.assertEquals((Object)"Open Access", (Object)i.getAccessright().getClassname());
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertEquals((Object)"10|openaire____::b292fc2d7de505f78e3cae1b06ea8548", (Object)i.getCollectedfrom().getKey());
        Assertions.assertEquals((Object)"OpenTrials", (Object)i.getCollectedfrom().getValue());
        Assertions.assertNotNull((Object)i.getHostedby());
        Assertions.assertEquals((Object)"10|openaire____::b292fc2d7de505f78e3cae1b06ea8548", (Object)i.getHostedby().getKey());
        Assertions.assertEquals((Object)"OpenTrials", (Object)i.getHostedby().getValue());
        Assertions.assertNotNull((Object)i.getInstancetype());
        Assertions.assertEquals((Object)"0037", (Object)i.getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Clinical Trial", (Object)i.getInstancetype().getClassname());
        Assertions.assertEquals((Object)"dnet:publication_resource", (Object)i.getInstancetype().getSchemeid());
        Assertions.assertEquals((Object)"dnet:publication_resource", (Object)i.getInstancetype().getSchemename());
        Assertions.assertNull((Object)i.getLicense());
        Assertions.assertNotNull((Object)i.getDateofacceptance());
        Assertions.assertEquals((Object)"2014-11-11", (Object)i.getDateofacceptance().getValue());
        Assertions.assertNull((Object)i.getDistributionlocation());
        Assertions.assertNull((Object)i.getProcessingchargeamount());
        Assertions.assertNull((Object)i.getProcessingchargecurrency());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertEquals((int)0, (int)i.getPid().size());
        Assertions.assertNotNull((Object)i.getAlternateIdentifier());
        Assertions.assertEquals((int)1, (int)i.getAlternateIdentifier().size());
        Assertions.assertEquals((Object)"NCT02321059", (Object)((StructuredProperty)i.getAlternateIdentifier().get(0)).getValue());
        Assertions.assertEquals((Object)"nct", (Object)((StructuredProperty)i.getAlternateIdentifier().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"ClinicalTrials.gov Identifier", (Object)((StructuredProperty)i.getAlternateIdentifier().get(0)).getQualifier().getClassname());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)((StructuredProperty)i.getAlternateIdentifier().get(0)).getQualifier().getSchemeid());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)((StructuredProperty)i.getAlternateIdentifier().get(0)).getQualifier().getSchemename());
        Assertions.assertNotNull((Object)i.getUrl());
        Assertions.assertEquals((int)2, (int)i.getUrl().size());
        Assertions.assertTrue((boolean)i.getUrl().contains("http://apps.who.int/trialsearch/Trial3.aspx?trialid=NCT02321059"));
        Assertions.assertTrue((boolean)i.getUrl().contains("https://clinicaltrials.gov/ct2/show/NCT02321059"));
        Dataset d_cleaned = (Dataset)GraphCleaningFunctions.cleanup((Oaf)d, (VocabularyGroup)this.vocs);
        Assertions.assertEquals((Object)"0002", (Object)((Instance)d_cleaned.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"nonPeerReviewed", (Object)((Instance)d_cleaned.getInstance().get(0)).getRefereed().getClassname());
    }

    @Test
    void test_record_from_Crossref() throws IOException {
        CleaningRuleMap mapping = CleaningRuleMap.create((VocabularyGroup)this.vocs);
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_crossref.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Publication));
        Publication p = (Publication)OafCleaner.apply((Oaf)((Publication)GraphCleaningFunctions.fixVocabularyNames((Oaf)((Publication)list.get(0)))), (CleaningRuleMap)mapping);
        Assertions.assertNotNull((Object)p.getDateofcollection());
        Assertions.assertEquals((Object)"2020-08-06T07:04:09.62Z", (Object)p.getDateofcollection());
        Assertions.assertNotNull((Object)p.getDateoftransformation());
        Assertions.assertEquals((Object)"2020-08-06T07:20:57.911Z", (Object)p.getDateoftransformation());
        Assertions.assertNotNull((Object)p.getDataInfo());
        Assertions.assertFalse((boolean)p.getDataInfo().getInvisible());
        Assertions.assertFalse((boolean)p.getDataInfo().getDeletedbyinference());
        Assertions.assertEquals((Object)"0.9", (Object)p.getDataInfo().getTrust());
        this.assertValidId(p.getId());
        Assertions.assertEquals((int)2, (int)p.getOriginalId().size());
        Assertions.assertEquals((Object)"50|doi_________::7f0f7807f17db50e5c2b5c452ccaf06d", p.getOriginalId().get(0));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertNotNull((Object)p.getTitle());
        Assertions.assertEquals((int)1, (int)p.getTitle().size());
        Assertions.assertEquals((Object)"A case report of serious haemolysis in a glucose-6-phosphate dehydrogenase-deficient COVID-19 patient receiving hydroxychloroquine", (Object)((StructuredProperty)p.getTitle().get(0)).getValue());
        Assertions.assertNotNull((Object)p.getDescription());
        Assertions.assertEquals((int)0, (int)p.getDescription().size());
        Assertions.assertEquals((int)8, (int)p.getAuthor().size());
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertEquals((int)1, (int)p.getInstance().size());
        Instance i = (Instance)p.getInstance().get(0);
        Assertions.assertNotNull((Object)i.getAccessright());
        Assertions.assertEquals((Object)"dnet:access_modes", (Object)i.getAccessright().getSchemeid());
        Assertions.assertEquals((Object)"dnet:access_modes", (Object)i.getAccessright().getSchemename());
        Assertions.assertEquals((Object)"OPEN", (Object)i.getAccessright().getClassid());
        Assertions.assertEquals((Object)"Open Access", (Object)i.getAccessright().getClassname());
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertEquals((Object)"10|openaire____::081b82f96300b6a6e3d282bad31cb6e2", (Object)i.getCollectedfrom().getKey());
        Assertions.assertEquals((Object)"Crossref", (Object)i.getCollectedfrom().getValue());
        Assertions.assertNotNull((Object)i.getHostedby());
        Assertions.assertEquals((Object)"10|openaire____::55045bd2a65019fd8e6741a755395c8c", (Object)i.getHostedby().getKey());
        Assertions.assertEquals((Object)"Unknown Repository", (Object)i.getHostedby().getValue());
        Assertions.assertNotNull((Object)i.getInstancetype());
        Assertions.assertEquals((Object)"0001", (Object)i.getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Article", (Object)i.getInstancetype().getClassname());
        Assertions.assertEquals((Object)"dnet:publication_resource", (Object)i.getInstancetype().getSchemeid());
        Assertions.assertEquals((Object)"dnet:publication_resource", (Object)i.getInstancetype().getSchemename());
        Assertions.assertNull((Object)i.getLicense());
        Assertions.assertNotNull((Object)i.getDateofacceptance());
        Assertions.assertEquals((Object)"2020-06-04", (Object)i.getDateofacceptance().getValue());
        Assertions.assertNull((Object)i.getProcessingchargeamount());
        Assertions.assertNull((Object)i.getProcessingchargecurrency());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertEquals((int)1, (int)i.getPid().size());
        Assertions.assertNotNull((Object)i.getAlternateIdentifier());
        Assertions.assertEquals((int)0, (int)i.getAlternateIdentifier().size());
        Assertions.assertNotNull((Object)i.getUrl());
        Assertions.assertEquals((int)1, (int)i.getUrl().size());
        Assertions.assertTrue((boolean)i.getUrl().contains("http://dx.doi.org/10.1080/23744235.2020.1774644"));
        Assertions.assertEquals((Object)"", (Object)((Instance)p.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"", (Object)((Instance)p.getInstance().get(0)).getRefereed().getClassname());
        Publication p_cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p, (VocabularyGroup)this.vocs);
        Assertions.assertEquals((Object)"0001", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"peerReviewed", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassname());
        Assertions.assertNull((Object)p_cleaned.getMetaResourceType());
        Assertions.assertNotNull((Object)((Instance)p_cleaned.getInstance().get(0)).getInstanceTypeMapping());
        Assertions.assertEquals((int)1, (int)((Instance)p_cleaned.getInstance().get(0)).getInstanceTypeMapping().size());
        Assertions.assertTrue((boolean)((Instance)p_cleaned.getInstance().get(0)).getInstanceTypeMapping().stream().anyMatch(t -> "journal-article".equals(t.getOriginalType()) && "openaire::coar_resource_types_3_1".equals(t.getVocabularyName()) && Objects.isNull(t.getTypeCode()) && Objects.isNull(t.getTypeLabel())));
        Assertions.assertTrue((boolean)((Instance)p_cleaned.getInstance().get(0)).getInstanceTypeMapping().stream().noneMatch(t -> "openaire::user_resource_types".equals(t.getVocabularyName())));
    }

    @Test
    void testSoftware() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_software.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Software));
        Assertions.assertTrue((boolean)(list.get(1) instanceof Relation));
        Assertions.assertTrue((boolean)(list.get(2) instanceof Relation));
        Software s = (Software)list.get(0);
        this.assertValidId(s.getId());
        this.assertValidId(((KeyValue)s.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)s.getTitle().get(0)).getValue()));
        Assertions.assertFalse((boolean)s.getAuthor().isEmpty());
        Assertions.assertFalse((boolean)s.getSubject().isEmpty());
        Assertions.assertFalse((boolean)s.getInstance().isEmpty());
        Relation r1 = (Relation)list.get(1);
        Relation r2 = (Relation)list.get(2);
        Assertions.assertEquals((Object)s.getId(), (Object)r1.getTarget());
        Assertions.assertEquals((Object)"50|doi_________::b453e7b4b2130ace57ff0c3db470a982", (Object)r1.getSource());
        Assertions.assertEquals((Object)"resultResult", (Object)r1.getRelType());
        Assertions.assertEquals((Object)"relationship", (Object)r1.getSubRelType());
        Assertions.assertEquals((Object)"References", (Object)r1.getRelClass());
        Assertions.assertEquals((Object)s.getId(), (Object)r2.getSource());
        Assertions.assertEquals((Object)"50|doi_________::b453e7b4b2130ace57ff0c3db470a982", (Object)r2.getTarget());
        Assertions.assertEquals((Object)"resultResult", (Object)r2.getRelType());
        Assertions.assertEquals((Object)"relationship", (Object)r2.getSubRelType());
        Assertions.assertEquals((Object)"IsReferencedBy", (Object)r2.getRelClass());
    }

    @Test
    void testClaimDedup() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_claim_dedup.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertNotNull((Object)list);
        Assertions.assertFalse((boolean)list.isEmpty());
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
    }

    @Test
    void testNakala() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_nakala.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Dataset));
        Dataset d = (Dataset)list.get(0);
        this.assertValidId(d.getId());
        this.assertValidId(((KeyValue)d.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)d.getTitle().get(0)).getValue()));
        Assertions.assertEquals((int)1, (int)d.getAuthor().size());
        Assertions.assertEquals((int)1, (int)d.getSubject().size());
        Assertions.assertEquals((int)1, (int)d.getInstance().size());
        Assertions.assertNotNull((Object)d.getPid());
        Assertions.assertEquals((int)1, (int)d.getPid().size());
        Assertions.assertTrue((boolean)PidType.isValid((String)((StructuredProperty)d.getPid().get(0)).getQualifier().getClassid()));
        Assertions.assertEquals((Object)PidType.handle, (Object)PidType.valueOf((String)((StructuredProperty)d.getPid().get(0)).getQualifier().getClassid()));
        Assertions.assertNotNull((Object)((Instance)d.getInstance().get(0)).getUrl());
    }

    @Test
    void testEnermaps() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("enermaps.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Dataset));
        Dataset d = (Dataset)list.get(0);
        this.assertValidId(d.getId());
        this.assertValidId(((KeyValue)d.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)d.getTitle().get(0)).getValue()));
        Assertions.assertEquals((int)1, (int)d.getAuthor().size());
        Assertions.assertEquals((int)1, (int)d.getInstance().size());
        Assertions.assertNotNull((Object)((Instance)d.getInstance().get(0)).getUrl());
        Assertions.assertNotNull((Object)d.getContext());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((Context)d.getContext().get(0)).getId()));
        Assertions.assertEquals((Object)"enermaps::selection::tgs00004", (Object)((Context)d.getContext().get(0)).getId());
    }

    @Test
    void testClaimFromCrossref() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_claim_crossref.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        System.out.println(((StructuredProperty)p.getTitle().get(0)).getValue());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
    }

    @Test
    void testODFRecord() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_record.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Dataset p = (Dataset)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        System.out.println(((StructuredProperty)p.getTitle().get(0)).getValue());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertEquals((int)3, (int)p.getCountry().size());
        Assertions.assertEquals((Object)"IT", (Object)((Country)p.getCountry().get(0)).getClassid());
        Assertions.assertEquals((Object)"FR", (Object)((Country)p.getCountry().get(1)).getClassid());
        Assertions.assertEquals((Object)"DE", (Object)((Country)p.getCountry().get(2)).getClassid());
        Assertions.assertNotNull((Object)p.getDescription());
        Assertions.assertEquals((int)1, (int)p.getDescription().size());
        Assertions.assertNotNull(p.getDescription().get(0));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)p.getDescription().get(0)).getValue())));
    }

    @Test
    void testODFRecord_guidelines4() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_guidelines4.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertNotNull((Object)p.getDescription());
        Assertions.assertEquals((int)2, (int)p.getDescription().size());
        Assertions.assertNotNull(p.getDescription().get(0));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)p.getDescription().get(0)).getValue())));
        Assertions.assertNotNull(p.getDescription().get(1));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)p.getDescription().get(1)).getValue())));
    }

    @Test
    void testTextGrid() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("textgrid.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Dataset p = (Dataset)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertEquals((int)1, (int)p.getAuthor().size());
        Assertions.assertEquals((Object)"OPEN", (Object)p.getBestaccessright().getClassid());
        Assertions.assertEquals((int)1, (int)p.getPid().size());
        Assertions.assertTrue((boolean)PidType.isValid((String)((StructuredProperty)p.getPid().get(0)).getQualifier().getClassid()));
        Assertions.assertEquals((Object)PidType.handle, (Object)PidType.valueOf((String)((StructuredProperty)p.getPid().get(0)).getQualifier().getClassid()));
        Assertions.assertEquals((Object)"hdl:11858/00-1734-0000-0003-EE73-2", (Object)((StructuredProperty)p.getPid().get(0)).getValue());
        Assertions.assertEquals((Object)"dataset", (Object)p.getResulttype().getClassname());
        Assertions.assertEquals((int)1, (int)p.getInstance().size());
        Assertions.assertEquals((Object)"OPEN", (Object)((Instance)p.getInstance().get(0)).getAccessright().getClassid());
        this.assertValidId(((Instance)p.getInstance().get(0)).getCollectedfrom().getKey());
        this.assertValidId(((Instance)p.getInstance().get(0)).getHostedby().getKey());
        Assertions.assertEquals((Object)"http://creativecommons.org/licenses/by/3.0/de/legalcode", (Object)((Instance)p.getInstance().get(0)).getLicense().getValue());
        Assertions.assertEquals((int)1, (int)p.getInstance().size());
        Assertions.assertNotNull((Object)((Instance)p.getInstance().get(0)).getAlternateIdentifier());
        Assertions.assertEquals((int)0, (int)((Instance)p.getInstance().get(0)).getAlternateIdentifier().size());
        Assertions.assertEquals((int)1, (int)((Instance)p.getInstance().get(0)).getUrl().size());
    }

    @Test
    void testBologna() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf-bologna.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        System.out.println(((StructuredProperty)p.getTitle().get(0)).getValue());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        System.out.println(((StructuredProperty)p.getTitle().get(0)).getValue());
    }

    @Test
    void testJairo() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_jairo.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertNotNull((Object)p.getTitle());
        Assertions.assertFalse((boolean)p.getTitle().isEmpty());
        Assertions.assertEquals((int)1, (int)p.getTitle().size());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Publication p_cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)((Publication)GraphCleaningFunctions.fixVocabularyNames((Oaf)p)), (VocabularyGroup)this.vocs);
        Assertions.assertNotNull((Object)p_cleaned.getTitle());
        Assertions.assertFalse((boolean)p_cleaned.getTitle().isEmpty());
    }

    @Test
    void test_instance_url_validation() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("idus_sevilla.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Publication p = (Publication)list.get(0);
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        Assertions.assertNotNull((Object)((Instance)p.getInstance().get(0)).getUrl());
        Assertions.assertFalse((boolean)((Instance)p.getInstance().get(0)).getUrl().isEmpty());
        Assertions.assertEquals((Object)"https://idus.us.es/handle//11441/118940", ((Instance)p.getInstance().get(0)).getUrl().get(0));
    }

    @Test
    void testZenodo() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_zenodo.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertNotNull((Object)p.getTitle());
        Assertions.assertFalse((boolean)p.getTitle().isEmpty());
        Assertions.assertEquals((int)1, (int)p.getTitle().size());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertNotNull((Object)p.getAuthor());
        Assertions.assertEquals((int)2, (int)p.getAuthor().size());
        Author author = p.getAuthor().stream().filter(a -> a.getPid().stream().anyMatch(pi -> pi.getValue().equals("0000-0003-3272-8007"))).findFirst().get();
        Assertions.assertNotNull((Object)author);
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)author.getSurname()));
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)author.getName()));
        Assertions.assertEquals((Object)"Anne van Weerden", (Object)author.getFullname());
        author = p.getAuthor().stream().filter(a -> a.getPid().stream().anyMatch(pi -> pi.getValue().equals("0000-0003-3272-8008"))).findFirst().get();
        Assertions.assertNotNull((Object)author);
        Assertions.assertFalse((boolean)StringUtils.isBlank((CharSequence)author.getSurname()));
        Assertions.assertFalse((boolean)StringUtils.isBlank((CharSequence)author.getName()));
        Assertions.assertFalse((boolean)StringUtils.isBlank((CharSequence)author.getFullname()));
        List instances = p.getInstance();
        Assertions.assertNotNull((Object)instances);
        Assertions.assertFalse((boolean)instances.isEmpty());
        Instance i = (Instance)instances.get(0);
        Assertions.assertNotNull((Object)i);
        List urls = i.getUrl();
        Assertions.assertNotNull((Object)urls);
        Assertions.assertFalse((boolean)urls.isEmpty());
        Assertions.assertTrue((boolean)urls.stream().anyMatch("http://dx.doi.org/10.5281/zenodo.3406824"::equals));
        Assertions.assertTrue((boolean)urls.stream().anyMatch("https://zenodo.org/records/274730"::equals));
    }

    @Test
    void testOdfFromHdfs() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_from_hdfs.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)1, (int)list.size());
        System.out.println(((Oaf)list.get(0)).getClass());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Dataset));
        Dataset p = (Dataset)list.get(0);
        this.assertValidId(p.getId());
        Assertions.assertEquals((int)2, (int)p.getOriginalId().size());
        Assertions.assertTrue((boolean)p.getOriginalId().stream().anyMatch(oid -> oid.equals("df76e73f-0483-49a4-a9bb-63f2f985574a")));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertFalse((boolean)p.getAuthor().isEmpty());
        Optional author = p.getAuthor().stream().findFirst();
        Assertions.assertTrue((boolean)author.isPresent());
        Assertions.assertEquals((Object)"Museum S\u00f8nderjylland", (Object)((Author)author.get()).getFullname());
        Assertions.assertFalse((boolean)p.getSubject().isEmpty());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        Assertions.assertNotNull((Object)p.getTitle());
        Assertions.assertFalse((boolean)p.getTitle().isEmpty());
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        p.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getAccessright());
            Assertions.assertEquals((Object)"UNKNOWN", (Object)i.getAccessright().getClassid());
        });
        Dataset p_cleaned = (Dataset)GraphCleaningFunctions.cleanup((Oaf)p, (VocabularyGroup)this.vocs);
        Assertions.assertEquals((Object)"0002", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassid());
        Assertions.assertEquals((Object)"nonPeerReviewed", (Object)((Instance)p_cleaned.getInstance().get(0)).getRefereed().getClassname());
    }

    @Test
    void testXMLEncodedURL() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("encoded-url.xml")));
        List list = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        Assertions.assertTrue((p.getInstance().size() > 0 ? 1 : 0) != 0);
        String decoded = "https://www.ec.europa.eu/research/participants/documents/downloadPublic?documentIds=080166e5af388993&appId=PPGMS";
        Assertions.assertEquals((Object)decoded, ((Instance)p.getInstance().get(0)).getUrl().get(0));
    }

    @Test
    void testXMLEncodedURL_ODF() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("encoded-url_odf.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Dataset p = (Dataset)list.get(0);
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        for (String url : ((Instance)p.getInstance().get(0)).getUrl()) {
            System.out.println(url);
            Assertions.assertFalse((boolean)url.contains("&amp;"));
        }
    }

    @Test
    void testOpenAPC() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_openapc.xml")));
        List list = new OafToOafMapper(this.vocs, true, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Optional<Oaf> o = list.stream().filter(r -> r instanceof Publication).findFirst();
        Assertions.assertTrue((boolean)o.isPresent());
        Publication p = (Publication)o.get();
        Assertions.assertFalse((boolean)p.getInstance().isEmpty());
        Assertions.assertEquals((Object)"https://doi.org/10.1155/2015/439379", ((Instance)p.getInstance().get(0)).getUrl().get(0));
        Assertions.assertNotNull((Object)p.getProcessingchargeamount());
        Assertions.assertNotNull((Object)p.getProcessingchargecurrency());
        Assertions.assertEquals((Object)"1721.47", (Object)p.getProcessingchargeamount().getValue());
        Assertions.assertEquals((Object)"EUR", (Object)p.getProcessingchargecurrency().getValue());
        List affiliations = list.stream().filter(r -> r instanceof Relation).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)affiliations.size());
        for (Oaf aff : affiliations) {
            Relation r2 = (Relation)aff;
            Assertions.assertEquals((Object)"affiliation", (Object)r2.getSubRelType());
            Assertions.assertEquals((Object)"resultOrganization", (Object)r2.getRelType());
            String source = r2.getSource();
            if (StringUtils.startsWith((CharSequence)source, (CharSequence)"50")) {
                Assertions.assertEquals((Object)"hasAuthorInstitution", (Object)r2.getRelClass());
            } else if (StringUtils.startsWith((CharSequence)source, (CharSequence)"20")) {
                Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)source, (CharSequence)"::"));
                Assertions.assertEquals((Object)"20|ror_________", (Object)StringUtils.substringBefore((String)source, (String)"::"));
                Assertions.assertEquals((Object)"isAuthorInstitutionOf", (Object)r2.getRelClass());
            } else {
                throw new IllegalArgumentException("invalid source / target prefixes for affiliation relations");
            }
            List apcInfo = r2.getProperties();
            Assertions.assertEquals((Object)"EUR", (Object)apcInfo.stream().filter(kv -> "apc_currency".equals(kv.getKey())).map(KeyValue::getValue).findFirst().orElse(""));
            Assertions.assertEquals((Object)"1721.47", (Object)apcInfo.stream().filter(kv -> "apc_amount".equals(kv.getKey())).map(KeyValue::getValue).findFirst().orElse(""));
        }
    }

    @Test
    void testROHub() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("rohub.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Assertions.assertEquals((int)5, (int)list.size());
        OtherResearchProduct p = (OtherResearchProduct)list.get(0);
        this.assertValidId(p.getId());
        Assertions.assertTrue((boolean)p.getId().startsWith("50|w3id"));
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertEquals((int)1, (int)p.getInstance().size());
        Assertions.assertEquals((Object)"https://w3id.org/ro-id/0ab171a7-45c5-4194-82d4-850955504bca", (Object)((StructuredProperty)p.getPid().get(0)).getValue());
        Instance inst = (Instance)p.getInstance().get(0);
        Assertions.assertEquals((Object)"https://w3id.org/ro-id/0ab171a7-45c5-4194-82d4-850955504bca", (Object)((StructuredProperty)inst.getPid().get(0)).getValue());
        Assertions.assertEquals((Object)"https://w3id.org/ro-id/0ab171a7-45c5-4194-82d4-850955504bca", inst.getUrl().get(0));
        Assertions.assertEquals((int)1, (int)p.getEoscifguidelines().size());
        Assertions.assertEquals((Object)"EOSC::RO-crate", (Object)((EoscIfGuidelines)p.getEoscifguidelines().get(0)).getCode());
        Assertions.assertEquals((Object)"EOSC::RO-crate", (Object)((EoscIfGuidelines)p.getEoscifguidelines().get(0)).getLabel());
        Assertions.assertEquals((Object)"", (Object)((EoscIfGuidelines)p.getEoscifguidelines().get(0)).getUrl());
        Assertions.assertEquals((Object)"compliesWith", (Object)((EoscIfGuidelines)p.getEoscifguidelines().get(0)).getSemanticRelation());
    }

    @Test
    void test_Zenodo2() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("odf_zenodo2.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertEquals((int)3, (int)list.size());
        Publication p = (Publication)GraphCleaningFunctions.cleanup((Oaf)((Publication)list.get(0)), (VocabularyGroup)this.vocs);
        Assertions.assertNotNull((Object)p.getInstance());
        Assertions.assertEquals((int)1, (int)p.getInstance().size());
        Instance instance = (Instance)p.getInstance().get(0);
        Assertions.assertNotNull((Object)instance.getInstanceTypeMapping());
        Assertions.assertEquals((int)1, (int)instance.getInstanceTypeMapping().size());
        Optional<InstanceTypeMapping> coarType = instance.getInstanceTypeMapping().stream().filter(itm -> "openaire::coar_resource_types_3_1".equals(itm.getVocabularyName())).findFirst();
        Assertions.assertTrue((boolean)coarType.isPresent());
        Assertions.assertNotNull((Object)coarType.get().getOriginalType());
        Assertions.assertNull((Object)coarType.get().getTypeCode());
        Assertions.assertNull((Object)coarType.get().getTypeLabel());
    }

    @Test
    void testROHub2() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("rohub-modified.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Assertions.assertEquals((int)7, (int)list.size());
        OtherResearchProduct p = (OtherResearchProduct)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertEquals((Object)"50|w3id________::afc7592914ae190a50570db90f55f9c2", (Object)p.getId());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((StructuredProperty)p.getTitle().get(0)).getValue()));
        Assertions.assertEquals((Object)"w3id", (Object)((StructuredProperty)p.getPid().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"https://w3id.org/ro-id/0ab171a7-45c5-4194-82d4-850955504bca", (Object)((StructuredProperty)p.getPid().get(0)).getValue());
        Assertions.assertEquals((long)1L, (long)list.stream().filter(o -> o instanceof OtherResearchProduct).count());
        Assertions.assertEquals((long)6L, (long)list.stream().filter(o -> o instanceof Relation).count());
        for (Oaf oaf : list) {
            if (!(oaf instanceof Relation)) continue;
            String source = ((Relation)oaf).getSource();
            String target = ((Relation)oaf).getTarget();
            Assertions.assertNotEquals((Object)source, (Object)target);
            Assertions.assertTrue((source.equals(p.getId()) || target.equals(p.getId()) ? 1 : 0) != 0);
            Assertions.assertNotNull((Object)((Relation)oaf).getSubRelType());
            Assertions.assertNotNull((Object)((Relation)oaf).getRelClass());
            Assertions.assertNotNull((Object)((Relation)oaf).getRelType());
        }
    }

    @Test
    void testRiunet() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("riunet.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        Assertions.assertNotNull(((Instance)p.getInstance().get(0)).getUrl().get(0));
    }

    @Test
    void testEOSCFuture_ROHub() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("photic-zone-transformed.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        OtherResearchProduct rocrate = (OtherResearchProduct)list.get(0);
        Assertions.assertNotNull((Object)rocrate.getEoscifguidelines());
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)rocrate));
        System.out.println("***************");
    }

    @Test
    void testD4ScienceTraining() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("d4science-1-training.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        OtherResearchProduct trainingMaterial = (OtherResearchProduct)list.get(0);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)trainingMaterial));
        System.out.println("***************");
    }

    @Test
    void testD4ScienceDataset() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("d4science-2-dataset.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Dataset trainingMaterial = (Dataset)list.get(0);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)trainingMaterial));
        System.out.println("***************");
    }

    @Test
    void testIRISPub() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("iris-odf.xml")));
        List list = new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml);
        System.out.println("***************");
        System.out.println(new ObjectMapper().writeValueAsString((Object)list));
        System.out.println("***************");
        Publication p = (Publication)list.get(0);
        Assertions.assertNotNull(((Instance)p.getInstance().get(0)).getUrl().get(0));
        this.assertValidId(p.getId());
        System.out.println(((Instance)p.getInstance().get(0)).getUrl());
        p.getPid().forEach(x -> System.out.println(x.getValue()));
        ((Instance)p.getInstance().get(0)).getAlternateIdentifier().forEach(x -> System.out.println(x.getValue()));
    }

    @Test
    void testNotWellFormed() throws IOException {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("oaf_notwellformed.xml")));
        List actual = new OafToOafMapper(this.vocs, false, true).processMdRecord(xml);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    private void assertValidId(String id) {
        Assertions.assertEquals((int)49, (int)id.length());
        Assertions.assertEquals((Object)"|", (Object)id.substring(2, 3));
        Assertions.assertEquals((Object)"::", (Object)id.substring(15, 17));
    }

    private List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(MappersTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/terms.txt")));
    }

    private List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(MappersTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/synonyms.txt")));
    }
}

