/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.OdfToOafMapper;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class GenerateEntitiesApplicationTest {
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private VocabularyGroup vocs;

    GenerateEntitiesApplicationTest() {
    }

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(this.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(this.synonyms());
        this.vocs = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
    }

    @Test
    void testMergeResult() throws IOException {
        Result publication = this.getResult("oaf_record.xml", Publication.class);
        Result dataset = this.getResult("odf_dataset.xml", Dataset.class);
        Result software = this.getResult("odf_software.xml", Software.class);
        Result orp = this.getResult("oaf_orp.xml", OtherResearchProduct.class);
        this.verifyMerge(publication, dataset, Publication.class, "publication");
        this.verifyMerge(dataset, publication, Publication.class, "publication");
        this.verifyMerge(publication, software, Publication.class, "publication");
        this.verifyMerge(software, publication, Publication.class, "publication");
        this.verifyMerge(publication, orp, Publication.class, "publication");
        this.verifyMerge(orp, publication, Publication.class, "publication");
        this.verifyMerge(dataset, software, Dataset.class, "dataset");
        this.verifyMerge(software, dataset, Dataset.class, "dataset");
        this.verifyMerge(dataset, orp, Dataset.class, "dataset");
        this.verifyMerge(orp, dataset, Dataset.class, "dataset");
        this.verifyMerge(software, orp, Software.class, "software");
        this.verifyMerge(orp, software, Software.class, "software");
    }

    protected <T extends Result> void verifyMerge(Result r1, Result r2, Class<T> clazz, String resultType) {
        Result merge = (Result)MergeUtils.mergeGroup(Lists.newArrayList((Object[])new Result[]{r1, r2}).iterator());
        Assertions.assertEquals((Object)resultType, (Object)merge.getResulttype().getClassid());
        Assertions.assertTrue((boolean)clazz.isAssignableFrom(merge.getClass()));
    }

    protected <T extends Result> Result getResult(String xmlFileName, Class<T> clazz) throws IOException {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(xmlFileName));
        return new OdfToOafMapper(this.vocs, false, true).processMdRecord(xml).stream().filter(s -> clazz.isAssignableFrom(s.getClass())).map(s -> (Result)s).findFirst().get();
    }

    private List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)GenerateEntitiesApplicationTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/terms.txt"));
    }

    private List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)GenerateEntitiesApplicationTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/synonyms.txt"));
    }
}

