/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.sx.graph.SparkCreateScholix$;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils$;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class SparkCreateScholix$ {
    public static final SparkCreateScholix$ MODULE$ = new SparkCreateScholix$();

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/create_scholix_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String relationPath = parser.get("relationPath");
        log.info("relationPath  -> " + relationPath);
        String summaryPath = parser.get("summaryPath");
        log.info("summaryPath  -> " + summaryPath);
        String targetPath = parser.get("targetPath");
        log.info("targetPath  -> " + targetPath);
        boolean dumpCitations = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(parser.get("dumpCitations")))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        log.info("dumpCitations  -> " + dumpCitations);
        Encoder relEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Relation.class));
        Encoder summaryEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(ScholixSummary.class));
        Encoder scholixEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
        Dataset relationDS = spark.read().load(relationPath).as(relEncoder).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkCreateScholix$.$anonfun$main$3(r))).map((Function1 & Serializable)r -> new Tuple2((Object)r.getSource(), r), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), relEncoder));
        Dataset summaryDS = spark.read().load(summaryPath).as(summaryEncoder).map((Function1 & Serializable)r -> new Tuple2((Object)r.getId(), r), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), summaryEncoder));
        relationDS.joinWith(summaryDS, relationDS.apply("_1").equalTo((Object)summaryDS.apply("_1")), "left").map((Function1 & Serializable)input -> {
            if (input._1() != null && input._2() != null) {
                Relation rel = (Relation)((Tuple2)input._1())._2();
                ScholixSummary source = (ScholixSummary)((Tuple2)input._2())._2();
                return new Tuple2((Object)rel.getTarget(), (Object)ScholixUtils$.MODULE$.scholixFromSource(rel, source));
            }
            return null;
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder)).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkCreateScholix$.$anonfun$main$7(r))).write().mode(SaveMode.Overwrite).save(targetPath + "/scholix_from_source");
        Dataset scholixSource = spark.read().load(targetPath + "/scholix_from_source").as(Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder));
        scholixSource.joinWith(summaryDS, scholixSource.apply("_1").equalTo((Object)summaryDS.apply("_1")), "left").map((Function1 & Serializable)input -> {
            if (input._2() == null) {
                return null;
            }
            Scholix s = (Scholix)((Tuple2)input._1())._2();
            ScholixSummary target = (ScholixSummary)((Tuple2)input._2())._2();
            return ScholixUtils$.MODULE$.generateCompleteScholix(s, target);
        }, scholixEncoder).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkCreateScholix$.$anonfun$main$9(s))).write().mode(SaveMode.Overwrite).save(targetPath + "/scholix_one_verse");
        Dataset scholix_o_v = spark.read().load(targetPath + "/scholix_one_verse").as(scholixEncoder);
        scholix_o_v.flatMap((Function1 & Serializable)s -> new .colon.colon(s, (List)new .colon.colon((Object)ScholixUtils$.MODULE$.createInverseScholixRelation(s), (List)Nil$.MODULE$)), scholixEncoder).as(scholixEncoder).map((Function1 & Serializable)s -> new Tuple2((Object)s.getIdentifier(), s), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder)).groupByKey((Function1 & Serializable)x$1 -> (String)x$1._1(), spark.implicits().newStringEncoder()).agg(ScholixUtils$.MODULE$.scholixAggregator().toColumn()).map((Function1 & Serializable)s -> (Scholix)s._2(), scholixEncoder).write().mode(SaveMode.Overwrite).save(targetPath + "/scholix");
        Dataset scholix_final = spark.read().load(targetPath + "/scholix").as(scholixEncoder);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator49$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator49$1() {
            }
        }
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator54$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator54$1() {
            }
        }
        Dataset stats = scholix_final.map((Function1 & Serializable)s -> new Tuple2((Object)s.getSource().getDnetIdentifier(), (Object)s.getTarget().getObjectType()), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator49$1()))).groupBy("_1", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_2"})).agg((Column)functions$.MODULE$.count("_1"), (Seq)Nil$.MODULE$).as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator54$1())));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator59$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator59$1() {
            }
        }
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator68$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator68$1() {
            }
        }
        stats.map((Function1 & Serializable)s -> new ScholixUtils.RelatedEntities((String)s._1(), "dataset".equalsIgnoreCase((String)s._2()) ? BoxesRunTime.unboxToLong((Object)s._3()) : 0L, "publication".equalsIgnoreCase((String)s._2()) ? BoxesRunTime.unboxToLong((Object)s._3()) : 0L), spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator59$1()))).groupByKey((Function1 & Serializable)x$2 -> x$2.id(), spark.implicits().newStringEncoder()).reduceGroups((Function2 & Serializable)(a, b) -> new ScholixUtils.RelatedEntities(a.id(), a.relatedDataset() + b.relatedDataset(), a.relatedPublication() + b.relatedPublication())).map((Function1 & Serializable)x$3 -> (ScholixUtils.RelatedEntities)x$3._2(), spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator68$1()))).write().mode(SaveMode.Overwrite).save(targetPath + "/related_entities");
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator73$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator73$1() {
            }
        }
        Dataset relatedEntitiesDS = spark.read().load(targetPath + "/related_entities").as(spark.implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator73$1()))).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkCreateScholix$.$anonfun$main$19(dumpCitations, r)));
        relatedEntitiesDS.joinWith(summaryDS, relatedEntitiesDS.apply("id").equalTo((Object)summaryDS.apply("_1")), "inner").map((Function1 & Serializable)i -> {
            ScholixUtils.RelatedEntities re = (ScholixUtils.RelatedEntities)i._1();
            ScholixSummary sum = (ScholixSummary)((Tuple2)i._2())._2();
            sum.setRelatedDatasets(re.relatedDataset());
            sum.setRelatedPublications(re.relatedPublication());
            return sum;
        }, summaryEncoder).write().mode(SaveMode.Overwrite).save(summaryPath + "_filtered");
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Relation r) {
        return (r.getDataInfo() == null || BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false))) && !r.getRelClass().toLowerCase().contains("merge");
    }

    public static final /* synthetic */ boolean $anonfun$main$7(Tuple2 r) {
        return r != null;
    }

    public static final /* synthetic */ boolean $anonfun$main$9(Scholix s) {
        return s != null;
    }

    public static final /* synthetic */ boolean $anonfun$main$19(boolean dumpCitations$1, ScholixUtils.RelatedEntities r) {
        return dumpCitations$1 || r.relatedPublication() > 0L || r.relatedDataset() > 0L;
    }

    private SparkCreateScholix$() {
    }
}

