/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.graph.hostedbymap.Aggregators$;
import eu.dnetlib.dhp.oa.graph.hostedbymap.SparkApplyHostedByMapToDatasource$;
import eu.dnetlib.dhp.oa.graph.hostedbymap.SparkApplyHostedByMapToResult$;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.EntityInfo;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Publication;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005e2A\u0001B\u0003\u0001%!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)q\u0007\u0001C\u0001M\tIA+Z:u\u0003B\u0004H.\u001f\u0006\u0003\r\u001d\t1\u0002[8ti\u0016$'-_7ba*\u0011\u0001\"C\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003\u0015-\t!a\\1\u000b\u00051i\u0011a\u00013ia*\u0011abD\u0001\bI:,G\u000f\\5c\u0015\u0005\u0001\u0012AA3v\u0007\u0001\u00192\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0003S>T\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011!B\u0001\u0012i\u0016\u001cH/\u00119qYf|eNU3tk2$H#A\u0014\u0011\u0005QA\u0013BA\u0015\u0016\u0005\u0011)f.\u001b;)\u0005\tY\u0003C\u0001\u00176\u001b\u0005i#B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0003aE\nqA[;qSR,'O\u0003\u00023g\u0005)!.\u001e8ji*\tA'A\u0002pe\u001eL!AN\u0017\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH/\u00119qYf|e\u000eR1uCN|WO]2fQ\t\u00191\u0006")
public class TestApply
implements Serializable {
    @Test
    public void testApplyOnResult() {
        SparkConf conf = new SparkConf();
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        SparkSession spark = SparkSession$.MODULE$.builder().appName(this.getClass().getSimpleName()).config(conf).getOrCreate();
        String pub = this.getClass().getResource("publication.json").getPath();
        String hbm = this.getClass().getResource("preparedInfo.json").getPath();
        ObjectMapper mapper = new ObjectMapper();
        Encoder mapEncoderDSInfo = Encoders$.MODULE$.bean(EntityInfo.class);
        Encoder mapEncoderPubInfo = Encoders$.MODULE$.bean(Publication.class);
        Dataset pub_ds = spark.read().textFile(pub).map((Function1 & Serializable)p -> (Publication)mapper.readValue(p, Publication.class), mapEncoderPubInfo);
        Dataset hbm_ds = spark.read().textFile(hbm).map((Function1 & Serializable)p -> (EntityInfo)mapper.readValue(p, EntityInfo.class), mapEncoderDSInfo);
        Assertions.assertEquals((long)13L, (long)pub_ds.count());
        Dataset ds = SparkApplyHostedByMapToResult$.MODULE$.applyHBtoPubs(hbm_ds, pub_ds);
        Assertions.assertEquals((long)13L, (long)ds.count());
        Dataset temp = pub_ds.joinWith(ds, pub_ds.col("id").equalTo((Object)ds.col("id")), "left");
        Assertions.assertEquals((long)13L, (long)temp.count());
        temp.foreach((Function1 & Serializable)t2 -> {
            TestApply.$anonfun$testApplyOnResult$3(t2);
            return BoxedUnit.UNIT;
        });
        spark.close();
    }

    @Test
    public void testApplyOnDatasource() {
        SparkConf conf = new SparkConf();
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        SparkSession spark = SparkSession$.MODULE$.builder().appName(this.getClass().getSimpleName()).config(conf).getOrCreate();
        String dats = this.getClass().getResource("datasource.json").getPath();
        String hbm = this.getClass().getResource("preparedInfo2.json").getPath();
        ObjectMapper mapper = new ObjectMapper();
        Encoder mapEncoderDSInfo = Encoders$.MODULE$.bean(EntityInfo.class);
        Encoder mapEncoderPubInfo = Encoders$.MODULE$.bean(Datasource.class);
        Dataset dats_ds = spark.read().textFile(dats).map((Function1 & Serializable)p -> (Datasource)mapper.readValue(p, Datasource.class), mapEncoderPubInfo);
        Dataset hbm_ds = Aggregators$.MODULE$.datasourceToSingleId(spark.read().textFile(hbm).map((Function1 & Serializable)p -> (EntityInfo)mapper.readValue(p, EntityInfo.class), mapEncoderDSInfo));
        Assertions.assertEquals((long)10L, (long)dats_ds.count());
        Dataset ds = SparkApplyHostedByMapToDatasource$.MODULE$.applyHBtoDats(hbm_ds, dats_ds);
        Assertions.assertEquals((long)10L, (long)ds.count());
        Dataset temp = dats_ds.joinWith(ds, dats_ds.col("id").equalTo((Object)ds.col("id")), "left");
        Assertions.assertEquals((long)10L, (long)temp.count());
        temp.foreach((Function1 & Serializable)t2 -> {
            TestApply.$anonfun$testApplyOnDatasource$3(t2);
            return BoxedUnit.UNIT;
        });
        spark.close();
    }

    public static final /* synthetic */ void $anonfun$testApplyOnResult$3(Tuple2 t2) {
        Publication pb = (Publication)t2._1();
        Publication pa = (Publication)t2._2();
        Assertions.assertEquals((int)1, (int)pa.getInstance().size());
        Assertions.assertEquals((int)1, (int)pb.getInstance().size());
        Assertions.assertTrue((boolean)((OafEntity)t2._1()).getId().equals(((OafEntity)t2._2()).getId()));
        if (pb.getId().equals("50|4dc99724cf04::ed1ba83e1add6ce292433729acd8b0d9")) {
            Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getHostedby().getKey().equals("10|issn___print::e4b6d6d978f67520f6f37679a98c5735"));
            Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getHostedby().getValue().equals("Academic Therapy"));
            Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getAccessright().getClassid().equals("OPEN"));
            Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getAccessright().getClassname().equals("Open Access"));
            Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getAccessright().getOpenAccessRoute().equals((Object)OpenAccessRoute.gold));
            Assertions.assertTrue((boolean)pa.getBestaccessright().getClassid().equals("OPEN"));
            Assertions.assertTrue((boolean)pa.getBestaccessright().getClassname().equals("Open Access"));
            Assertions.assertTrue((boolean)((Instance)pb.getInstance().get(0)).getHostedby().getKey().equals("10|openaire____::0b74b6a356bbf23c245f9ae9a748745c"));
            Assertions.assertTrue((boolean)((Instance)pb.getInstance().get(0)).getHostedby().getValue().equals("Revistas de investigaci\u00f3n Universidad Nacional Mayor de San Marcos"));
            Assertions.assertTrue((boolean)((Instance)pb.getInstance().get(0)).getAccessright().getClassname().equals("not available"));
            Assertions.assertTrue((boolean)((Instance)pb.getInstance().get(0)).getAccessright().getClassid().equals("UNKNOWN"));
            Assertions.assertTrue((((Instance)pb.getInstance().get(0)).getAccessright().getOpenAccessRoute() == null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)pb.getBestaccessright().getClassid().equals("UNKNOWN"));
            Assertions.assertTrue((boolean)pb.getBestaccessright().getClassname().equals("not available"));
            return;
        }
        Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getHostedby().getKey().equals(((Instance)pb.getInstance().get(0)).getHostedby().getKey()));
        Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getHostedby().getValue().equals(((Instance)pb.getInstance().get(0)).getHostedby().getValue()));
        Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getAccessright().getClassid().equals(((Instance)pb.getInstance().get(0)).getAccessright().getClassid()));
        Assertions.assertTrue((boolean)((Instance)pa.getInstance().get(0)).getAccessright().getClassname().equals(((Instance)pb.getInstance().get(0)).getAccessright().getClassname()));
        OpenAccessRoute openAccessRoute = ((Instance)pa.getInstance().get(0)).getAccessright().getOpenAccessRoute();
        OpenAccessRoute openAccessRoute2 = ((Instance)pb.getInstance().get(0)).getAccessright().getOpenAccessRoute();
        Assertions.assertTrue((!(openAccessRoute != null ? !openAccessRoute.equals(openAccessRoute2) : openAccessRoute2 != null) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testApplyOnDatasource$3(Tuple2 t2) {
        Datasource pb = (Datasource)t2._1();
        Datasource pa = (Datasource)t2._2();
        Assertions.assertTrue((boolean)((OafEntity)t2._1()).getId().equals(((OafEntity)t2._2()).getId()));
        if (pb.getId().equals("10|doajarticles::0ab37b7620eb9a73ac95d3ca4320c97d")) {
            Assertions.assertTrue((boolean)pa.getOpenairecompatibility().getClassid().equals("hostedBy"));
            Assertions.assertTrue((boolean)pa.getOpenairecompatibility().getClassname().equals("collected from a compatible aggregator"));
            Assertions.assertTrue((boolean)pb.getOpenairecompatibility().getClassid().equals("UNKNOWN"));
            return;
        }
        Assertions.assertTrue((boolean)pa.getOpenairecompatibility().getClassid().equals(pb.getOpenairecompatibility().getClassid()));
        Assertions.assertTrue((boolean)pa.getOpenairecompatibility().getClassname().equals(pb.getOpenairecompatibility().getClassname()));
    }
}

