/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class AbstractMigrationApplication
implements Closeable {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Text key = new Text();
    private final Text value = new Text();
    private final SequenceFile.Writer writer;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Log log = LogFactory.getLog(AbstractMigrationApplication.class);

    protected AbstractMigrationApplication() {
        this.writer = null;
    }

    public AbstractMigrationApplication(Path hdfsPath) throws IOException {
        log.info((Object)String.format("Creating SequenceFile Writer, hdfsPath=%s", hdfsPath.toString()));
        this.writer = SequenceFile.createWriter((Configuration)AbstractMigrationApplication.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)hdfsPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
    }

    protected static Set<String> mdstorePaths(String mdstoreManagerUrl, String format, String layout, String interpretation) throws IOException {
        return DHPUtils.mdstorePaths((String)mdstoreManagerUrl, (String)format, (String)layout, (String)interpretation, (boolean)false);
    }

    protected static Configuration getConf() {
        Configuration hadoopConf = new Configuration();
        Properties systemProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!key.startsWith("spark.hadoop.")) continue;
            String hadoopKey = key.substring("spark.hadoop.".length());
            hadoopConf.set(hadoopKey, value);
        }
        return hadoopConf;
    }

    protected void emit(String s, String type) {
        try {
            this.key.set(this.counter.getAndIncrement() + ":" + type);
            this.value.set(s);
            this.writer.append((Writable)this.key, (Writable)this.value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void emitOaf(Oaf oaf) {
        try {
            this.emit(this.objectMapper.writeValueAsString((Object)oaf), oaf.getClass().getSimpleName().toLowerCase());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static List<String> listEntityPaths(SparkSession spark, String paths) {
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        return Arrays.stream(paths.split(",")).filter(StringUtils::isNotBlank).filter(p -> HdfsSupport.exists((String)p, (Configuration)sc.hadoopConfiguration())).collect(Collectors.toList());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() throws IOException {
        this.writer.hflush();
        this.writer.close();
    }
}

