/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

public class RelationComparator
implements Comparator<Relation> {
    private static final Map<String, Integer> weights = Maps.newHashMap();

    private Integer getWeight(Relation o) {
        return Optional.ofNullable(weights.get(o.getSubRelType())).orElse(Integer.MAX_VALUE);
    }

    @Override
    public int compare(Relation o1, Relation o2) {
        return ComparisonChain.start().compare((Comparable)this.getWeight(o1), (Comparable)this.getWeight(o2)).result();
    }

    static {
        weights.put("outcome", 0);
        weights.put("supplement", 1);
        weights.put("review", 2);
        weights.put("citation", 3);
        weights.put("affiliation", 4);
        weights.put("relationship", 5);
        weights.put("publicationDataset", 6);
        weights.put("similarity", 7);
        weights.put("provision", 8);
        weights.put("participation", 9);
        weights.put("dedup", 10);
    }
}

