/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.oa.provision.CreateRelatedEntitiesJob_phase1;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJob;
import eu.dnetlib.dhp.oa.provision.XmlRecordFactoryTest;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.oa.provision.utils.StreamingInputDocumentFactory;
import eu.dnetlib.dhp.oa.provision.utils.XmlRecordFactory;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.saxon.SaxonTransformerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IndexRecordTransformerTest {
    private ContextMapper contextMapper;

    @BeforeEach
    public void setUp() {
        this.contextMapper = new ContextMapper();
    }

    @Test
    public void testPreBuiltRecordTransformation() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testPublicationRecordTransformation() throws IOException, TransformerException, DocumentException {
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(this.contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = this.load("publication.json", Publication.class);
        Project pj = this.load("project.json", Project.class);
        Relation rel = this.load("relToValidatedProject.json", Relation.class);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        je.setLinks((List)Lists.newArrayList((Object[])new RelatedEntityWrapper[]{new RelatedEntityWrapper(rel, CreateRelatedEntitiesJob_phase1.asRelatedEntity((OafEntity)pj, Project.class))}));
        String xmlRecord = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)xmlRecord);
        Document doc = new SAXReader().read((Reader)new StringReader(xmlRecord));
        Assertions.assertEquals((Object)"Article", (Object)doc.valueOf("//children/instance/instancetype/@classname"));
        this.testRecordTransformation(xmlRecord);
    }

    @Test
    void testPeerReviewed() throws IOException, TransformerException {
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(this.contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = this.load("publication.json", Publication.class);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        String record = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)record);
        SolrInputDocument solrDoc = this.testRecordTransformation(record);
        Assertions.assertEquals((Object)"true", (Object)solrDoc.get((Object)"peerreviewed").getValue());
    }

    @Test
    public void testRiunet() throws IOException, TransformerException {
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(this.contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = this.load("riunet.json", Publication.class);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        String record = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)record);
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureDataTransferPilot() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/data-transfer-pilot.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureTraining() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/training-notebooks-seadatanet.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureAirQualityCopernicus() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/air-quality-copernicus.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureB2SharePlotSw() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/b2share-plot-sw.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureB2SharePlotRelatedORP() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/b2share-plot-related-orp.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureSoftwareNotebook() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/software-justthink.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureSoftwareNotebookClaim() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/software-justthink-claim.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureZenodo7353841() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/zenodo7353841.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureZenodo7351393() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/zenodo7351393.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    public void testForEOSCFutureZenodo7351221() throws IOException, TransformerException {
        String record = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("eosc-future/zenodo7351221.xml"));
        this.testRecordTransformation(record);
    }

    @Test
    void testDoiUrlNormalization() throws MalformedURLException {
        List<String> urls = Arrays.asList("https://dx.doi.org/10.1016/j.jas.2019.105013", "http://dx.doi.org/10.13140/rg.2.2.26964.65927", "https://dx.doi.org/10.13140/rg.2.2.26964.65927", "http://dx.doi.org/10.1016/j.jas.2019.105013", "http://hdl.handle.net/2072/369223", "https://doi.org/10.1016/j.jas.2019.105013");
        for (String url : urls) {
            URL u = new URL(XmlRecordFactory.normalizeDoiUrl((String)url));
            if (url.contains("doi.org")) {
                Assertions.assertEquals((Object)"https", (Object)u.getProtocol());
                Assertions.assertEquals((Object)"doi.org", (Object)u.getAuthority());
                continue;
            }
            Assertions.assertEquals((Object)url, (Object)u.toString());
        }
    }

    private SolrInputDocument testRecordTransformation(String record) throws IOException, TransformerException {
        String fields = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml"));
        String xslt = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl"));
        String transformer = XmlIndexingJob.getLayoutTransformer((String)"DMF", (String)fields, (String)xslt);
        Transformer tr = SaxonTransformerFactory.newInstance((String)transformer);
        String indexRecordXML = XmlIndexingJob.toIndexRecord((Transformer)tr, (String)record);
        SolrInputDocument solrDoc = new StreamingInputDocumentFactory().parseDocument(indexRecordXML);
        String xmlDoc = ClientUtils.toXML((SolrInputDocument)solrDoc);
        Assertions.assertNotNull((Object)xmlDoc);
        System.out.println(xmlDoc);
        return solrDoc;
    }

    private <T> T load(String fileName, Class<T> clazz) throws IOException {
        return (T)XmlRecordFactoryTest.OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream(fileName)), clazz);
    }
}

