/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrRecordDumpJob;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.model.TupleWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrInputField;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
class SolrRecordDumpJobTest {
    protected static final Logger log = LoggerFactory.getLogger(SolrRecordDumpJobTest.class);
    protected static SparkSession spark;
    protected static final String FORMAT = "test";
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private ISLookupClient isLookupClient;
    @TempDir
    public static Path workingDir;

    SolrRecordDumpJobTest() {
    }

    @BeforeAll
    public static void before() {
        SparkConf conf = new SparkConf();
        conf.setAppName(SolrRecordDumpJobTest.class.getSimpleName());
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        conf.setMaster("local[1]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.resolve("spark").toString());
        spark = SparkSession.builder().appName(SolrRecordDumpJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void shutDown() throws Exception {
        spark.stop();
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @BeforeEach
    public void prepareMocks() throws ISLookUpException, IOException {
        this.isLookupClient.setIsLookup(this.isLookUpService);
        Mockito.when((Object)this.isLookupClient.getLayoutSource(Mockito.anyString())).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml")));
        Mockito.when((Object)this.isLookupClient.getLayoutTransformer()).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl")));
    }

    @Test
    void testXmlIndexingJob_saveOnHDFS() throws Exception {
        String ID_XPATH = "//*[local-name()='header']/*[local-name()='objIdentifier']";
        String inputPath = "src/test/resources/eu/dnetlib/dhp/oa/provision/xml";
        Dataset records = spark.read().schema(Encoders.bean(TupleWrapper.class).schema()).json(inputPath).as(Encoders.bean(TupleWrapper.class));
        records.printSchema();
        long nRecord = records.count();
        log.info("found {} records", (Object)nRecord);
        Dataset ids = records.map(TupleWrapper::getXml, Encoders.STRING()).map((MapFunction & Serializable)s -> new SAXReader().read((Reader)new StringReader((String)s)).valueOf("//*[local-name()='header']/*[local-name()='objIdentifier']"), Encoders.STRING());
        log.info("found {} ids", (Object)ids.count());
        long xmlIdUnique = ids.distinct().count();
        log.info("found {} unique ids", (Object)xmlIdUnique);
        Assertions.assertEquals((long)nRecord, (long)xmlIdUnique, (String)"IDs should be unique among input records");
        String outputPath = workingDir.resolve("outputPath").toAbsolutePath().toString();
        new SolrRecordDumpJob(spark, inputPath, FORMAT, outputPath).run(this.isLookupClient);
        Dataset solrDocs = spark.read().load(outputPath).as(Encoders.kryo(SerializableSolrInputDocument.class));
        solrDocs.foreach((ForeachFunction & Serializable)doc -> {
            Assertions.assertNotNull((Object)doc.get((Object)"__result"));
            Assertions.assertNotNull((Object)doc.get((Object)"__json"));
        });
        long docIdUnique = solrDocs.map((MapFunction & Serializable)doc -> {
            SolrInputField id = doc.getField("__indexrecordidentifier");
            return id.getFirstValue().toString();
        }, Encoders.STRING()).distinct().count();
        Assertions.assertEquals((long)xmlIdUnique, (long)docIdUnique, (String)"IDs should be unique among the output XML records");
        long jsonUnique = solrDocs.map((MapFunction & Serializable)je -> (String)je.getField("__json").getValue(), Encoders.STRING()).distinct().count();
        Assertions.assertEquals((long)jsonUnique, (long)docIdUnique, (String)"IDs should be unique among the output JSON records");
    }
}

