/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrAdminApplication;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJob;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJobTest;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public class SolrConfigExploreTest {
    protected static final Logger log = LoggerFactory.getLogger(SolrConfigExploreTest.class);
    protected static final String SHADOW_FORMAT = "c1";
    protected static final String SHADOW_COLLECTION = "c1-index-openaire";
    protected static final String PUBLIC_FORMAT = "c2";
    protected static final String PUBLIC_COLLECTION = "c2-index-openaire";
    protected static final String CONFIG_NAME = "testConfig";
    protected static SolrAdminApplication admin;
    protected static SparkSession spark;
    private static final Integer batchSize;
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private ISLookupClient isLookupClient;
    @TempDir
    public static Path workingDir;
    protected static MiniSolrCloudCluster miniCluster;

    @BeforeEach
    public void prepareMocks() throws ISLookUpException, IOException {
        this.isLookupClient.setIsLookup(this.isLookUpService);
        int solrPort = URI.create("http://" + miniCluster.getZkClient().getZkServerAddress()).getPort();
        Mockito.when((Object)this.isLookupClient.getZkHost()).thenReturn((Object)String.format("127.0.0.1:%s/solr", solrPort));
        Mockito.when((Object)this.isLookupClient.getLayoutSource(Mockito.anyString())).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml")));
        Mockito.when((Object)this.isLookupClient.getLayoutTransformer()).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl")));
    }

    @BeforeAll
    public static void setup() throws Exception {
        SparkConf conf = new SparkConf();
        conf.setAppName(XmlIndexingJobTest.class.getSimpleName());
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        conf.setMaster("local[1]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.resolve("spark").toString());
        spark = SparkSession.builder().appName(SolrConfigExploreTest.class.getSimpleName()).config(conf).getOrCreate();
        boolean jettyPort = false;
        JettyConfig jettyConfig = JettyConfig.builder().setPort(0).build();
        log.info(String.format("working directory: %s", workingDir.toString()));
        System.setProperty("solr.log.dir", workingDir.resolve("logs").toString());
        miniCluster = new MiniSolrCloudCluster(2, workingDir.resolve("solr"), jettyConfig);
        String solrZKConfigDir = "src/test/resources/eu/dnetlib/dhp/oa/provision/solr/conf/exploreTestConfig";
        File configDir = new File(solrZKConfigDir);
        miniCluster.uploadConfigSet(configDir.toPath(), CONFIG_NAME);
        System.setProperty("solr.tests.maxBufferedDocs", "100000");
        System.setProperty("solr.tests.maxIndexingThreads", "-1");
        System.setProperty("solr.tests.ramBufferSizeMB", "100");
        System.setProperty("solr.tests.mergeScheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        System.setProperty("solr.lock.type", "single");
        log.info(((ConfigSetAdminResponse.List)new ConfigSetAdminRequest.List().process((SolrClient)miniCluster.getSolrClient())).toString());
        log.info(((CollectionAdminResponse)CollectionAdminRequest.ClusterStatus.getClusterStatus().process((SolrClient)miniCluster.getSolrClient())).toString());
        NamedList<Object> res = SolrConfigExploreTest.createCollection(miniCluster.getSolrClient(), SHADOW_COLLECTION, 4, 2, 20, CONFIG_NAME);
        res.forEach(o -> log.info(o.toString()));
        res = SolrConfigExploreTest.createCollection(miniCluster.getSolrClient(), PUBLIC_COLLECTION, 4, 2, 20, CONFIG_NAME);
        res.forEach(o -> log.info(o.toString()));
        admin = new SolrAdminApplication(miniCluster.getZkClient().getZkServerAddress());
        CollectionAdminResponse rsp = (CollectionAdminResponse)admin.createAlias("public", PUBLIC_COLLECTION);
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
        rsp = (CollectionAdminResponse)admin.createAlias("shadow", SHADOW_COLLECTION);
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
        log.info(((CollectionAdminResponse)CollectionAdminRequest.ClusterStatus.getClusterStatus().process((SolrClient)miniCluster.getSolrClient())).toString());
    }

    @AfterAll
    public static void tearDown() throws Exception {
        spark.stop();
        miniCluster.shutdown();
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @Test
    public void testSolrConfig() throws Exception {
        String[] queryStrings;
        String inputPath = "src/test/resources/eu/dnetlib/dhp/oa/provision/xml";
        new XmlIndexingJob(spark, inputPath, SHADOW_FORMAT, "shadow", batchSize, Boolean.valueOf(false)).run(this.isLookupClient);
        Assertions.assertEquals((int)0, (int)miniCluster.getSolrClient().commit("shadow").getStatus());
        for (String q : queryStrings = new String[]{"cancer", "graph", "graphs"}) {
            SolrQuery query = new SolrQuery();
            query.setRequestHandler("/exploreSearch");
            query.add("q", new String[]{q});
            query.set("debugQuery", new String[]{"on"});
            log.info("Submit query to Solr with params: {}", (Object)query);
            QueryResponse rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)query);
            for (SolrDocument doc : rsp.getResults()) {
                log.info(doc.get((Object)"score") + "\t" + doc.get((Object)"__indexrecordidentifier") + "\t" + doc.get((Object)"resultidentifier") + "\t" + doc.get((Object)"resultauthor") + "\t" + doc.get((Object)"resultacceptanceyear") + "\t" + doc.get((Object)"resultsubject") + "\t" + doc.get((Object)"resulttitle") + "\t" + doc.get((Object)"relprojectname") + "\t" + doc.get((Object)"resultdescription") + "\t" + doc.get((Object)"__all") + "\t");
            }
        }
    }

    protected static NamedList<Object> createCollection(CloudSolrClient client, String name, int numShards, int replicationFactor, int maxShardsPerNode, String configName) throws Exception {
        ModifiableSolrParams modParams = new ModifiableSolrParams();
        modParams.set("action", new String[]{CollectionParams.CollectionAction.CREATE.name()});
        modParams.set("name", new String[]{name});
        modParams.set("numShards", numShards);
        modParams.set("replicationFactor", replicationFactor);
        modParams.set("collection.configName", new String[]{configName});
        modParams.set("maxShardsPerNode", maxShardsPerNode);
        QueryRequest request = new QueryRequest((SolrParams)modParams);
        request.setPath("/admin/collections");
        return client.request((SolrRequest)request);
    }

    static {
        batchSize = 100;
    }
}

