/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrAdminApplication;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrTest {
    protected static final Logger log = LoggerFactory.getLogger(SolrTest.class);
    protected static final String SHADOW_FORMAT = "c1";
    protected static final String SHADOW_COLLECTION = "c1-index-openaire";
    protected static final String PUBLIC_FORMAT = "c2";
    protected static final String PUBLIC_COLLECTION = "c2-index-openaire";
    protected static final String CONFIG_NAME = "testConfig";
    protected static SolrAdminApplication admin;
    protected static MiniSolrCloudCluster miniCluster;
    @TempDir
    public static Path workingDir;

    @BeforeAll
    public static void setup() throws Exception {
        boolean jettyPort = false;
        JettyConfig jettyConfig = JettyConfig.builder().setPort(0).build();
        log.info(String.format("working directory: %s", workingDir.toString()));
        System.setProperty("solr.log.dir", workingDir.resolve("logs").toString());
        miniCluster = new MiniSolrCloudCluster(2, workingDir.resolve("solr"), jettyConfig);
        String solrZKConfigDir = "src/test/resources/eu/dnetlib/dhp/oa/provision/solr/conf/testConfig";
        File configDir = new File(solrZKConfigDir);
        miniCluster.uploadConfigSet(configDir.toPath(), CONFIG_NAME);
        System.setProperty("solr.tests.maxBufferedDocs", "100000");
        System.setProperty("solr.tests.maxIndexingThreads", "-1");
        System.setProperty("solr.tests.ramBufferSizeMB", "100");
        System.setProperty("solr.tests.mergeScheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        System.setProperty("solr.lock.type", "single");
        log.info(((ConfigSetAdminResponse.List)new ConfigSetAdminRequest.List().process((SolrClient)miniCluster.getSolrClient())).toString());
        log.info(((CollectionAdminResponse)CollectionAdminRequest.ClusterStatus.getClusterStatus().process((SolrClient)miniCluster.getSolrClient())).toString());
        NamedList<Object> res = SolrTest.createCollection(miniCluster.getSolrClient(), SHADOW_COLLECTION, 4, 2, 20, CONFIG_NAME);
        res.forEach(o -> log.info(o.toString()));
        res = SolrTest.createCollection(miniCluster.getSolrClient(), PUBLIC_COLLECTION, 4, 2, 20, CONFIG_NAME);
        res.forEach(o -> log.info(o.toString()));
        admin = new SolrAdminApplication(miniCluster.getZkClient().getZkServerAddress());
        CollectionAdminResponse rsp = (CollectionAdminResponse)admin.createAlias("public", PUBLIC_COLLECTION);
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
        rsp = (CollectionAdminResponse)admin.createAlias("shadow", SHADOW_COLLECTION);
        Assertions.assertEquals((int)0, (int)rsp.getStatus());
        log.info(((CollectionAdminResponse)CollectionAdminRequest.ClusterStatus.getClusterStatus().process((SolrClient)miniCluster.getSolrClient())).toString());
    }

    @AfterAll
    public static void shutDown() throws Exception {
        miniCluster.shutdown();
        admin.close();
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    public static NamedList<Object> createCollection(CloudSolrClient client, String name, int numShards, int replicationFactor, int maxShardsPerNode, String configName) throws Exception {
        ModifiableSolrParams modParams = new ModifiableSolrParams();
        modParams.set("action", new String[]{CollectionParams.CollectionAction.CREATE.name()});
        modParams.set("name", new String[]{name});
        modParams.set("numShards", numShards);
        modParams.set("replicationFactor", replicationFactor);
        modParams.set("collection.configName", new String[]{configName});
        modParams.set("maxShardsPerNode", maxShardsPerNode);
        QueryRequest request = new QueryRequest((SolrParams)modParams);
        request.setPath("/admin/collections");
        return client.request((SolrRequest)request);
    }
}

