/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.provision;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.sx.provision.DropAndCreateESIndex;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;

public class SparkIndexCollectionOnES {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(SparkIndexCollectionOnES.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/index_on_es.json"))));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf().setAppName(SparkIndexCollectionOnES.class.getSimpleName()).setMaster(parser.get("master"));
        String sourcePath = parser.get("sourcePath");
        String index = parser.get("index");
        String idPath = parser.get("idPath");
        String cluster = parser.get("cluster");
        String clusterJson = IOUtils.toString((InputStream)Objects.requireNonNull(DropAndCreateESIndex.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/cluster.json")));
        Map clusterMap = (Map)new ObjectMapper().readValue(clusterJson, Map.class);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        try (JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());){
            JavaRDD inputRdd = sc.textFile(sourcePath);
            HashMap<String, String> esCfg = new HashMap<String, String>();
            esCfg.put("es.nodes", (String)clusterMap.get(cluster));
            esCfg.put("es.mapping.id", idPath);
            esCfg.put("es.batch.write.retry.count", "8");
            esCfg.put("es.batch.write.retry.wait", "60s");
            esCfg.put("es.batch.size.entries", "200");
            esCfg.put("es.nodes.wan.only", "true");
            JavaEsSpark.saveJsonToEs((JavaRDD)inputRdd, (String)index, esCfg);
        }
    }
}

