/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.model;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.common.vocabulary.VocabularyTerm;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.PersonTopic;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.solr.APC;
import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.BestAccessRight;
import eu.dnetlib.dhp.schema.solr.Category;
import eu.dnetlib.dhp.schema.solr.CodeLabel;
import eu.dnetlib.dhp.schema.solr.Concept;
import eu.dnetlib.dhp.schema.solr.Context;
import eu.dnetlib.dhp.schema.solr.Country;
import eu.dnetlib.dhp.schema.solr.Funder;
import eu.dnetlib.dhp.schema.solr.Funding;
import eu.dnetlib.dhp.schema.solr.FundingLevel;
import eu.dnetlib.dhp.schema.solr.Instance;
import eu.dnetlib.dhp.schema.solr.Journal;
import eu.dnetlib.dhp.schema.solr.Language;
import eu.dnetlib.dhp.schema.solr.OpenAccessColor;
import eu.dnetlib.dhp.schema.solr.OpenAccessRoute;
import eu.dnetlib.dhp.schema.solr.Person;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.Project;
import eu.dnetlib.dhp.schema.solr.Provenance;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.RelatedRecordHeader;
import eu.dnetlib.dhp.schema.solr.Result;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dhp.schema.solr.SolrRecordHeader;
import eu.dnetlib.dhp.schema.solr.Subject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.Nullable;

public class ProvisionModelSupport {
    private ProvisionModelSupport() {
    }

    public static Class[] getModelClasses() {
        ArrayList modelClasses = Lists.newArrayList((Object[])ModelSupport.getOafModelClasses());
        modelClasses.addAll(Lists.newArrayList((Object[])new Class[]{RelatedEntityWrapper.class, JoinedEntity.class, RelatedEntity.class}));
        return modelClasses.toArray(new Class[0]);
    }

    public static SolrRecord transform(JoinedEntity je, ContextMapper contextMapper, VocabularyGroup vocs) {
        SolrRecord r = new SolrRecord();
        OafEntity e = je.getEntity();
        RecordType type = RecordType.fromString((String)e.getClass().getSimpleName().toLowerCase());
        Boolean deletedbyinference = Optional.ofNullable(e.getDataInfo()).map(DataInfo::getDeletedbyinference).orElse(null);
        r.setHeader(SolrRecordHeader.newInstance((String)StringUtils.substringAfter((String)e.getId(), (String)"|"), (List)e.getOriginalId(), (RecordType)type, (Boolean)deletedbyinference));
        r.setCollectedfrom(ProvisionModelSupport.asProvenance(e.getCollectedfrom()));
        r.setContext(ProvisionModelSupport.asContext(e.getContext(), contextMapper));
        r.setPid(ProvisionModelSupport.asPid(e.getPid()));
        r.setMeasures(ProvisionModelSupport.mapMeasures(e.getMeasures()));
        if (e instanceof eu.dnetlib.dhp.schema.oaf.Result) {
            r.setResult(ProvisionModelSupport.mapResult((eu.dnetlib.dhp.schema.oaf.Result)e));
        } else if (e instanceof Datasource) {
            r.setDatasource(ProvisionModelSupport.mapDatasource((Datasource)e));
        } else if (e instanceof Organization) {
            r.setOrganization(ProvisionModelSupport.mapOrganization((Organization)e));
        } else if (e instanceof eu.dnetlib.dhp.schema.oaf.Project) {
            r.setProject(ProvisionModelSupport.mapProject((eu.dnetlib.dhp.schema.oaf.Project)e, vocs));
        } else if (e instanceof eu.dnetlib.dhp.schema.oaf.Person) {
            r.setPerson(ProvisionModelSupport.mapPerson((eu.dnetlib.dhp.schema.oaf.Person)e));
        }
        r.setLinks((List)Optional.ofNullable(je.getLinks()).map(links -> links.stream().map(rew -> ProvisionModelSupport.mapRelatedRecord(rew, vocs)).collect(Collectors.toList())).orElse(null));
        return r;
    }

    private static RelatedRecord mapRelatedRecord(RelatedEntityWrapper rew, VocabularyGroup vocs) {
        RelatedRecord rr = new RelatedRecord();
        RelatedEntity re = rew.getTarget();
        RecordType relatedRecordType = RecordType.fromString((String)re.getType());
        Relation relation = rew.getRelation();
        String relationProvenance = Optional.ofNullable(relation.getDataInfo()).map(d -> Optional.ofNullable(d.getProvenanceaction()).map(Qualifier::getClassid).orElse(null)).orElse(null);
        rr.setHeader(RelatedRecordHeader.newInstance((String)relation.getRelType(), (String)relation.getRelClass(), (String)StringUtils.substringAfter((String)relation.getTarget(), (String)"|"), (RecordType)relatedRecordType, (String)relationProvenance, (String)Optional.ofNullable(relation.getDataInfo()).map(DataInfo::getTrust).orElse(null)));
        Optional.ofNullable(relation.getProperties()).ifPresent(props -> {
            props.stream().filter(p -> "role".equals(p.getKey())).map(KeyValue::getValue).findFirst().ifPresent(arg_0 -> ((RelatedRecord)rr).setPersonRoleInProject(arg_0));
            List affiliationTimeline = props.stream().filter(p -> "startDate".equals(p.getKey()) || "endDate".equals(p.getKey())).map(ProvisionModelSupport::mapCodeLabel).collect(Collectors.toList());
            if (!affiliationTimeline.isEmpty()) {
                rr.setAffiliationsTimeline(affiliationTimeline);
            }
        });
        rr.setAcronym(re.getAcronym());
        rr.setCode(re.getCode());
        rr.setContracttype(ProvisionModelSupport.mapCodeLabel(re.getContracttype()));
        rr.setCollectedfrom(ProvisionModelSupport.asProvenance(re.getCollectedfrom()));
        rr.setCodeRepositoryUrl(re.getCodeRepositoryUrl());
        rr.setCountry(ProvisionModelSupport.asCountry(re.getCountry()));
        rr.setDatasourcetype(ProvisionModelSupport.mapCodeLabel(re.getDatasourcetype()));
        rr.setDatasourcetypeui(ProvisionModelSupport.mapCodeLabel(re.getDatasourcetypeui()));
        rr.setDateofacceptance(re.getDateofacceptance());
        rr.setFunding(ProvisionModelSupport.mapFunding(re.getFundingtree(), vocs));
        rr.setInstances(ProvisionModelSupport.mapInstances(re.getInstances()));
        rr.setLegalname(re.getLegalname());
        rr.setLegalshortname(re.getLegalshortname());
        rr.setOfficialname(re.getOfficialname());
        rr.setOpenairecompatibility(ProvisionModelSupport.mapCodeLabel(re.getOpenairecompatibility()));
        rr.setPid(ProvisionModelSupport.asPid(re.getPid()));
        rr.setWebsiteurl(re.getWebsiteurl());
        rr.setProjectTitle(re.getProjectTitle());
        rr.setPublisher(re.getPublisher());
        rr.setResulttype(ProvisionModelSupport.mapQualifier(re.getResulttype()));
        rr.setTitle((String)Optional.ofNullable(re.getTitle()).map(StructuredProperty::getValue).orElse(null));
        rr.setDescription(StringUtils.left((String)re.getDescription(), (int)500));
        rr.setAuthor((List)Optional.ofNullable(re.getAuthor()).map(aa -> aa.stream().limit(20L).collect(Collectors.toList())).orElse(null));
        if (relation.getValidated() == null) {
            relation.setValidated(Boolean.valueOf(false));
        }
        if ("outcome".equals(relation.getSubRelType()) && StringUtils.isNotBlank((CharSequence)relation.getValidationDate())) {
            rr.setValidationDate(relation.getValidationDate());
        }
        rr.setGivenName(re.getGivenName());
        rr.setFamilyName(re.getFamilyName());
        return rr;
    }

    private static Project mapProject(eu.dnetlib.dhp.schema.oaf.Project p, VocabularyGroup vocs) {
        Project ps = new Project();
        ps.setAcronym((String)ProvisionModelSupport.mapField(p.getAcronym()));
        ps.setCode((String)ProvisionModelSupport.mapField(p.getCode()));
        ps.setContracttype(ProvisionModelSupport.mapCodeLabel(p.getContracttype()));
        ps.setCurrency((String)ProvisionModelSupport.mapField(p.getCurrency()));
        ps.setDuration((String)ProvisionModelSupport.mapField(p.getDuration()));
        ps.setOamandatepublications((String)ProvisionModelSupport.mapField(p.getOamandatepublications()));
        ps.setCallidentifier((String)ProvisionModelSupport.mapField(p.getCallidentifier()));
        ps.setEcarticle29_3((String)ProvisionModelSupport.mapField(p.getEcarticle29_3()));
        ps.setEnddate((String)ProvisionModelSupport.mapField(p.getEnddate()));
        ps.setFundedamount(p.getFundedamount());
        ps.setKeywords((String)ProvisionModelSupport.mapField(p.getKeywords()));
        ps.setStartdate((String)ProvisionModelSupport.mapField(p.getStartdate()));
        ps.setSubjects(ProvisionModelSupport.asSubjectSP(p.getSubjects()));
        ps.setSummary((String)ProvisionModelSupport.mapField(p.getSummary()));
        ps.setTitle((String)ProvisionModelSupport.mapField(p.getTitle()));
        ps.setTotalcost(p.getTotalcost());
        ps.setWebsiteurl((String)ProvisionModelSupport.mapField(p.getWebsiteurl()));
        ps.setFunding(ProvisionModelSupport.mapFundingField(p.getFundingtree(), vocs));
        return ps;
    }

    private static Person mapPerson(eu.dnetlib.dhp.schema.oaf.Person p) {
        Person ps = new Person();
        ps.setFamilyName(p.getFamilyName());
        ps.setGivenName(p.getGivenName());
        ps.setAlternativeNames(p.getAlternativeNames());
        ps.setBiography(p.getBiography());
        ps.setConsent(p.getConsent());
        ps.setSubject(ProvisionModelSupport.mapPersonTopics(p.getSubject()));
        return ps;
    }

    private static List<eu.dnetlib.dhp.schema.solr.PersonTopic> mapPersonTopics(List<PersonTopic> subjects) {
        return Optional.ofNullable(subjects).map(ss -> ss.stream().map(ProvisionModelSupport::mapPersonTopic).collect(Collectors.toList())).orElse(null);
    }

    private static eu.dnetlib.dhp.schema.solr.PersonTopic mapPersonTopic(PersonTopic pt) {
        eu.dnetlib.dhp.schema.solr.PersonTopic topic = new eu.dnetlib.dhp.schema.solr.PersonTopic();
        topic.setValue(pt.getValue());
        topic.setSchema(pt.getSchema());
        topic.setFromYear(pt.getFromYear());
        topic.setToYear(pt.getToYear());
        return topic;
    }

    private static Funding mapFunding(List<String> fundingtree, VocabularyGroup vocs) {
        SAXReader reader = new SAXReader();
        return Optional.ofNullable(fundingtree).flatMap(ftree -> ftree.stream().map(ft -> {
            try {
                Document doc = reader.read((Reader)new StringReader((String)ft));
                String countryCode = doc.valueOf("/fundingtree/funder/jurisdiction/text()");
                Country country = vocs.find("dnet:countries").map(voc -> voc.getTerm(countryCode)).map(VocabularyTerm::getName).map(label -> Country.newInstance((String)countryCode, (String)label)).orElse(null);
                String level0_id = doc.valueOf("//funding_level_0/id/text()");
                String level1_id = doc.valueOf("//funding_level_1/id/text()");
                String level2_id = doc.valueOf("//funding_level_2/id/text()");
                return Funding.newInstance((Funder)Funder.newInstance((String)doc.valueOf("/fundingtree/funder/id/text()"), (String)doc.valueOf("/fundingtree/funder/shortname/text()"), (String)doc.valueOf("/fundingtree/funder/name/text()"), (Country)country, new ArrayList()), (FundingLevel)Optional.ofNullable(level0_id).map(id -> FundingLevel.newInstance((String)id, (String)doc.valueOf("//funding_level_0/description/text()"), (String)doc.valueOf("//funding_level_0/name/text()"))).orElse(null), (FundingLevel)Optional.ofNullable(level1_id).map(id -> FundingLevel.newInstance((String)id, (String)doc.valueOf("//funding_level_1/description/text()"), (String)doc.valueOf("//funding_level_1/name/text()"))).orElse(null), (FundingLevel)Optional.ofNullable(level2_id).map(id -> FundingLevel.newInstance((String)id, (String)doc.valueOf("//funding_level_2/description/text()"), (String)doc.valueOf("//funding_level_2/name/text()"))).orElse(null));
            }
            catch (DocumentException e) {
                throw new IllegalArgumentException(e);
            }
        }).findFirst()).orElse(null);
    }

    private static Funding mapFundingField(List<Field<String>> fundingtree, VocabularyGroup vocs) {
        return ProvisionModelSupport.mapFunding(Optional.ofNullable(fundingtree).map(fts -> fts.stream().map(Field::getValue).collect(Collectors.toList())).orElse(null), vocs);
    }

    private static eu.dnetlib.dhp.schema.solr.Organization mapOrganization(Organization o) {
        eu.dnetlib.dhp.schema.solr.Organization org = new eu.dnetlib.dhp.schema.solr.Organization();
        org.setCountry(ProvisionModelSupport.mapCodeLabel(o.getCountry()));
        org.setLegalname((String)ProvisionModelSupport.mapField(o.getLegalname()));
        org.setLegalshortname((String)ProvisionModelSupport.mapField(o.getLegalshortname()));
        org.setAlternativeNames(ProvisionModelSupport.mapFieldList(o.getAlternativeNames()));
        org.setWebsiteurl((String)ProvisionModelSupport.mapField(o.getWebsiteurl()));
        org.setLogourl((String)ProvisionModelSupport.mapField(o.getLogourl()));
        org.setEcenterprise((String)ProvisionModelSupport.mapField(o.getEcenterprise()));
        org.setEchighereducation((String)ProvisionModelSupport.mapField(o.getEchighereducation()));
        org.setEclegalbody((String)ProvisionModelSupport.mapField(o.getEclegalbody()));
        org.setEcinternationalorganization((String)ProvisionModelSupport.mapField(o.getEcinternationalorganization()));
        org.setEcinternationalorganizationeurinterests((String)ProvisionModelSupport.mapField(o.getEcinternationalorganizationeurinterests()));
        org.setEclegalperson((String)ProvisionModelSupport.mapField(o.getEclegalperson()));
        org.setEcnonprofit((String)ProvisionModelSupport.mapField(o.getEcnonprofit()));
        org.setEcnutscode((String)ProvisionModelSupport.mapField(o.getEcnutscode()));
        org.setEcresearchorganization((String)ProvisionModelSupport.mapField(o.getEcresearchorganization()));
        org.setEcsmevalidated((String)ProvisionModelSupport.mapField(o.getEcsmevalidated()));
        return org;
    }

    private static eu.dnetlib.dhp.schema.solr.Datasource mapDatasource(Datasource d) {
        eu.dnetlib.dhp.schema.solr.Datasource ds = new eu.dnetlib.dhp.schema.solr.Datasource();
        ds.setEnglishname((String)ProvisionModelSupport.mapField(d.getEnglishname()));
        ds.setOfficialname((String)ProvisionModelSupport.mapField(d.getOfficialname()));
        ds.setDescription((String)ProvisionModelSupport.mapField(d.getDescription()));
        ds.setJournal(ProvisionModelSupport.mapJournal(d.getJournal()));
        ds.setWebsiteurl((String)ProvisionModelSupport.mapField(d.getWebsiteurl()));
        ds.setLogourl((String)ProvisionModelSupport.mapField(d.getLogourl()));
        ds.setAccessinfopackage(ProvisionModelSupport.mapFieldList(d.getAccessinfopackage()));
        ds.setCertificates((String)ProvisionModelSupport.mapField(d.getCertificates()));
        ds.setCitationguidelineurl((String)ProvisionModelSupport.mapField(d.getCitationguidelineurl()));
        ds.setConsenttermsofuse(d.getConsenttermsofuse());
        ds.setConsenttermsofusedate(d.getConsenttermsofusedate());
        ds.setContactemail((String)ProvisionModelSupport.mapField(d.getContactemail()));
        ds.setContentpolicies(ProvisionModelSupport.mapCodeLabel(d.getContentpolicies()));
        ds.setDatabaseaccessrestriction((String)ProvisionModelSupport.mapField(d.getDatabaseaccessrestriction()));
        ds.setDatabaseaccesstype((String)ProvisionModelSupport.mapField(d.getDatabaseaccesstype()));
        ds.setDataprovider((Boolean)ProvisionModelSupport.mapField(d.getDataprovider()));
        ds.setDatasourcetype(ProvisionModelSupport.mapCodeLabel(d.getDatasourcetype()));
        ds.setDatasourcetypeui(ProvisionModelSupport.mapCodeLabel(d.getDatasourcetypeui()));
        ds.setDatauploadrestriction((String)ProvisionModelSupport.mapField(d.getDatauploadrestriction()));
        ds.setDatauploadtype((String)ProvisionModelSupport.mapField(d.getDatauploadtype()));
        ds.setDateofvalidation((String)ProvisionModelSupport.mapField(d.getDateofvalidation()));
        ds.setEoscdatasourcetype(ProvisionModelSupport.mapCodeLabel(d.getEoscdatasourcetype()));
        ds.setEosctype(ProvisionModelSupport.mapCodeLabel(d.getEosctype()));
        ds.setFulltextdownload(d.getFulltextdownload());
        ds.setJurisdiction(ProvisionModelSupport.mapCodeLabel(d.getJurisdiction()));
        ds.setLanguages(d.getLanguages());
        ds.setLatitude((String)ProvisionModelSupport.mapField(d.getLatitude()));
        ds.setLongitude((String)ProvisionModelSupport.mapField(d.getLongitude()));
        ds.setLastconsenttermsofusedate(d.getLastconsenttermsofusedate());
        ds.setMissionstatementurl((String)ProvisionModelSupport.mapField(d.getMissionstatementurl()));
        ds.setNamespaceprefix((String)ProvisionModelSupport.mapField(d.getNamespaceprefix()));
        ds.setOdcontenttypes(ProvisionModelSupport.mapFieldList(d.getOdcontenttypes()));
        ds.setOdlanguages(ProvisionModelSupport.mapFieldList(d.getOdlanguages()));
        ds.setOdnumberofitems((String)ProvisionModelSupport.mapField(d.getOdnumberofitems()));
        ds.setOdnumberofitemsdate((String)ProvisionModelSupport.mapField(d.getOdnumberofitemsdate()));
        ds.setOdpolicies((String)ProvisionModelSupport.mapField(d.getOdpolicies()));
        ds.setOpenairecompatibility(ProvisionModelSupport.mapCodeLabel(d.getOpenairecompatibility()));
        ds.setPidsystems((String)ProvisionModelSupport.mapField(d.getPidsystems()));
        ds.setPolicies(ProvisionModelSupport.mapCodeLabelKV(d.getPolicies()));
        ds.setPreservationpolicyurl(d.getPreservationpolicyurl());
        ds.setProvidedproducttypes(ds.getProvidedproducttypes());
        ds.setReleaseenddate((String)ProvisionModelSupport.mapField(d.getReleasestartdate()));
        ds.setReleasestartdate((String)ProvisionModelSupport.mapField(d.getReleasestartdate()));
        ds.setResearchentitytypes(ds.getResearchentitytypes());
        ds.setResearchproductaccesspolicies(d.getResearchproductaccesspolicies());
        ds.setResearchproductmetadataaccesspolicies(d.getResearchproductmetadataaccesspolicies());
        ds.setServiceprovider((Boolean)ProvisionModelSupport.mapField(d.getServiceprovider()));
        ds.setSubjects(ProvisionModelSupport.asSubjectSP(d.getSubjects()));
        ds.setSubmissionpolicyurl(d.getSubmissionpolicyurl());
        ds.setThematic(d.getThematic());
        ds.setContentpolicies(ProvisionModelSupport.mapCodeLabel(d.getContentpolicies()));
        ds.setVersioncontrol(d.getVersioncontrol());
        ds.setVersioning((Boolean)ProvisionModelSupport.mapField(d.getVersioning()));
        return ds;
    }

    private static Result mapResult(eu.dnetlib.dhp.schema.oaf.Result r) {
        Result rs = new Result();
        rs.setResulttype(ProvisionModelSupport.mapQualifier(r.getResulttype()));
        rs.setAuthor(ProvisionModelSupport.asAuthor(r.getAuthor()));
        rs.setMaintitle(ProvisionModelSupport.getMaintitle(r.getTitle()));
        rs.setOtherTitles(ProvisionModelSupport.getOtherTitles(r.getTitle()));
        rs.setDescription(ProvisionModelSupport.mapFieldList(r.getDescription()));
        rs.setSubject(ProvisionModelSupport.asSubject(r.getSubject()));
        rs.setLanguage(ProvisionModelSupport.asLanguage(r.getLanguage()));
        rs.setPublicationdate((String)ProvisionModelSupport.mapField(r.getDateofacceptance()));
        rs.setPublisher((String)ProvisionModelSupport.mapField(r.getPublisher()));
        rs.setEmbargoenddate((String)ProvisionModelSupport.mapField(r.getEmbargoenddate()));
        rs.setSource(ProvisionModelSupport.mapFieldList(r.getSource()));
        rs.setFormat(ProvisionModelSupport.mapFieldList(r.getFormat()));
        rs.setContributor(ProvisionModelSupport.mapFieldList(r.getContributor()));
        rs.setCoverage(ProvisionModelSupport.mapFieldList(r.getCoverage()));
        Optional.ofNullable(r.getBestaccessright()).map(b -> BestAccessRight.newInstance((String)b.getClassid(), (String)b.getClassname())).ifPresent(arg_0 -> ((Result)rs).setBestaccessright(arg_0));
        rs.setFulltext(ProvisionModelSupport.mapFieldList(r.getFulltext()));
        rs.setCountry(ProvisionModelSupport.asCountry(r.getCountry()));
        rs.setEoscifguidelines(ProvisionModelSupport.asEOSCIF(r.getEoscifguidelines()));
        rs.setIsGreen(r.getIsGreen());
        rs.setOpenAccessColor((OpenAccessColor)Optional.ofNullable(r.getOpenAccessColor()).map(color -> OpenAccessColor.valueOf((String)color.toString())).orElse(null));
        rs.setIsInDiamondJournal(r.getIsInDiamondJournal());
        rs.setPubliclyFunded(r.getPubliclyFunded());
        rs.setTransformativeAgreement(r.getTransformativeAgreement());
        rs.setExternalReference(ProvisionModelSupport.mapExternalReference(r.getExternalReference()));
        rs.setBestinstancetype(ProvisionModelSupport.mapQualifier(r.getBestInstancetype()));
        rs.setInstance(ProvisionModelSupport.mapInstances(r.getInstance()));
        if (r instanceof Publication) {
            Publication pub = (Publication)r;
            rs.setJournal(ProvisionModelSupport.mapJournal(pub.getJournal()));
        } else if (r instanceof Dataset) {
            Dataset d = (Dataset)r;
            rs.setSize((String)ProvisionModelSupport.mapField(d.getSize()));
            rs.setVersion((String)ProvisionModelSupport.mapField(d.getVersion()));
        } else if (r instanceof Software) {
            Software sw = (Software)r;
            rs.setCodeRepositoryUrl((String)ProvisionModelSupport.mapField(sw.getCodeRepositoryUrl()));
            rs.setProgrammingLanguage(ProvisionModelSupport.mapQualifier(sw.getProgrammingLanguage()));
            rs.setDocumentationUrl(ProvisionModelSupport.mapFieldList(sw.getDocumentationUrl()));
        } else if (r instanceof OtherResearchProduct) {
            OtherResearchProduct orp = (OtherResearchProduct)r;
            rs.setContactperson(ProvisionModelSupport.mapFieldList(orp.getContactperson()));
            rs.setContactgroup(ProvisionModelSupport.mapFieldList(orp.getContactgroup()));
            rs.setTool(ProvisionModelSupport.mapFieldList(orp.getTool()));
        }
        return rs;
    }

    private static Language asLanguage(Qualifier lang) {
        return Optional.ofNullable(lang).map(q -> Language.newInstance((String)q.getClassid(), (String)q.getClassname())).orElse(null);
    }

    @Nullable
    private static List<String> getOtherTitles(List<StructuredProperty> titleList) {
        return Optional.ofNullable(titleList).map(titles -> titles.stream().filter(t -> !"main title".equals(Optional.ofNullable(t.getQualifier()).map(Qualifier::getClassname).orElse(null))).map(StructuredProperty::getValue).collect(Collectors.toList())).orElse(null);
    }

    private static String getMaintitle(List<StructuredProperty> titleList) {
        return Optional.ofNullable(titleList).flatMap(titles -> titles.stream().filter(t -> "main title".equals(Optional.ofNullable(t.getQualifier()).map(Qualifier::getClassname).orElse(null))).map(StructuredProperty::getValue).findFirst()).orElse(null);
    }

    private static List<Instance> mapInstances(List<eu.dnetlib.dhp.schema.oaf.Instance> instanceList) {
        return Optional.ofNullable(instanceList).map(instances -> instances.stream().map(instance -> {
            Instance i = new Instance();
            i.setCollectedfrom(ProvisionModelSupport.asProvenance(instance.getCollectedfrom()));
            i.setHostedby(ProvisionModelSupport.asProvenance(instance.getHostedby()));
            i.setFulltext(instance.getFulltext());
            i.setPid(ProvisionModelSupport.asPid(instance.getPid()));
            i.setAlternateIdentifier(ProvisionModelSupport.asPid(instance.getAlternateIdentifier()));
            i.setAccessright(ProvisionModelSupport.mapAccessRight(instance.getAccessright()));
            i.setInstancetype(ProvisionModelSupport.mapQualifier(instance.getInstancetype()));
            i.setLicense((String)ProvisionModelSupport.mapField(instance.getLicense()));
            i.setUrl(instance.getUrl());
            i.setRefereed(ProvisionModelSupport.mapQualifier(instance.getRefereed()));
            i.setDateofacceptance((String)ProvisionModelSupport.mapField(instance.getDateofacceptance()));
            i.setDistributionlocation(instance.getDistributionlocation());
            i.setProcessingcharges(ProvisionModelSupport.getProcessingcharges(instance));
            return i;
        }).collect(Collectors.toList())).orElse(null);
    }

    private static APC getProcessingcharges(eu.dnetlib.dhp.schema.oaf.Instance instance) {
        return Optional.of(APC.newInstance((String)((String)ProvisionModelSupport.mapField(instance.getProcessingchargecurrency())), (String)((String)ProvisionModelSupport.mapField(instance.getProcessingchargeamount())))).filter(apc -> Objects.nonNull(apc.getAmount()) && Objects.nonNull(apc.getCurrency())).orElse(null);
    }

    private static eu.dnetlib.dhp.schema.solr.AccessRight mapAccessRight(AccessRight accessright) {
        return Optional.ofNullable(accessright).map(ar -> eu.dnetlib.dhp.schema.solr.AccessRight.newInstance((String)accessright.getClassid(), (String)accessright.getClassname(), (OpenAccessRoute)Optional.ofNullable(accessright.getOpenAccessRoute()).map(route -> OpenAccessRoute.valueOf((String)route.toString())).orElse(null))).orElse(null);
    }

    private static <T> T mapField(Field<T> f) {
        return Optional.ofNullable(f).map(Field::getValue).orElse(null);
    }

    private static <T> List<T> mapFieldList(List<Field<T>> fl) {
        return Optional.ofNullable(fl).map(v -> v.stream().map(Field::getValue).collect(Collectors.toList())).orElse(null);
    }

    private static String mapQualifier(Qualifier q) {
        return Optional.ofNullable(q).map(Qualifier::getClassname).orElse(null);
    }

    private static Journal mapJournal(eu.dnetlib.dhp.schema.oaf.Journal joaf) {
        return Optional.ofNullable(joaf).map(jo -> {
            Journal j = new Journal();
            j.setConferencedate(jo.getConferencedate());
            j.setConferenceplace(jo.getConferenceplace());
            j.setEdition(jo.getEdition());
            j.setSp(jo.getSp());
            j.setEp(jo.getEp());
            j.setVol(jo.getVol());
            j.setIss(jo.getEdition());
            j.setName(jo.getName());
            j.setIssnPrinted(jo.getIssnPrinted());
            j.setIssnOnline(jo.getIssnOnline());
            j.setIssnLinking(jo.getIssnLinking());
            return j;
        }).orElse(null);
    }

    private static List<Provenance> asProvenance(List<KeyValue> keyValueList) {
        return Optional.ofNullable(keyValueList).map(kvs -> kvs.stream().map(ProvisionModelSupport::asProvenance).collect(Collectors.toList())).orElse(null);
    }

    private static Provenance asProvenance(KeyValue keyValue) {
        return Optional.ofNullable(keyValue).map(kv -> Provenance.newInstance((String)StringUtils.substringAfter((String)kv.getKey(), (String)"|"), (String)kv.getValue())).orElse(null);
    }

    private static List<eu.dnetlib.dhp.schema.solr.Measure> mapMeasures(List<Measure> measures) {
        return Optional.ofNullable(measures).map(ml -> ml.stream().map(m -> eu.dnetlib.dhp.schema.solr.Measure.newInstance((String)m.getId(), ProvisionModelSupport.mapCodeLabelKV(m.getUnit()))).collect(Collectors.toList())).orElse(null);
    }

    private static List<eu.dnetlib.dhp.schema.solr.ExternalReference> mapExternalReference(List<ExternalReference> externalReference) {
        return Optional.ofNullable(externalReference).map(ext -> ext.stream().map(e -> eu.dnetlib.dhp.schema.solr.ExternalReference.newInstance((String)e.getSitename(), (String)e.getLabel(), (List)e.getAlternateLabel(), (String)e.getUrl(), (CodeLabel)ProvisionModelSupport.mapCodeLabel(e.getQualifier()), (String)e.getRefidentifier(), (String)e.getQuery())).collect(Collectors.toList())).orElse(Lists.newArrayList());
    }

    private static List<Context> asContext(List<eu.dnetlib.dhp.schema.oaf.Context> ctxList, ContextMapper contextMapper) {
        Set contexts = Optional.ofNullable(ctxList).map(ctx -> ctx.stream().map(eu.dnetlib.dhp.schema.oaf.Context::getId).collect(Collectors.toCollection(HashSet::new))).orElse(new HashSet());
        if (contexts.contains("dh-ch::subcommunity::2")) {
            contexts.add("clarin");
        }
        return Optional.of(contexts).map(ctx -> ctx.stream().map(contextPath -> {
            Context context = new Context();
            Object id = "";
            HashMap categoryMap = Maps.newHashMap();
            for (String token : Splitter.on((String)"::").split((CharSequence)contextPath)) {
                String parentId;
                ContextDef def = (ContextDef)contextMapper.get(id = (String)id + token);
                if (def == null) continue;
                if (def.getName().equals("context")) {
                    context.setId(def.getId());
                    context.setLabel(def.getLabel());
                    context.setType(def.getType());
                }
                if (def.getName().equals("category")) {
                    Category category = Category.newInstance((String)def.getId(), (String)def.getLabel());
                    if (Objects.isNull(context.getCategory())) {
                        context.setCategory((List)Lists.newArrayList());
                    }
                    context.getCategory().add(category);
                    categoryMap.put(def.getId(), category);
                }
                if (def.getName().equals("concept") && categoryMap.containsKey(parentId = StringUtils.substringBeforeLast((String)def.getId(), (String)"::"))) {
                    ((Category)categoryMap.get(parentId)).getConcept().add(Concept.newInstance((String)def.getId(), (String)def.getLabel()));
                }
                id = (String)id + "::";
            }
            return context;
        }).collect(Collectors.toList())).orElse(null);
    }

    private static List<Pid> asPid(List<StructuredProperty> pidList) {
        return Optional.ofNullable(pidList).map(pids -> pids.stream().filter(p -> Objects.nonNull(p.getQualifier())).filter(p -> Objects.nonNull(p.getQualifier().getClassid())).map(p -> Pid.newInstance((String)p.getValue(), (String)p.getQualifier().getClassid(), (String)p.getQualifier().getClassname())).collect(Collectors.toList())).orElse(null);
    }

    private static List<Author> asAuthor(List<eu.dnetlib.dhp.schema.oaf.Author> authorList) {
        return ProvisionModelSupport.asAuthor(authorList, 200);
    }

    private static List<Author> asAuthor(List<eu.dnetlib.dhp.schema.oaf.Author> authorList, int maxAuthors) {
        return Optional.ofNullable(authorList).map(authors -> authors.stream().limit(maxAuthors).map(a -> Author.newInstance((String)StringUtils.left((String)a.getFullname(), (int)1000), (String)a.getName(), (String)a.getSurname(), (int)a.getRank(), ProvisionModelSupport.asPid(a.getPid()))).collect(Collectors.toList())).orElse(null);
    }

    private static List<Subject> asSubject(List<eu.dnetlib.dhp.schema.oaf.Subject> subjectList) {
        return Optional.ofNullable(subjectList).map(subjects -> subjects.stream().filter(s -> Objects.nonNull(s.getQualifier())).filter(s -> Objects.nonNull(s.getQualifier().getClassname())).filter(ProvisionModelSupport::filterFosL1L2).map(s -> Subject.newInstance((String)s.getValue(), (String)s.getQualifier().getClassid(), (String)s.getQualifier().getClassname())).collect(Collectors.toList())).orElse(null);
    }

    private static List<Subject> asSubjectSP(List<StructuredProperty> subjectList) {
        return Optional.ofNullable(subjectList).map(subjects -> subjects.stream().filter(s -> Objects.nonNull(s.getQualifier())).filter(s -> Objects.nonNull(s.getQualifier().getClassname())).map(s -> Subject.newInstance((String)s.getValue(), (String)s.getQualifier().getClassid(), (String)s.getQualifier().getClassname())).collect(Collectors.toList())).orElse(null);
    }

    public static boolean filterFosL1L2(StructuredProperty s) {
        String subjectType = Optional.ofNullable(s.getQualifier()).map(Qualifier::getClassid).orElse("");
        if ("FOS".equals(subjectType)) {
            String code = StringUtils.substringBefore((String)s.getValue(), (String)" ");
            return code.matches("^\\d{2}$|^\\d{4}$");
        }
        return true;
    }

    private static Country asCountry(Qualifier country) {
        return Optional.ofNullable(country).filter(c -> Objects.nonNull(c.getClassid()) && Objects.nonNull(c.getClassname())).map(c -> Country.newInstance((String)c.getClassid(), (String)c.getClassname())).orElse(null);
    }

    private static List<Country> asCountry(List<eu.dnetlib.dhp.schema.oaf.Country> countryList) {
        return Optional.ofNullable(countryList).map(countries -> countries.stream().map(c -> Country.newInstance((String)c.getClassid(), (String)c.getClassname())).collect(Collectors.toList())).orElse(null);
    }

    private static List<eu.dnetlib.dhp.schema.solr.EoscIfGuidelines> asEOSCIF(List<EoscIfGuidelines> eoscIfGuidelines) {
        return Optional.ofNullable(eoscIfGuidelines).map(eoscif -> eoscif.stream().map(e -> eu.dnetlib.dhp.schema.solr.EoscIfGuidelines.newInstance((String)e.getCode(), (String)e.getLabel(), (String)e.getUrl(), (String)e.getSemanticRelation())).collect(Collectors.toList())).orElse(null);
    }

    private static List<CodeLabel> mapCodeLabelKV(List<KeyValue> kvList) {
        return Optional.ofNullable(kvList).map(kvs -> kvs.stream().map(ProvisionModelSupport::mapCodeLabel).collect(Collectors.toList())).orElse(null);
    }

    private static List<CodeLabel> mapCodeLabel(List<Qualifier> qualifiers) {
        return Optional.ofNullable(qualifiers).map(list -> list.stream().map(ProvisionModelSupport::mapCodeLabel).collect(Collectors.toList())).orElse(null);
    }

    private static CodeLabel mapCodeLabel(Qualifier qualifier) {
        return Optional.ofNullable(qualifier).map(q -> CodeLabel.newInstance((String)q.getClassid(), (String)q.getClassname())).orElse(null);
    }

    private static CodeLabel mapCodeLabel(KeyValue kv) {
        return Optional.ofNullable(kv).map(k -> CodeLabel.newInstance((String)k.getKey(), (String)k.getValue())).orElse(null);
    }
}

