/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.google.common.base.Joiner;
import eu.dnetlib.dhp.common.api.context.CategorySummary;
import eu.dnetlib.dhp.common.api.context.CategorySummaryList;
import eu.dnetlib.dhp.common.api.context.ConceptSummary;
import eu.dnetlib.dhp.common.api.context.ConceptSummaryList;
import eu.dnetlib.dhp.common.api.context.ContextSummary;
import eu.dnetlib.dhp.common.api.context.ContextSummaryList;
import eu.dnetlib.dhp.common.rest.DNetRestClient;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ContextMapper
extends HashMap<String, ContextDef>
implements Serializable {
    private static final long serialVersionUID = 2159682308502487305L;
    private static final String XQUERY = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ContextDSResourceType']//*[name()='context' or name()='category' or name()='concept'] return <entry id=\"{$x/@id}\" label=\"{$x/@label|$x/@name}\" name=\"{$x/name()}\" type=\"{$x/@type}\"/>";

    public static ContextMapper fromAPI(String baseURL) throws Exception {
        ContextMapper contextMapper = new ContextMapper();
        for (ContextSummary ctx : (ContextSummaryList)DNetRestClient.doGET((String)String.format("%s/contexts", baseURL), ContextSummaryList.class)) {
            contextMapper.put(ctx.getId(), new ContextDef(ctx.getId(), ctx.getLabel(), "context", ctx.getType()));
            for (CategorySummary cat : (CategorySummaryList)DNetRestClient.doGET((String)String.format("%s/context/%s?all=true", baseURL, ctx.getId()), CategorySummaryList.class)) {
                contextMapper.put(cat.getId(), new ContextDef(cat.getId(), cat.getLabel(), "category", ""));
                if (!cat.isHasConcept()) continue;
                for (ConceptSummary c : (ConceptSummaryList)DNetRestClient.doGET((String)String.format("%s/context/category/%s?all=true", baseURL, cat.getId()), ConceptSummaryList.class)) {
                    contextMapper.put(c.getId(), new ContextDef(c.getId(), c.getLabel(), "concept", ""));
                    if (!c.isHasSubConcept()) continue;
                    for (ConceptSummary cs : c.getConcepts()) {
                        contextMapper.put(cs.getId(), new ContextDef(cs.getId(), cs.getLabel(), "concept", ""));
                        if (!cs.isHasSubConcept()) continue;
                        for (ConceptSummary css : cs.getConcepts()) {
                            contextMapper.put(css.getId(), new ContextDef(css.getId(), css.getLabel(), "concept", ""));
                        }
                    }
                }
            }
        }
        return contextMapper;
    }

    @Deprecated
    public static ContextMapper fromIS(String isLookupUrl) throws DocumentException, ISLookUpException, SAXException {
        ISLookUpService isLookUp = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        StringBuilder sb = new StringBuilder("<ContextDSResources>");
        Joiner.on((String)"").appendTo(sb, (Iterable)isLookUp.quickSearchProfile(XQUERY));
        sb.append("</ContextDSResources>");
        return ContextMapper.fromXml(sb.toString());
    }

    @Deprecated
    public static ContextMapper fromXml(String xml) throws DocumentException, SAXException {
        ContextMapper contextMapper = new ContextMapper();
        SAXReader reader = new SAXReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = reader.read((Reader)new StringReader(xml));
        for (Object o : doc.selectNodes("//entry")) {
            Node node = (Node)o;
            String id = node.valueOf("./@id");
            String label = node.valueOf("./@label");
            String name = node.valueOf("./@name");
            String type = node.valueOf("./@type");
            contextMapper.put(id, new ContextDef(id, label, name, type));
        }
        return contextMapper;
    }
}

