/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import eu.dnetlib.dhp.index.es.ESFeeder;
import eu.dnetlib.dhp.sx.provision.ConvertScholixResourceToES;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIndexCollectionES8 {
    private static final Logger log = LoggerFactory.getLogger(SparkIndexCollectionES8.class);
    private final FileSystem fileSystem;

    public SparkIndexCollectionES8(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(SparkIndexCollectionES8.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/scholexplorer_parameter.json"))));
        argumentParser.parseArgument(args);
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI is {}", (Object)hdfsuri);
        String sourcePath = argumentParser.get("sourcePath");
        log.info("sourcePath is {}", (Object)sourcePath);
        String index = argumentParser.get("index");
        log.info("index is {}", (Object)index);
        String indexHost = argumentParser.get("indexHost");
        log.info("indexHost is {}", (Object)indexHost);
        String tc = argumentParser.get("threadCount");
        log.info("threadCount is {}", (Object)tc);
        int threadCount = 10;
        if (tc != null && !tc.isEmpty()) {
            try {
                threadCount = Integer.parseInt(tc);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid thread count provided, using default: {}", (Object)threadCount);
            }
        }
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        new SparkIndexCollectionES8(fileSystem).run(sourcePath, index, indexHost, threadCount);
    }

    public void run(String sourcePath, String index, String indexHost, int threadCount) throws IOException {
        RemoteIterator ls = this.fileSystem.listFiles(new Path(sourcePath), false);
        ArrayList<Path> files = new ArrayList<Path>();
        while (ls.hasNext()) {
            LocatedFileStatus current = (LocatedFileStatus)ls.next();
            if (!current.getPath().getName().endsWith(".gz")) continue;
            files.add(current.getPath());
        }
        try (ESFeeder feeder = new ESFeeder(indexHost);){
            ConvertScholixResourceToES converter = index.contains("summary") ? new ConvertScholixResourceToES(index) : new ConvertJSONWithId("\"identifier\":\"((\\d|\\w)*)\"", index);
            feeder.parallelBulkIndex(files, threadCount, this.fileSystem, (Function)converter);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

