/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.provision;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropAndCreateESIndex {
    private static final Logger log = LoggerFactory.getLogger(DropAndCreateESIndex.class);
    public static final String STATUS_CODE_TEXT = "status code: {}";
    public static final String APPLICATION_JSON = "application/json";

    public static void main(String[] args) throws Exception {
        CloseableHttpResponse response;
        StringEntity entity;
        HttpPut put;
        CloseableHttpResponse response2;
        HttpDelete delete;
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(DropAndCreateESIndex.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/dropAndCreateIndex.json"))));
        parser.parseArgument(args);
        String index = parser.get("index");
        String cluster = parser.get("cluster");
        String clusterJson = IOUtils.toString((InputStream)Objects.requireNonNull(DropAndCreateESIndex.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/cluster.json")));
        Map clusterMap = (Map)new ObjectMapper().readValue(clusterJson, Map.class);
        String ip = ((String)clusterMap.get(cluster)).split(",")[0];
        String url = "http://%s:9200/%s_%s";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            delete = new HttpDelete(String.format("http://%s:9200/%s_%s", ip, index, "object"));
            response2 = client.execute((HttpUriRequest)delete);
            log.info("deleting Index SUMMARY");
            log.info(STATUS_CODE_TEXT, (Object)response2.getStatusLine());
        }
        client = HttpClients.createDefault();
        var9_9 = null;
        try {
            delete = new HttpDelete(String.format("http://%s:9200/%s_%s", ip, index, "scholix"));
            response2 = client.execute((HttpUriRequest)delete);
            log.info("deleting Index SCHOLIX");
            log.info(STATUS_CODE_TEXT, (Object)response2.getStatusLine());
        }
        catch (Throwable delete2) {
            var9_9 = delete2;
            throw delete2;
        }
        finally {
            if (client != null) {
                if (var9_9 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable delete2) {
                        var9_9.addSuppressed(delete2);
                    }
                } else {
                    client.close();
                }
            }
        }
        log.info("Sleeping 60 seconds to avoid to lost the creation of index request");
        Thread.sleep(60000L);
        client = HttpClients.createDefault();
        var9_9 = null;
        try {
            String summaryConf = IOUtils.toString((InputStream)Objects.requireNonNull(DropAndCreateESIndex.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/summary_index.json")));
            put = new HttpPut(String.format("http://%s:9200/%s_%s", ip, index, "object"));
            entity = new StringEntity(summaryConf);
            put.setEntity((HttpEntity)entity);
            put.setHeader("Accept", APPLICATION_JSON);
            put.setHeader("Content-type", APPLICATION_JSON);
            log.info("creating First Index SUMMARY");
            response = client.execute((HttpUriRequest)put);
            log.info(STATUS_CODE_TEXT, (Object)response.getStatusLine());
        }
        catch (Throwable summaryConf) {
            var9_9 = summaryConf;
            throw summaryConf;
        }
        finally {
            if (client != null) {
                if (var9_9 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable summaryConf) {
                        var9_9.addSuppressed(summaryConf);
                    }
                } else {
                    client.close();
                }
            }
        }
        client = HttpClients.createDefault();
        var9_9 = null;
        try {
            String scholixConf = IOUtils.toString((InputStream)Objects.requireNonNull(DropAndCreateESIndex.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/scholix_index.json")));
            log.info("creating Index SCHOLIX");
            put = new HttpPut(String.format("http://%s:9200/%s_%s", ip, index, "scholix"));
            entity = new StringEntity(scholixConf);
            put.setEntity((HttpEntity)entity);
            put.setHeader("Accept", APPLICATION_JSON);
            put.setHeader("Content-type", APPLICATION_JSON);
            response = client.execute((HttpUriRequest)put);
            log.info(STATUS_CODE_TEXT, (Object)response.getStatusLine());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var9_9 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }
}

