/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.model;

import com.cloudera.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import eu.dnetlib.dhp.schema.solr.Funding;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ProvisionModelSupportTest {
    @Mock
    private ISLookUpService isLookUpService;
    private VocabularyGroup vocabularies;

    @BeforeEach
    void beforeEach() throws IOException, ISLookUpException {
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(this.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(this.synonyms());
        this.vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
    }

    @Test
    void testMapFunding() throws JsonProcessingException {
        ArrayList fTrees = Lists.newArrayList((Object[])new String[]{"<fundingtree><funder><id>fct_________::FCT</id><shortname>FCT</shortname><name>Funda\u00e7\u00e3o para a Ci\u00eancia e a Tecnologia, I.P.</name><jurisdiction>PT</jurisdiction></funder><funding_level_0><id>fct_________::FCT::Projetos de IC&amp;DT Portugal \u00cdndia</id><description>Projetos de IC&amp;DT Portugal \u00cdndia</description><name>Projetos de IC&amp;DT Portugal \u00cdndia</name><parent/><class>fct:program</class></funding_level_0></fundingtree>"});
        Funding funding = ProvisionModelSupport.mapFunding((List)fTrees, (VocabularyGroup)this.vocabularies);
        Assertions.assertNotNull((Object)funding);
        ObjectMapper objectMapper = new ObjectMapper();
        System.out.println(objectMapper.writeValueAsString((Object)funding));
        Assertions.assertEquals((Object)"fct_________::FCT", (Object)funding.getFunder().getId());
        Assertions.assertEquals((Object)"fct_________::FCT::Projetos de IC&DT Portugal \u00cdndia", (Object)funding.getLevel0().getId());
    }

    private List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/provision/model/terms.txt")), (Charset)Charset.defaultCharset());
    }

    private List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/provision/model/synonyms.txt")), (Charset)Charset.defaultCharset());
    }
}

