/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.solr.common.SolrInputDocument;

public class StreamingInputDocumentFactory
implements Serializable {
    private static final String INDEX_FIELD_PREFIX = "__";
    private static final String RESULT = "result";
    public static final String INDEX_RESULT = "__result";
    public static final String INDEX_JSON_RESULT = "__json";
    private static final String INDEX_RECORD_ID = "__indexrecordidentifier";
    private static final String DEFAULTDNETRESULT = "dnetResult";
    private static final String TARGETFIELDS = "targetFields";
    private static final String INDEX_RECORD_ID_ELEMENT = "indexRecordIdentifier";
    private static final String ROOT_ELEMENT = "indexRecord";
    private static final int MAX_FIELD_LENGTH = 25000;
    private final ThreadLocal<XMLInputFactory> inputFactory = ThreadLocal.withInitial(XMLInputFactory::newInstance);
    private final ThreadLocal<XMLOutputFactory> outputFactory = ThreadLocal.withInitial(XMLOutputFactory::newInstance);
    private final ThreadLocal<XMLEventFactory> eventFactory = ThreadLocal.withInitial(XMLEventFactory::newInstance);
    private String resultName = "dnetResult";

    public StreamingInputDocumentFactory() {
        this(DEFAULTDNETRESULT);
    }

    public StreamingInputDocumentFactory(String resultName) {
        this.resultName = resultName;
    }

    public SolrInputDocument parseDocument(String xml) {
        return this.parseDocument(xml, "");
    }

    public SolrInputDocument parseDocument(String xml, String json) {
        StringWriter results = new StringWriter();
        LinkedList nsList = Lists.newLinkedList();
        try {
            XMLEventReader parser = this.inputFactory.get().createXMLEventReader(new StringReader(xml));
            SolrInputDocument indexDocument = new SolrInputDocument(new HashMap());
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if (ROOT_ELEMENT.equals(localName)) {
                    nsList.addAll(this.getNamespaces(event));
                    continue;
                }
                if (INDEX_RECORD_ID_ELEMENT.equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    String recordId = this.getText(text);
                    indexDocument.addField(INDEX_RECORD_ID, (Object)recordId);
                    continue;
                }
                if (TARGETFIELDS.equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!this.resultName.equals(localName)) continue;
                this.copyResult(indexDocument, json, results, parser, nsList, this.resultName);
            }
            if (!indexDocument.containsKey((Object)INDEX_RECORD_ID)) {
                throw new IllegalStateException("cannot extract record ID from: " + xml);
            }
            SolrInputDocument solrInputDocument = indexDocument;
            return solrInputDocument;
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.inputFactory.remove();
        }
    }

    private List<Namespace> getNamespaces(XMLEvent event) {
        LinkedList res = Lists.newLinkedList();
        Iterator<Namespace> nsIter = event.asStartElement().getNamespaces();
        while (nsIter.hasNext()) {
            Namespace ns = nsIter.next();
            res.add(ns);
        }
        return res;
    }

    protected void parseTargetFields(SolrInputDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals(TARGETFIELDS))) {
            if (!targetEvent.isStartElement()) continue;
            String fieldName = targetEvent.asStartElement().getName().getLocalPart();
            XMLEvent text = parser.nextEvent();
            String data = this.getText(text);
            if (!Objects.nonNull(data)) continue;
            this.addField(indexDocument, fieldName, data);
            hasFields = true;
        }
        if (!hasFields) {
            indexDocument.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResult(SolrInputDocument indexDocument, String json, StringWriter results, XMLEventReader parser, List<Namespace> nsList, String dnetResult) throws XMLStreamException {
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        XMLEventFactory xmlEventFactory = this.eventFactory.get();
        try {
            for (Namespace ns : nsList) {
                xmlEventFactory.createNamespace(ns.getPrefix(), ns.getNamespaceURI());
            }
            StartElement newRecord = xmlEventFactory.createStartElement("", null, RESULT, null, nsList.iterator());
            writer.add(newRecord);
            while (parser.hasNext()) {
                XMLEvent resultEvent = parser.nextEvent();
                if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(dnetResult)) {
                    writer.add(xmlEventFactory.createEndElement("", null, RESULT));
                    break;
                }
                writer.add(resultEvent);
            }
            writer.close();
            indexDocument.addField(INDEX_RESULT, (Object)results.toString());
            indexDocument.addField(INDEX_JSON_RESULT, (Object)json);
        }
        finally {
            this.outputFactory.remove();
            this.eventFactory.remove();
        }
    }

    private final void addField(SolrInputDocument indexDocument, String field, String value) {
        String cleaned = value.trim();
        if (!cleaned.isEmpty()) {
            indexDocument.addField(field.toLowerCase(), (Object)cleaned);
        }
    }

    protected final String getText(XMLEvent text) {
        if (text.isEndElement()) {
            return "";
        }
        String data = text.asCharacters().getData();
        if (data != null && data.length() > 25000) {
            return data.substring(0, 25000);
        }
        return data;
    }
}

