/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.oaipmh;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.oaipmh.OaiRecordWrapper;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.model.TupleWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrishOaiExporterJob {
    private static final Logger log = LoggerFactory.getLogger(IrishOaiExporterJob.class);
    protected static final int NUM_CONNECTIONS = 20;
    public static final String TMP_OAI_TABLE = "temp_oai_data";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IrishOaiExporterJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/oaipmh/input_params_irish_oai_exporter.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        String dbUrl = parser.get("dbUrl");
        String dbUser = parser.get("dbUser");
        String dbPwd = parser.get("dbPwd");
        int numConnections = Optional.ofNullable(parser.get("numConnections")).map(Integer::valueOf).orElse(20);
        log.info("inputPath:     '{}'", (Object)inputPath);
        log.info("dbUrl:         '{}'", (Object)dbUrl);
        log.info("dbUser:        '{}'", (Object)dbUser);
        log.info("dbPwd:         '{}'", (Object)"xxx");
        log.info("numPartitions: '{}'", (Object)numConnections);
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", dbUser);
        connectionProperties.put("password", dbPwd);
        SparkConf conf = new SparkConf();
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        Encoder encoderTuple = Encoders.bean(TupleWrapper.class);
        Encoder encoderOaiRecord = Encoders.bean(OaiRecordWrapper.class);
        String date = LocalDateTime.now().toString();
        log.info("Creating temporary table...");
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            Dataset docs = spark.read().schema(encoderTuple.schema()).json(inputPath).as(encoderTuple).map(TupleWrapper::getXml, Encoders.STRING()).map((MapFunction & Serializable)r -> IrishOaiExporterJob.asIrishOaiResult(r, date), encoderOaiRecord).filter((FilterFunction & Serializable)obj -> obj != null && StringUtils.isNotBlank((CharSequence)obj.getId()));
            docs.repartition(numConnections).write().mode(SaveMode.Overwrite).jdbc(dbUrl, TMP_OAI_TABLE, connectionProperties);
        });
        log.info("Temporary table created.");
        log.info("Updating OAI records...");
        try (Connection con = DriverManager.getConnection(dbUrl, dbUser, dbPwd);
             Statement st = con.createStatement();){
            String query = IOUtils.toString((InputStream)IrishOaiExporterJob.class.getResourceAsStream("oai-finalize.sql"));
            st.execute(query);
        }
        log.info("DONE.");
    }

    protected static OaiRecordWrapper asIrishOaiResult(String xml, String date) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            OaiRecordWrapper r = new OaiRecordWrapper();
            if (IrishOaiExporterJob.isValid(doc)) {
                r.setId(doc.valueOf("//*[local-name()='objIdentifier']").trim());
                r.setBody(IrishOaiExporterJob.gzip(doc.selectSingleNode("//*[local-name()='entity']").asXML()));
                r.setDate(date);
                r.setSets(new ArrayList<String>());
            }
            return r;
        }
        catch (Exception e) {
            log.error("Error parsing record: " + xml, (Throwable)e);
            throw new RuntimeException("Error parsing record: " + xml, e);
        }
    }

    protected static boolean isValid(Document doc) {
        Node n = doc.selectSingleNode("//*[local-name()='entity']/*[local-name()='result']");
        if (n != null) {
            for (Object o : n.selectNodes(".//*[local-name()='datainfo']/*[local-name()='deletedbyinference']")) {
                if (!"true".equals(((Node)o).getText().trim())) continue;
                return false;
            }
            for (Object o : n.selectNodes("./*[local-name()='country']")) {
                if (!"IE".equals(((Node)o).valueOf("@classid").trim())) continue;
                return true;
            }
            for (Object o : n.selectNodes(".//*[local-name()='rel']")) {
                String relType = ((Node)o).valueOf("./*[local-name() = 'to']/@type").trim();
                String relCountry = ((Node)o).valueOf("./*[local-name() = 'country']/@classid").trim();
                if (!"organization".equals(relType) || !"IE".equals(relCountry)) continue;
                return true;
            }
        }
        return false;
    }

    protected static byte[] gzip(String str) {
        byte[] byArray;
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (GZIPOutputStream gzip = new GZIPOutputStream(baos);){
                IOUtils.write((byte[])str.getBytes(Charset.defaultCharset()), (OutputStream)gzip);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("error in gzip", e);
            }
        }
        baos.close();
        return byArray;
    }
}

