/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.incremental;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class SparkResolveRelationById$ {
    public static final SparkResolveRelationById$ MODULE$;

    static {
        new SparkResolveRelationById$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/incremental/resolution/resolve_relationsbyid_params.json")));
        parser.parseArgument(args);
        conf.set("hive.metastore.uris", parser.get("hiveMetastoreUris"));
        String graphBasePath = parser.get("graphBasePath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"graphBasePath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graphBasePath})));
        String relationPath = parser.get("relationPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"relationPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relationPath})));
        String targetPath = parser.get("targetGraph");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetGraph  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        String hiveDbName = parser.get("hiveDbName");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hiveDbName  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hiveDbName})));
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).enableHiveSupport().appName(this.getClass().getSimpleName()).getOrCreate();
        Encoder relEncoder = Encoders$.MODULE$.bean(Relation.class);
        Dataset mergedrels = spark.table(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hiveDbName}))).where("relclass = 'merges'").selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source as dedupId", "target as mergedId"}));
        spark.read().schema(Encoders$.MODULE$.bean(Relation.class).schema()).json(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graphBasePath}))).as(relEncoder).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Relation apply(Relation r) {
                return SparkResolveRelationById$.MODULE$.eu$dnetlib$dhp$incremental$SparkResolveRelationById$$resolveRelations(r);
            }
        }, relEncoder).join(mergedrels, functions$.MODULE$.col("source").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("source", functions$.MODULE$.expr("coalesce(dedupId, source)")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).join(mergedrels, functions$.MODULE$.col("target").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("target", functions$.MODULE$.expr("coalesce(dedupId, target)")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
    }

    public Relation eu$dnetlib$dhp$incremental$SparkResolveRelationById$$resolveRelations(Relation r) {
        if (r.getSource().startsWith("unresolved::")) {
            r.setSource(this.resolvePid(r.getSource().substring(12)));
        }
        if (r.getTarget().startsWith("unresolved::")) {
            r.setTarget(this.resolvePid(r.getTarget().substring(12)));
        }
        return r;
    }

    private String resolvePid(String str) {
        String[] parts = str.split("::");
        String id = parts[0];
        String string = (String)Predef$.MODULE$.refArrayOps((Object[])parts).last();
        String string2 = "arxiv".equals(string) ? "arXiv" : (String)Predef$.MODULE$.refArrayOps((Object[])parts).last();
        String scheme = string2;
        return IdentifierFactory.idFromPid((String)"50", (String)scheme, (String)id, (boolean)true);
    }

    private SparkResolveRelationById$() {
        MODULE$ = this;
    }
}

