/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.incremental;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class SparkResolveRelationById$ {
    public static final SparkResolveRelationById$ MODULE$ = new SparkResolveRelationById$();

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/incremental/resolution/resolve_relationsbyid_params.json")));
        parser.parseArgument(args);
        conf.set("hive.metastore.uris", parser.get("hiveMetastoreUris"));
        String graphBasePath = parser.get("graphBasePath");
        log.info("graphBasePath  -> " + graphBasePath);
        String relationPath = parser.get("relationPath");
        log.info("relationPath  -> " + relationPath);
        String targetPath = parser.get("targetGraph");
        log.info("targetGraph  -> " + targetPath);
        String hiveDbName = parser.get("hiveDbName");
        log.info("hiveDbName  -> " + hiveDbName);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).enableHiveSupport().appName(this.getClass().getSimpleName()).getOrCreate();
        Encoder relEncoder = Encoders$.MODULE$.bean(Relation.class);
        Dataset mergedrels = spark.table(hiveDbName + ".relation").where("relclass = 'merges'").selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source as dedupId", "target as mergedId"}));
        spark.read().schema(Encoders$.MODULE$.bean(Relation.class).schema()).json(graphBasePath + "/relation").as(relEncoder).map((Function1 & Serializable)r -> MODULE$.resolveRelations((Relation)r), relEncoder).join(mergedrels, functions$.MODULE$.col("source").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("source", functions$.MODULE$.expr("coalesce(dedupId, source)")).drop((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).join(mergedrels, functions$.MODULE$.col("target").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("target", functions$.MODULE$.expr("coalesce(dedupId, target)")).drop((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(targetPath + "/relation");
    }

    private Relation resolveRelations(Relation r) {
        block1: {
            if (r.getSource().startsWith("unresolved::")) {
                r.setSource(this.resolvePid(r.getSource().substring(12)));
            }
            if (!r.getTarget().startsWith("unresolved::")) break block1;
            r.setTarget(this.resolvePid(r.getTarget().substring(12)));
        }
        return r;
    }

    private String resolvePid(String str) {
        String string;
        String id;
        block3: {
            String[] parts = str.split("::");
            id = parts[0];
            String string2 = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])parts));
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 93096404: {
                    if (!"arxiv".equals(string2)) break;
                    string = "arXiv";
                    break block3;
                }
            }
            string = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])parts));
        }
        String scheme = string;
        return IdentifierFactory.idFromPid((String)"50", (String)scheme, (String)id, (boolean)true);
    }

    private SparkResolveRelationById$() {
    }
}

