/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.utils;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.ZeppelinClient;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.HasStatus;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.ListResponse;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.Note;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.Paragraph;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.SimpleResponse;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.StringResponse;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ZeppelinClient {
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.login}")
    private String zeppelinLogin;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.password}")
    private String zeppelinPassword;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.base-url}")
    private String zeppelinBaseUrl;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.name-prefix}")
    private String zeppelinNamePrefix;
    private static final Log log = LogFactory.getLog(ZeppelinClient.class);
    private static final Map<String, List<String>> DEFAULT_RIGHTS = new LinkedHashMap();
    private static final Integer MAX_NUMBER_OF_MD_NOTES = 2;
    private String jsessionid;

    @PostConstruct
    public void init() {
        DEFAULT_RIGHTS.put("owners", Arrays.asList(this.zeppelinLogin));
        DEFAULT_RIGHTS.put("readers", new ArrayList());
        DEFAULT_RIGHTS.put("runners", new ArrayList());
        DEFAULT_RIGHTS.put("writers", new ArrayList());
    }

    public String zeppelinNote(String note, MDStoreWithInfo mdstore, String currentVersionPath) throws MDStoreManagerException {
        if (this.notConfigured()) {
            throw new MDStoreManagerException("A zeppelin property is empty");
        }
        String newName = StringUtils.join(Arrays.asList(this.zeppelinNamePrefix, "notes", mdstore.getDatasourceName().replaceAll("/", "-"), mdstore.getApiId().replaceAll("/", "-"), note.replaceAll("/", "-"), mdstore.getCurrentVersion().replaceAll("/", "-")), (String)"/");
        List notes = this.listNotes();
        Optional<String> oldNoteId = notes.stream().filter(Objects::nonNull).filter(map -> newName.equals(map.get("name"))).map(map -> (String)map.get("id")).findFirst();
        if (oldNoteId.isPresent()) {
            log.debug((Object)("Returning existing note: " + oldNoteId.get()));
            return this.zeppelinBaseUrl + "/#/notebook/" + oldNoteId.get();
        }
        String templateName = this.zeppelinNamePrefix + "/templates/" + note;
        String templateNoteId = notes.stream().filter(map -> ((String)map.get("name")).equals(templateName)).map(map -> (String)map.get("id")).findFirst().orElseThrow(() -> new MDStoreManagerException("Template Note not found: " + templateName));
        String newId = this.cloneNote(templateNoteId, newName, mdstore, currentVersionPath);
        return this.zeppelinBaseUrl + "/#/notebook/" + newId;
    }

    public List<String> listTemplates() {
        String prefix = this.zeppelinNamePrefix + "/templates/";
        if (this.notConfigured()) {
            return new ArrayList<String>();
        }
        return this.listNotes().stream().map(map -> (String)map.get("name")).filter(s -> s.startsWith(prefix)).map(s -> StringUtils.substringAfter((String)s, (String)prefix)).sorted().collect(Collectors.toList());
    }

    private List<Map<String, String>> listNotes() {
        return ((ListResponse)this.callApi(HttpMethod.GET, "notebook", ListResponse.class, null)).getBody();
    }

    private String cloneNote(String noteId, String newName, MDStoreWithInfo mdstore, String currentVersionPath) throws MDStoreManagerException {
        String newId = ((StringResponse)this.callApi(HttpMethod.POST, "notebook/" + noteId, StringResponse.class, (Object)new Note(newName))).getBody();
        ((StringResponse)this.callApi(HttpMethod.POST, "notebook/" + newId + "/paragraph", StringResponse.class, (Object)this.confParagraph(mdstore, currentVersionPath))).getBody();
        this.callApi(HttpMethod.PUT, "notebook/" + newId + "/permissions", SimpleResponse.class, (Object)DEFAULT_RIGHTS);
        log.info((Object)("New note created, id: " + newId + ", name: " + newName));
        return newId;
    }

    private Paragraph confParagraph(MDStoreWithInfo mdstore, String currentVersionPath) throws MDStoreManagerException {
        try {
            String code = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/zeppelin/paragraph_conf.tmpl"), (Charset)StandardCharsets.UTF_8).replaceAll("__DS_NAME__", StringEscapeUtils.escapeJava((String)mdstore.getDatasourceName())).replaceAll("__DS_ID__", StringEscapeUtils.escapeJava((String)mdstore.getDatasourceId())).replaceAll("__API_ID__", StringEscapeUtils.escapeJava((String)mdstore.getApiId())).replaceAll("__MDSTORE_ID__", mdstore.getId()).replaceAll("__VERSION__", mdstore.getCurrentVersion()).replaceAll("__PATH__", currentVersionPath);
            return new Paragraph("Configuration", code, 0);
        }
        catch (IOException e) {
            log.error((Object)"Error preparing configuration paragraph", (Throwable)e);
            throw new MDStoreManagerException("Error preparing configuration paragraph", (Throwable)e);
        }
    }

    @Scheduled(fixedRate=43200000L)
    public void cleanExpiredNotes() {
        if (this.notConfigured()) {
            return;
        }
        try {
            List notes = this.listNotes().stream().filter(n -> ((String)n.get("name")).startsWith(this.zeppelinNamePrefix + "/notes/")).sorted((o1, o2) -> StringUtils.compare((String)((String)o2.get("name")), (String)((String)o1.get("name")))).collect(Collectors.toList());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Map n2 : notes) {
                String firstPart = StringUtils.substringBeforeLast((String)((String)n2.get("name")), (String)"-");
                if (!map.containsKey(firstPart)) {
                    log.debug((Object)("Evaluating note " + (String)n2.get("name") + " for deletion: CONFIRMED"));
                    map.put(firstPart, 1);
                    continue;
                }
                if ((Integer)map.get(firstPart) < MAX_NUMBER_OF_MD_NOTES) {
                    log.debug((Object)("Evaluating note " + (String)n2.get("name") + " for deletion: CONFIRMED"));
                    map.put(firstPart, (Integer)map.get(firstPart) + 1);
                    continue;
                }
                log.debug((Object)("Evaluating note " + (String)n2.get("name") + " for deletion: TO_DELETE"));
                this.callApi(HttpMethod.DELETE, "notebook/" + (String)n2.get("id"), SimpleResponse.class, null);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error cleaning expired notes", (Throwable)e);
        }
    }

    private <T extends HasStatus> T callApi(HttpMethod method, String api, Class<T> resClazz, Object objRequest) {
        block5: {
            if (this.jsessionid == null) {
                HasStatus res = this.findNewJsessionId(method, api, resClazz, objRequest);
                if (res != null) {
                    return (T)res;
                }
            } else {
                try {
                    return (T)this.callApi(method, api, resClazz, objRequest, this.jsessionid);
                }
                catch (MDStoreManagerException e) {
                    HasStatus res = this.findNewJsessionId(method, api, resClazz, objRequest);
                    if (res == null) break block5;
                    return (T)res;
                }
            }
        }
        throw new RuntimeException("All attempted calls are failed");
    }

    private <T extends HasStatus> T callApi(HttpMethod method, String api, Class<T> resClazz, Object objRequest, String jsessionid) throws MDStoreManagerException {
        String url = String.format("%s/api/%s;JSESSIONID=%s", this.zeppelinBaseUrl, api, jsessionid);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity res = null;
        switch (1.$SwitchMap$org$springframework$http$HttpMethod[method.ordinal()]) {
            case 1: {
                log.debug((Object)("Performing GET: " + url));
                res = restTemplate.getForEntity(url, resClazz, new Object[0]);
                break;
            }
            case 2: {
                log.debug((Object)("Performing POST: " + url));
                res = restTemplate.postForEntity(url, objRequest, resClazz, new Object[0]);
                break;
            }
            case 3: {
                log.debug((Object)("Performing PUT: " + url));
                restTemplate.put(url, objRequest, new Object[0]);
                break;
            }
            case 4: {
                log.debug((Object)("Performing DELETE: " + url));
                restTemplate.delete(url, new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported method: " + method);
            }
        }
        if (method == HttpMethod.PUT || method == HttpMethod.DELETE) {
            return (T)new SimpleResponse("OK");
        }
        if (res == null) {
            log.error((Object)"NULL response from the API");
            throw new MDStoreManagerException("NULL response from the API");
        }
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API failed with HTTP error: " + res));
            throw new MDStoreManagerException("Zeppelin API failed with HTTP error: " + res);
        }
        if (res.getBody() == null) {
            log.error((Object)"Zeppelin API returned a null response");
            throw new MDStoreManagerException("Zeppelin API returned a null response");
        }
        if (!((HasStatus)res.getBody()).getStatus().equals("OK")) {
            log.error((Object)("Zeppelin API Operation failed: " + res.getBody()));
            throw new MDStoreManagerException("Registration of zeppelin note failed: " + res.getBody());
        }
        return (T)((HasStatus)res.getBody());
    }

    private <T extends HasStatus> T findNewJsessionId(HttpMethod method, String api, Class<T> resClazz, Object objRequest) {
        for (String id : this.obtainJsessionIDs()) {
            try {
                HasStatus res = this.callApi(method, api, resClazz, objRequest, id);
                this.setJsessionid(id);
                return (T)res;
            }
            catch (MDStoreManagerException e) {
                log.warn((Object)("Skipping invalid jsessionid: " + id));
            }
        }
        return null;
    }

    private Set<String> obtainJsessionIDs() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"userName", (Object)this.zeppelinLogin);
        map.add((Object)"password", (Object)this.zeppelinPassword);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        String url = this.zeppelinBaseUrl + "/api/login";
        ResponseEntity res = new RestTemplate().postForEntity(url, (Object)request, Object.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API: login failed with HTTP error: " + res));
            throw new RuntimeException("Zeppelin API: login failed with HTTP error: " + res);
        }
        if (!res.getHeaders().containsKey((Object)"Set-Cookie")) {
            log.error((Object)"Zeppelin API: login failed (missing SET_COOKIE header)");
            throw new RuntimeException("Zeppelin API: login failed (missing SET_COOKIE header)");
        }
        return res.getHeaders().get((Object)"Set-Cookie").stream().map(s -> s.split(";")).flatMap(Arrays::stream).map(String::trim).filter(s -> s.startsWith("JSESSIONID=")).map(s -> StringUtils.removeStart((String)s, (String)"JSESSIONID=")).filter(s -> !s.equalsIgnoreCase("deleteMe")).collect(Collectors.toSet());
    }

    public String getJsessionid() {
        return this.jsessionid;
    }

    public void setJsessionid(String jsessionid) {
        this.jsessionid = jsessionid;
    }

    private boolean notConfigured() {
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.zeppelinBaseUrl, this.zeppelinLogin, this.zeppelinPassword, this.zeppelinNamePrefix});
    }
}

