/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.mdstore;

import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.dhp.schema.mdstore.ValidationType;
import eu.dnetlib.validator2.validation.StandardValidationResult;
import java.io.Serializable;
import java.util.Map;

public class MetadataRecord
implements Serializable {
    private String id;
    private String originalId;
    private String encoding;
    private Provenance provenance;
    private String body;
    private Map<ValidationType, StandardValidationResult> validationResults;
    private Long dateOfCollection;
    private Long dateOfTransformation;

    public MetadataRecord() {
    }

    public MetadataRecord(String originalId, String encoding, Provenance provenance, String body, Long dateOfCollection) {
        this(originalId, encoding, provenance, body, null, dateOfCollection);
    }

    public MetadataRecord(String originalId, String encoding, Provenance provenance, String body, Map<ValidationType, StandardValidationResult> validationResults, Long dateOfCollection) {
        this.originalId = originalId;
        this.encoding = encoding;
        this.provenance = provenance;
        this.body = body;
        this.validationResults = validationResults;
        this.dateOfCollection = dateOfCollection;
        this.id = ModelSupport.generateIdentifier(originalId, this.provenance.getNsPrefix());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<ValidationType, StandardValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public void setValidationResults(Map<ValidationType, StandardValidationResult> validationResults) {
        this.validationResults = validationResults;
    }

    public Long getDateOfCollection() {
        return this.dateOfCollection;
    }

    public void setDateOfCollection(Long dateOfCollection) {
        this.dateOfCollection = dateOfCollection;
    }

    public Long getDateOfTransformation() {
        return this.dateOfTransformation;
    }

    public void setDateOfTransformation(Long dateOfTransformation) {
        this.dateOfTransformation = dateOfTransformation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataRecord)) {
            return false;
        }
        return ((MetadataRecord)o).getId().equalsIgnoreCase(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

