/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.mdstore;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="mdstores")
public class MDStore
implements Serializable {
    private static final long serialVersionUID = 3160530489149700055L;
    @Id
    @Column(name="id")
    private String id;
    @Column(name="format")
    private String format;
    @Column(name="layout")
    private String layout;
    @Column(name="interpretation")
    private String interpretation;
    @Column(name="datasource_name")
    private String datasourceName;
    @Column(name="datasource_id")
    private String datasourceId;
    @Column(name="api_id")
    private String apiId;
    @Column(name="hdfs_path")
    private String hdfsPath;
    @Column(name="creation_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getHdfsPath() {
        return this.hdfsPath;
    }

    public void setHdfsPath(String hdfsPath) {
        this.hdfsPath = hdfsPath;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public static MDStore newInstance(String format, String layout, String interpretation, String hdfsBasePath) {
        return MDStore.newInstance(format, layout, interpretation, null, null, null, hdfsBasePath);
    }

    public static MDStore newInstance(String format, String layout, String interpretation, String dsName, String dsId, String apiId, String hdfsBasePath) {
        String mdId = "md-" + UUID.randomUUID();
        MDStore md = new MDStore();
        md.setId(mdId);
        md.setFormat(format);
        md.setLayout(layout);
        md.setInterpretation(interpretation);
        md.setCreationDate(new Date());
        md.setDatasourceName(dsName);
        md.setDatasourceId(dsId);
        md.setApiId(apiId);
        md.setHdfsPath(String.format("%s/%s", hdfsBasePath, mdId));
        return md;
    }

    public String toString() {
        return String.format("MDStore [id=%s, format=%s, layout=%s, interpretation=%s, datasourceName=%s, datasourceId=%s, apiId=%s, hdfsPath=%s, creationDate=%s]", this.id, this.format, this.layout, this.interpretation, this.datasourceName, this.datasourceId, this.apiId, this.hdfsPath, this.creationDate);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MDStore)) {
            return false;
        }
        MDStore other = (MDStore)obj;
        return Objects.equals(this.id, other.id);
    }
}

