/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.scholix;

import eu.dnetlib.dhp.schema.sx.scholix.ScholixComparator;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Scholix
implements Serializable,
Comparable<Scholix> {
    private String publicationDate;
    private List<ScholixEntityId> publisher;
    private List<ScholixEntityId> linkprovider;
    private ScholixRelationship relationship;
    private ScholixResource source;
    private ScholixResource target;
    private String identifier;

    public String getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
    }

    public List<ScholixEntityId> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(List<ScholixEntityId> publisher) {
        this.publisher = publisher;
    }

    public List<ScholixEntityId> getLinkprovider() {
        return this.linkprovider;
    }

    public void setLinkprovider(List<ScholixEntityId> linkprovider) {
        this.linkprovider = linkprovider;
    }

    public ScholixRelationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ScholixRelationship relationship) {
        this.relationship = relationship;
    }

    public ScholixResource getSource() {
        return this.source;
    }

    public void setSource(ScholixResource source) {
        this.source = source;
    }

    public ScholixResource getTarget() {
        return this.target;
    }

    public void setTarget(ScholixResource target) {
        this.target = target;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scholix)) {
            return false;
        }
        Scholix scholix = (Scholix)o;
        return this.compareTo(scholix) == 0;
    }

    public int hashCode() {
        int publisherHash = this.publisher == null ? 0 : this.publisher.stream().sorted().collect(Collectors.toList()).hashCode();
        int linkProviderHash = this.linkprovider == null ? 0 : this.linkprovider.stream().sorted().collect(Collectors.toList()).hashCode();
        return Objects.hash(ScholixComparator.normalizeString(this.publicationDate), publisherHash, linkProviderHash, this.relationship, this.source, this.target, ScholixComparator.normalizeIdnetifier(this.identifier));
    }

    @Override
    public int compareTo(Scholix other) {
        if (other == null) {
            return -1;
        }
        int publicationDateCompare = StringUtils.compare((String)this.publicationDate, (String)other.getPublicationDate());
        if (publicationDateCompare != 0) {
            return publicationDateCompare;
        }
        int linkPublisherComparator = ScholixComparator.compareList(this.publisher, other.getPublisher());
        if (linkPublisherComparator != 0) {
            return linkPublisherComparator;
        }
        int linkProviderComparator = ScholixComparator.compareList(this.linkprovider, other.getLinkprovider());
        if (linkProviderComparator != 0) {
            return linkProviderComparator;
        }
        int relsComparator = ScholixComparator.compareObjects(this.relationship, other.getRelationship());
        if (relsComparator != 0) {
            return relsComparator;
        }
        int sourceComparator = ScholixComparator.compareObjects(this.source, other.getSource());
        if (sourceComparator != 0) {
            return sourceComparator;
        }
        return ScholixComparator.compareObjects(this.target, other.getTarget());
    }
}

