/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v1.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;

public class ScholixCreator {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="identifier")
    private List<ScholixIdentifier> identifier = null;

    public ScholixCreator name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The name of the Object Creator")
    public String getName() {
        return this.name;
    }

    public ScholixCreator setName(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A unique string that identifies the Object Creator")
    public List<ScholixIdentifier> getIdentifier() {
        return this.identifier;
    }

    public ScholixCreator setIdentifier(List<ScholixIdentifier> identifier) {
        this.identifier = identifier;
        return this;
    }

    public static ScholixCreator fromScholixEntityId(ScholixEntityId provider) {
        if (provider == null) {
            return null;
        }
        ScholixCreator instance = new ScholixCreator().setName(provider.getName());
        if (provider.getIdentifiers() != null && provider.getIdentifiers().size() > 0) {
            instance.setIdentifier(provider.getIdentifiers().stream().map(i -> new ScholixIdentifier().setIdentifier(i.getIdentifier()).setSchema(i.getSchema())).collect(Collectors.toList()));
        }
        return instance;
    }
}

