/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixIdentifierType;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;

public class ScholixCreatorType {
    @NotBlank
    @JsonProperty(value="name")
    private String name = null;
    @NotBlank
    @JsonProperty(value="identifier")
    private List<ScholixIdentifierType> identifier = new ArrayList<ScholixIdentifierType>();

    @Schema(description="A List of unique string that identifies the creator")
    public List<ScholixIdentifierType> getIdentifier() {
        return this.identifier;
    }

    public ScholixCreatorType setIdentifier(List<ScholixIdentifierType> identifier) {
        this.identifier = identifier;
        return this;
    }

    @Schema(description="The name of the Object Creator")
    public String getName() {
        return this.name;
    }

    public ScholixCreatorType setName(String name) {
        this.name = name;
        return this;
    }

    public static ScholixCreatorType fromScholixEntityId(ScholixEntityId inputCreator) {
        if (inputCreator == null) {
            return null;
        }
        ScholixCreatorType instance = new ScholixCreatorType().setName(inputCreator.getName());
        if (inputCreator.getIdentifiers() != null && inputCreator.getIdentifiers().size() > 0) {
            instance.setIdentifier(inputCreator.getIdentifiers().stream().map(i -> new ScholixIdentifierType().setId(i.getIdentifier()).setIdScheme(i.getSchema())).collect(Collectors.toList()));
        }
        return instance;
    }
}

