/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v2.RelationshipType;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixLinkProviderType;
import eu.dnetlib.dhp.schema.sx.api.model.v3.ScholixItemType;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;

public class ScholixType
implements Serializable {
    @NotBlank
    @JsonProperty(value="RelationshipType")
    private RelationshipType relationshipType;
    @NotBlank
    @JsonProperty(value="source")
    private ScholixItemType source;
    @NotBlank
    @JsonProperty(value="target")
    private ScholixItemType target;
    @JsonProperty(value="HarvestDate")
    private String harvestDate;
    @JsonProperty(value="LicenseURL")
    private String licenseURL;
    @JsonProperty(value="LinkProvider")
    private List<ScholixLinkProviderType> linkProvider;
    @JsonProperty(value="LinkPublicationDate")
    private String linkPublicationDate;

    @Schema(description="The nature of the relationship between the source object and target object in this Link Information Package")
    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Schema(description="Root element relative to all properties describing the link\u2019s source object")
    public ScholixItemType getSource() {
        return this.source;
    }

    public void setSource(ScholixItemType source) {
        this.source = source;
    }

    @Schema(description="Gets Root element relative to all properties describing the link\u2019s target object")
    public ScholixItemType getTarget() {
        return this.target;
    }

    public void setTarget(ScholixItemType target) {
        this.target = target;
    }

    public String getHarvestDate() {
        return this.harvestDate;
    }

    public void setHarvestDate(String harvestDate) {
        this.harvestDate = harvestDate;
    }

    @Schema(description="The URL of the license for the Scholix Link Information Package")
    public String getLicenseURL() {
        return this.licenseURL;
    }

    public void setLicenseURL(String licenseURL) {
        this.licenseURL = licenseURL;
    }

    @Schema(description="The source(s) of this Link Information Package")
    public List<ScholixLinkProviderType> getLinkProvider() {
        return this.linkProvider;
    }

    public void setLinkProvider(List<ScholixLinkProviderType> linkProvider) {
        this.linkProvider = linkProvider;
    }

    @Schema(description="Date when this Link Information Package was first formally issued from this current Provider")
    public String getLinkPublicationDate() {
        return this.linkPublicationDate;
    }

    public void setLinkPublicationDate(String linkPublicationDate) {
        this.linkPublicationDate = linkPublicationDate;
    }

    public static ScholixType fromScholix(Scholix input) {
        ScholixType instance = new ScholixType();
        instance.setLinkPublicationDate(input.getPublicationDate());
        instance.setHarvestDate(input.getPublicationDate());
        instance.setRelationshipType(RelationshipType.fromScholixRelationship(input.getRelationship()));
        if (input.getLinkprovider() != null && input.getLinkprovider().size() > 0) {
            instance.setLinkProvider(input.getLinkprovider().stream().map(ScholixLinkProviderType::fromScholixEntityId).collect(Collectors.toList()));
        }
        instance.setSource(ScholixItemType.fromScholixResource(input.getSource()));
        instance.setTarget(ScholixItemType.fromScholixResource(input.getTarget()));
        return instance;
    }
}

