
package eu.dnetlib.dhp.schema.sx.scholix;

import java.io.Serializable;
import java.util.Objects;

public class ScholixIdentifier implements Serializable {
	private String identifier;
	private String schema;
	private String url;

	public ScholixIdentifier() {
	}

	public ScholixIdentifier(String identifier, String schema, String url) {
		this.identifier = identifier;
		this.schema = schema;
		this.url = url;
	}


	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}


	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ScholixIdentifier that = (ScholixIdentifier) o;
		return identifier.equals(that.identifier) && schema.equals(that.schema);
	}

	@Override
	public int hashCode() {
		return Objects.hash(identifier, schema);
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}
}
