/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.dump;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.imifou.jsonschema.module.addon.AddonModule;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import eu.dnetlib.dhp.schema.dump.oaf.community.CommunityResult;
import eu.dnetlib.dhp.schema.dump.oaf.graph.Datasource;
import eu.dnetlib.dhp.schema.dump.oaf.graph.GraphResult;
import eu.dnetlib.dhp.schema.dump.oaf.graph.Organization;
import eu.dnetlib.dhp.schema.dump.oaf.graph.Project;
import eu.dnetlib.dhp.schema.dump.oaf.graph.Relation;
import eu.dnetlib.dhp.schema.dump.oaf.graph.ResearchCommunity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ExecCreateSchemas {
    static final String DIRECTORY = "/eu/dnetlib/dhp/schema/oaf/dump/jsonschemas/";
    SchemaGenerator generator;

    private void init() {
        AddonModule module = new AddonModule();
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT), SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON).with((Module)module).with(Option.SCHEMA_VERSION_INDICATOR, new Option[0]).without(Option.NONPUBLIC_NONSTATIC_FIELDS_WITHOUT_GETTERS, new Option[0]);
        SchemaGeneratorConfig config = configBuilder.build();
        this.generator = new SchemaGenerator(config);
    }

    private void generate(Type targetType, String directory, String filename) throws IOException {
        ObjectNode jsonSchema = this.generator.generateSchema(targetType, new Type[0]);
        String dir = Paths.get(Paths.get(this.getClass().getResource("/").getPath(), new String[0]).toAbsolutePath() + directory, new String[0]).toString();
        if (!Files.exists(Paths.get(dir, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
        }
        if (!Files.exists(Paths.get(dir + "/" + filename, new String[0]), new LinkOption[0])) {
            Files.createFile(Paths.get(dir + "/" + filename, new String[0]), new FileAttribute[0]);
        }
        File f = new File(dir + "/" + filename);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f)));){
            writer.println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema));
        }
    }

    public static void main(String[] args) throws IOException {
        ExecCreateSchemas ecs = new ExecCreateSchemas();
        ecs.init();
        ecs.generate((Type)((Object)GraphResult.class), DIRECTORY, "result_schema.json");
        ecs.generate((Type)((Object)ResearchCommunity.class), DIRECTORY, "community_infrastructure_schema.json");
        ecs.generate((Type)((Object)Datasource.class), DIRECTORY, "datasource_schema.json");
        ecs.generate((Type)((Object)Project.class), DIRECTORY, "project_schema.json");
        ecs.generate((Type)((Object)Relation.class), DIRECTORY, "relation_schema.json");
        ecs.generate((Type)((Object)Organization.class), DIRECTORY, "organization_schema.json");
        ecs.generate((Type)((Object)CommunityResult.class), DIRECTORY, "community_result_schema.json");
    }
}

