/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.dump.oaf.graph;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import eu.dnetlib.dhp.schema.dump.oaf.Provenance;
import eu.dnetlib.dhp.schema.dump.oaf.graph.Node;
import eu.dnetlib.dhp.schema.dump.oaf.graph.RelType;
import java.io.Serializable;
import java.util.Objects;

public class Relation
implements Serializable {
    @JsonSchema(description="The node source in the relation")
    private Node source;
    @JsonSchema(description="The node target in the relation")
    private Node target;
    @JsonSchema(description="To represent the semantics of a relation between two entities")
    private RelType reltype;
    @JsonSchema(description="The reason why OpenAIRE holds the relation ")
    private Provenance provenance;
    @JsonSchema(description="True if the relation is related to a project and it has been collected from an authoritative source (i.e. the funder)")
    private boolean validated;
    @JsonSchema(description="The date when the relation was collected from OpenAIRE")
    private String validationDate;

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public RelType getReltype() {
        return this.reltype;
    }

    public void setReltype(RelType reltype) {
        this.reltype = reltype;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public void setValidated(boolean validate) {
        this.validated = validate;
    }

    public boolean getValidated() {
        return this.validated;
    }

    public void setValidationDate(String validationDate) {
        this.validationDate = validationDate;
    }

    public String getValidationDate() {
        return this.validationDate;
    }

    public int hashCode() {
        return Objects.hash(this.source.getId(), this.target.getId(), this.reltype.getType() + ":" + this.reltype.getName());
    }

    public static Relation newInstance(Node source, Node target, RelType reltype, Provenance provenance) {
        Relation relation = new Relation();
        relation.source = source;
        relation.target = target;
        relation.reltype = reltype;
        relation.provenance = provenance;
        return relation;
    }
}

