/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.swh;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.swh.PrepareSWHActionsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareSWHActionsetsTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareSWHActionsetsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("Using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareSWHActionsetsTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareSWHActionsetsTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testRun() throws Exception {
        String lastVisitsPath = this.getClass().getResource("/eu/dnetlib/dhp/swh/last_visits_data.seq").getPath();
        String outputPath = workingDir.toString() + "/actionSet";
        String softwareInputPath = this.getClass().getResource("/eu/dnetlib/dhp/swh/software.json.gz").getPath();
        PrepareSWHActionsets.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-lastVisitsPath", lastVisitsPath, "-softwareInputPath", softwareInputPath, "-actionsetsPath", outputPath});
    }

    static {
        log = LoggerFactory.getLogger(PrepareSWHActionsetsTest.class);
    }
}

