/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.swh;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.swh.utils.SWHConnection;
import eu.dnetlib.dhp.swh.utils.SWHUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectLastVisitRepositoryData {
    private static final Logger log = LoggerFactory.getLogger(CollectLastVisitRepositoryData.class);
    private static SWHConnection swhConnection = null;

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)CollectLastVisitRepositoryData.class.getResourceAsStream("/eu/dnetlib/dhp/swh/input_collect_last_visit_repository_data.json")));
        argumentParser.parseArgument(args);
        log.info("Java Xmx: {}m", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L));
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI: {}", (Object)hdfsuri);
        String inputPath = argumentParser.get("softwareCodeRepositoryURLs");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = argumentParser.get("lastVisitsPath");
        log.info("outputPath: {}", (Object)outputPath);
        String apiAccessToken = argumentParser.get("apiAccessToken");
        log.info("apiAccessToken: {}", (Object)apiAccessToken);
        HttpClientParams clientParams = SWHUtils.getClientParams(argumentParser);
        swhConnection = new SWHConnection(clientParams, apiAccessToken);
        FileSystem fs = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        CollectLastVisitRepositoryData.collect(fs, inputPath, outputPath);
        fs.close();
    }

    private static void collect(FileSystem fs, String inputPath, String outputPath) throws IOException {
        FileStatus[] partStatuses;
        SequenceFile.Writer fw = SWHUtils.getSequenceFileWriter(fs, outputPath);
        Path directoryPath = new Path(inputPath);
        for (FileStatus partStatus : partStatuses = fs.listStatus(directoryPath)) {
            if (!partStatus.isFile()) continue;
            CollectLastVisitRepositoryData.handleFile(fs, partStatus.getPath(), fw);
        }
        fw.close();
    }

    private static void handleFile(FileSystem fs, Path partInputPath, SequenceFile.Writer fw) throws IOException {
        String repoUrl;
        BufferedReader br = SWHUtils.getFileReader(fs, partInputPath);
        while ((repoUrl = br.readLine()) != null) {
            String response;
            URL url = new URL(String.format("https://archive.softwareheritage.org/api/1/origin/%s/visit/latest/", repoUrl.trim()));
            try {
                response = swhConnection.call(url.toString());
            }
            catch (CollectorException e) {
                log.error("Error in request: {}", (Object)url);
                response = "{}";
            }
            SWHUtils.appendToSequenceFile(fw, repoUrl, response);
        }
        br.close();
    }
}

