/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oa.graph.usagerawdata.export;

import eu.dnetlib.oa.graph.usagerawdata.export.ConnectDB;
import eu.dnetlib.oa.graph.usagerawdata.export.ExecuteWorkflow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaReferenciaDownloadLogs {
    private final String piwikUrl;
    private Date startDate;
    private final String tokenAuth;
    private final String APImethod = "?module=API&method=Live.getLastVisitsDetails";
    private final String format = "&format=json";
    private final String ApimethodGetAllSites = "?module=API&method=SitesManager.getSitesWithViewAccess";
    private static final Logger logger = LoggerFactory.getLogger(LaReferenciaDownloadLogs.class);

    public LaReferenciaDownloadLogs(String piwikUrl, String tokenAuth) throws Exception {
        this.piwikUrl = piwikUrl;
        this.tokenAuth = tokenAuth;
        this.createTables();
    }

    public void reCreateLogDirs() throws IllegalArgumentException, IOException {
        FileSystem dfs = FileSystem.get((Configuration)new Configuration());
        logger.info("Deleting lareferenciaLog directory: " + ExecuteWorkflow.lareferenciaLogPath);
        dfs.delete(new Path(ExecuteWorkflow.lareferenciaLogPath), true);
        logger.info("Creating lareferenciaLog directory: " + ExecuteWorkflow.lareferenciaLogPath);
        dfs.mkdirs(new Path(ExecuteWorkflow.lareferenciaLogPath));
    }

    private void createTables() throws Exception {
        try {
            Statement stmt = ConnectDB.getHiveConnection().createStatement();
            logger.info("Creating LaReferencia tables");
            String sqlCreateTableLareferenciaLog = "CREATE TABLE IF NOT EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".lareferencialog(matomoid INT, source STRING, id_visit STRING, country STRING, action STRING, url STRING, entity_id STRING, source_item_type STRING, timestamp STRING, referrer_name STRING, agent STRING) clustered by (source, id_visit, action, timestamp, entity_id) into 100 buckets stored as orc tblproperties('transactional'='true')";
            stmt.executeUpdate(sqlCreateTableLareferenciaLog);
            logger.info("Created LaReferencia tables");
            stmt.close();
            ConnectDB.getHiveConnection().close();
            logger.info("Lareferencia Tables Created");
        }
        catch (Exception e) {
            logger.error("Failed to create tables: " + e);
            throw new Exception("Failed to create tables: " + e.toString(), e);
        }
    }

    private String getPiwikLogUrl() {
        return this.piwikUrl + "/";
    }

    private String getJson(String url) throws Exception {
        try {
            StringBuilder response;
            URL website = new URL(url);
            URLConnection connection = website.openConnection();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            return response.toString();
        }
        catch (Exception e) {
            logger.error("Failed to get URL: " + e);
            throw new Exception("Failed to get URL: " + e.toString(), e);
        }
    }

    public void GetLaReferenciaRepos(String repoLogsPath) throws Exception {
        String baseApiUrl = this.getPiwikLogUrl() + "?module=API&method=SitesManager.getSitesWithViewAccess" + "&format=json" + "&token_auth=" + this.tokenAuth;
        String content = "";
        List<Integer> siteIdsToVisit = new ArrayList<Integer>();
        content = this.getJson(baseApiUrl);
        JSONParser parser = new JSONParser();
        JSONArray jsonArray = (JSONArray)parser.parse(content);
        for (Object aJsonArray : jsonArray) {
            JSONObject jsonObjectRow = (JSONObject)aJsonArray;
            siteIdsToVisit.add(Integer.parseInt(jsonObjectRow.get((Object)"idsite").toString()));
        }
        logger.info("Found the following siteIds for download: " + siteIdsToVisit);
        if (ExecuteWorkflow.numberOfPiwikIdsToDownload > 0 && ExecuteWorkflow.numberOfPiwikIdsToDownload <= siteIdsToVisit.size()) {
            logger.info("Trimming siteIds list to the size of: " + ExecuteWorkflow.numberOfPiwikIdsToDownload);
            siteIdsToVisit = siteIdsToVisit.subList(0, ExecuteWorkflow.numberOfPiwikIdsToDownload);
        }
        logger.info("Downloading from repos with the followins siteIds: " + siteIdsToVisit);
        Iterator iterator = siteIdsToVisit.iterator();
        while (iterator.hasNext()) {
            int siteId = (Integer)iterator.next();
            logger.info("Now working on LaReferencia MatomoId: " + siteId);
            this.GetLaReFerenciaLogs(repoLogsPath, siteId);
        }
    }

    public void GetLaReFerenciaLogs(String repoLogsPath, int laReferencialMatomoID) throws Exception {
        logger.info("Downloading logs for LaReferencia repoid " + laReferencialMatomoID);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar start = (Calendar)ExecuteWorkflow.startingLogPeriod.clone();
        logger.info("Starting period for log download: " + sdf.format(start.getTime()));
        Calendar end = Calendar.getInstance();
        end.add(5, -1);
        logger.info("Ending period for log download: " + sdf.format(end.getTime()));
        PreparedStatement st = ConnectDB.getHiveConnection().prepareStatement("SELECT max(timestamp) FROM " + ConnectDB.getUsageStatsDBSchema() + ".lareferencialog WHERE matomoid=?");
        st.setInt(1, laReferencialMatomoID);
        Date dateMax = null;
        ResultSet rs_date = st.executeQuery();
        while (rs_date.next()) {
            if (rs_date.getString(1) == null || rs_date.getString(1).equals("null") || rs_date.getString(1).equals("")) continue;
            start.setTime(sdf.parse(rs_date.getString(1)));
            dateMax = sdf.parse(rs_date.getString(1));
        }
        rs_date.close();
        Calendar currDay = (Calendar)start.clone();
        while (currDay.before(end)) {
            Date date = currDay.getTime();
            if (dateMax != null && currDay.getTime().compareTo(dateMax) <= 0) {
                logger.info("Date found in logs " + dateMax + " and not downloanding Matomo logs for " + laReferencialMatomoID);
            } else {
                logger.info("Downloading logs for LaReferencia repoid " + laReferencialMatomoID + " and for " + sdf.format(date));
                String period = "&period=day&date=" + sdf.format(date);
                String outFolder = "";
                outFolder = repoLogsPath;
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                FSDataOutputStream fin = fs.create(new Path(outFolder + "/" + laReferencialMatomoID + "_LaRefPiwiklog" + sdf.format(date) + ".json"), true);
                String baseApiUrl = this.getPiwikLogUrl() + "?module=API&method=Live.getLastVisitsDetails" + "&idSite=" + laReferencialMatomoID + period + "&format=json" + "&expanded=5&filter_limit=1000&token_auth=" + this.tokenAuth;
                String content = "";
                int i = 0;
                JSONParser parser = new JSONParser();
                while (true) {
                    String apiUrl = baseApiUrl;
                    if (i > 0) {
                        apiUrl = apiUrl + "&filter_offset=" + i * 1000;
                    }
                    if ((content = this.getJson(apiUrl)).length() == 0 || content.equals("[]")) break;
                    JSONArray jsonArray = (JSONArray)parser.parse(content);
                    for (Object aJsonArray : jsonArray) {
                        JSONObject jsonObjectRaw = (JSONObject)aJsonArray;
                        fin.write(jsonObjectRaw.toJSONString().getBytes());
                        fin.writeChar(10);
                    }
                    logger.info("Downloaded part " + i + " of logs for LaReferencia repoid " + laReferencialMatomoID + " and for " + sdf.format(date));
                    ++i;
                }
                fin.close();
            }
            currDay.add(5, 1);
        }
    }
}

