/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.common.elasticsearch;

import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class EventStatsManager {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private ElasticSearchProperties elasticSearchProperties;

    public List<BrowseEntry> browseTopics() {
        String term = "topic.keyword";
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withSearchType(SearchType.DEFAULT).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"topic.keyword").field("topic.keyword")).size(1000).minDocCount(1L)).build();
        SearchHits hits = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getEventsIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        return ((ParsedStringTerms)aggregations.asMap().get("topic.keyword")).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    public class BrowseEntry {
        private final String value;
        private final long count;

        public BrowseEntry(String value, long count) {
            this.value = value;
            this.count = count;
        }

        public String getValue() {
            return this.value;
        }

        public long getCount() {
            return this.count;
        }
    }
}

