/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.common.elasticsearch;

import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@elasticSearchProperties.getEventsIndexName()}")
public class Event {
    @Id
    private String eventId;
    @Field(type=FieldType.Keyword)
    private String producerId;
    @Field(type=FieldType.Keyword)
    private String topic;
    @Field(type=FieldType.Text)
    private String payload;
    @Field(type=FieldType.Long)
    private Long creationDate;
    @Field(type=FieldType.Long)
    private Long expiryDate;
    @Field(type=FieldType.Boolean)
    private boolean instantMessage;
    @Field(type=FieldType.Nested)
    private Map<String, Object> map;

    public Event() {
    }

    public Event(String producerId, String eventId, String topic, String payload, Long creationDate, Long expiryDate, boolean instantMessage, Map<String, Object> map) {
        this.producerId = producerId;
        this.eventId = eventId;
        this.topic = topic;
        this.payload = payload;
        this.creationDate = creationDate;
        this.expiryDate = expiryDate;
        this.instantMessage = instantMessage;
        this.map = map;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public boolean isInstantMessage() {
        return this.instantMessage;
    }

    public void setInstantMessage(boolean instantMessage) {
        this.instantMessage = instantMessage;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<String, Object> map) {
        this.map = map;
    }
}

