/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.common.metrics;

import eu.dnetlib.broker.common.elasticsearch.NotificationRepository;
import eu.dnetlib.broker.common.stats.OpenaireDsStatRepository;
import eu.dnetlib.broker.common.subscriptions.ConditionOperator;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MetricsCacheUtils {
    public static final String metrics_cache = "broker_metrics_cache";
    private static final long interval = 43200000L;
    private static final Log log = LogFactory.getLog(MetricsCacheUtils.class);
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private OpenaireDsStatRepository openaireDsStatRepository;
    @Autowired
    private NotificationRepository notificationRepository;

    @Scheduled(fixedDelay=43200000L, initialDelay=500L)
    @CacheEvict(allEntries=true, value={"broker_metrics_cache"})
    public void reportCacheEvict() {
        log.debug((Object)"Flush Cache: broker_metrics_cache");
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double totalEvents() {
        log.debug((Object)"Call to cached method: totalEvents()");
        return this.openaireDsStatRepository.totalEvents();
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double countDatasourcesWithEvents() {
        log.debug((Object)"Call to cached method: countDatasourcesWithEvents()");
        return this.openaireDsStatRepository.countDatasourcesWithEvents();
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double countNotifications() {
        log.debug((Object)"Call to cached method: countNotifications()");
        return this.notificationRepository.count();
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double countSubscriptions() {
        log.debug((Object)"Call to cached method: countSubscriptions()");
        return this.subscriptionRepository.count();
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double countSubscribers() {
        log.debug((Object)"Call to cached method: countSubscribers()");
        return this.subscriptionRepository.countSubscribers();
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double lastUpdateInSeconds() {
        log.debug((Object)"Call to cached method: lastUpdateInSeconds()");
        return System.currentTimeMillis() / 1000L;
    }

    @Cacheable(value={"broker_metrics_cache"}, key="#root.methodName")
    public double countDatasourcesWithSubscriptions() {
        log.debug((Object)"Call to cached method: countDatasourcesWithSubscriptions()");
        return StreamSupport.stream(this.subscriptionRepository.findAll().spliterator(), false).map(Subscription::getConditionsAsList).flatMap(Collection::stream).filter(c -> c.getField().equals("targetDatasourceName")).filter(c -> c.getOperator() == ConditionOperator.EXACT).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).filter(StringUtils::isNotBlank).distinct().count();
    }
}

