package eu.dnetlib.broker.common.stats;

import java.io.Serializable;
import java.util.Objects;

public class OpenaireDsStatPK implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 3061558721019854932L;

	private String dsId;

	private String topic;

	public String getDsId() {
		return dsId;
	}

	public void setDsId(final String dsId) {
		this.dsId = dsId;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(final String topic) {
		this.topic = topic;
	}

	@Override
	public int hashCode() {
		return Objects.hash(dsId, topic);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (!(obj instanceof OpenaireDsStatPK)) { return false; }
		final OpenaireDsStatPK other = (OpenaireDsStatPK) obj;
		return Objects.equals(dsId, other.dsId) && Objects.equals(topic, other.topic);
	}

	@Override
	public String toString() {
		return String.format("OpenaireDsStatPK [dsId=%s, topic=%s]", dsId, topic);
	}
}
