package eu.dnetlib.broker.common.elasticsearch;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;

public interface AlertNotificationRepository extends ElasticsearchRepository<AlertNotification, String> {
	// TODO: use the @Query annotation if necessary
	// See: http://docs.spring.io/spring-data/elasticsearch/docs/current/reference/html/

	Iterable<AlertNotification> findBySubscriptionId(String subscriptionId);

	@Override
	Page<AlertNotification> findAll(Pageable pageable);

	Page<AlertNotification> findByEventId(String topic, Pageable pageable);

	long deleteByDateBefore(long date);

	long countBySubscriptionId(String subscriptionId);

	long countBySubscriptionIdAndDateAfter(String subscriptionId, long from);

	void deleteBySubscriptionId(String subscriptionId);

	long deleteByDateBetween(long from, long to);

}
