/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.exporter.exceptions.FundersApiException;
import eu.dnetlib.openaire.exporter.model.funders.ExtendedFunderDetails;
import eu.dnetlib.openaire.exporter.model.funders.FunderDetails;
import eu.dnetlib.openaire.funders.FunderDao;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.funders"}, havingValue="true")
@Tag(name="OpenAIRE funders API", description="the OpenAIRE funders API")
public class FundersApiController
extends AbstractExporterController {
    private static final Log log = LogFactory.getLog(FundersApiController.class);
    @Autowired
    private FunderDao fDao;

    @RequestMapping(value={"/funders"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get basic information about funders", description="basic information about funders: id, name, shortname, last update date, registration date")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<FunderDetails> getFunders(@PathVariable int page, @PathVariable int size) throws FundersApiException {
        return this.fDao.listFunderDetails(page, size);
    }

    @RequestMapping(value={"/funder/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the funder details", description="complete funder information")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public ExtendedFunderDetails getFunderDetails(@PathVariable String id) throws FundersApiException {
        return this.fDao.getExtendedFunderDetails(id);
    }

    @RequestMapping(value={"/funder/ids"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of funder ids", description="get the list of funder ids")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> getFunderIds(@PathVariable int page, @PathVariable int size) throws FundersApiException {
        return this.fDao.listFunderIds(page, size);
    }
}

