package eu.dnetlib.openaire.community.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

import com.vladmihalcea.hibernate.type.array.StringArrayType;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import com.vladmihalcea.hibernate.type.json.JsonStringType;

import eu.dnetlib.openaire.exporter.model.context.Param;

@Entity
@Table(name = "community_subs")
@TypeDefs({
	@TypeDef(name = "string-array", typeClass = StringArrayType.class),
	@TypeDef(name = "json", typeClass = JsonStringType.class),
	@TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
})
public class DbSubCommunity implements Serializable {

	private static final long serialVersionUID = 7104936574383307358L;

	@Id
	@Column(name = "sub_id")
	private String id;

	@Column(name = "community")
	private String community;

	@Column(name = "label")
	private String label;

	@Column(name = "category")
	private String category;

	@Type(type = "jsonb")
	@Column(name = "params")
	private List<Param> params = new ArrayList<>();

	@Column(name = "parent")
	private String parent;

	@Column(name = "claim")
	private boolean claim = false;

	@Column(name = "browsable")
	private boolean browsable = false;

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getCommunity() {
		return community;
	}

	public void setCommunity(final String community) {
		this.community = community;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(final String label) {
		this.label = label;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(final String category) {
		this.category = category;
	}

	public List<Param> getParams() {
		return params;
	}

	public void setParams(final List<Param> params) {
		this.params = params;
	}

	public String getParent() {
		return parent;
	}

	public void setParent(final String parent) {
		this.parent = parent;
	}

	public boolean isClaim() {
		return claim;
	}

	public void setClaim(final boolean claim) {
		this.claim = claim;
	}

	public boolean isBrowsable() {
		return browsable;
	}

	public void setBrowsable(final boolean browsable) {
		this.browsable = browsable;
	}
}
