DROP TABLE IF EXISTS community_subs;
DROP TABLE IF EXISTS community_projects;
DROP TABLE IF EXISTS community_datasources;
DROP TABLE IF EXISTS community_support_orgs;
DROP TABLE IF EXISTS community_orgs;
DROP TABLE IF EXISTS communities;

CREATE TABLE communities (
	id                       text PRIMARY KEY,
	name                     text NOT NULL,
	shortname                text NOT NULL, -- in the profile is label
	description              text NOT NULL DEFAULT '',
	status                   text NOT NULL DEFAULT 'hidden', -- all, manager, hidden, members
	membership               text NOT NULL DEFAULT 'by-invitation', -- open, by-invitation
	type                     text NOT NULL, -- community, ri
	claim                    text, -- managers-only, members-only, all
	subjects                 text[],
	fos                      text[],
	sdg                      text[],
	adv_constraints          jsonb,
	remove_constraints       jsonb,
	main_zenodo_community    text,
	other_zenodo_communities text[],
	creation_date            timestamp NOT NULL DEFAULT now(),
	last_update              timestamp NOT NULL DEFAULT now(),
	logo_url                 text,
	suggested_acknowledgements text[],
	plan                     text
);

CREATE TABLE community_projects (
	community       text NOT NULL REFERENCES communities(id),
	project_id      text NOT NULL,
	project_code    text NOT NULL,
	project_name    text NOT NULL,
	project_acronym text,
	project_funder  text NOT NULL,
	available_since date NOT NULL default now(),
	PRIMARY KEY (community, project_id)
);

CREATE TABLE community_datasources (
	community       text NOT NULL REFERENCES communities(id),
	ds_id           text NOT NULL,
	ds_name         text NOT NULL,
	ds_officialname text NOT NULL,
	enabled         boolean NOT NULL DEFAULT true;
	constraints     jsonb,
	PRIMARY KEY (community, ds_id)
);

CREATE TABLE community_support_orgs (
	community     text NOT NULL REFERENCES communities(id),
	org_name      text NOT NULL,
	org_url       text NOT NULL,
	org_logourl   text NOT NULL,
	PRIMARY KEY (community, org_name)
);

CREATE TABLE community_orgs (
	community   text NOT NULL REFERENCES communities(id),
	org_id      text NOT NULL,
	PRIMARY KEY (community, org_id)
);


CREATE TABLE community_subs (
	sub_id      text    NOT NULL PRIMARY KEY,
	community   text    NOT NULL REFERENCES communities(id),
	label       text    NOT NULL,
	category    text    NOT NULL,
	claim       boolean NOT NULL DEFAULT false,
	browsable   boolean NOT NULL DEFAULT false,
	params      jsonb,
	parent      text REFERENCES community_subs(sub_id) -- NULL for the first level
);

CREATE INDEX community_projects_community ON community_projects(community);
CREATE INDEX community_datasources_community ON community_datasources(community);
CREATE INDEX community_support_orgs_community ON community_support_orgs(community);
CREATE INDEX community_orgs_community ON community_orgs(community);
CREATE INDEX community_subs_community ON community_subs(community);
CREATE INDEX community_subs_parent ON community_subs(parent);
