/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.community.model.DepositionInfo;
import eu.dnetlib.openaire.community.utils.CommunityMappingUtils;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class CommunityApiController
extends AbstractExporterController {
    @Autowired
    private CommunityService communityService;

    @GetMapping(value={"/community/communities"})
    @Operation(summary="get all community profiles", description="get all community profiles", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        try {
            return this.communityService.listCommunities();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/"})
    @Operation(summary="add a new community profile", description="add a new community profile", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunity(@RequestBody CommunityDetails details) throws CommunityException {
        try {
            return this.communityService.newCommunity(details);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}"})
    @Operation(summary="get community profile", description="get community profile", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}"})
    @Operation(summary="update community details", description="update community details", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails updateCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException {
        try {
            this.communityService.updateCommunity(id, properties);
            return this.communityService.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}"})
    @Operation(summary="delete a community", description="delete a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunity(@PathVariable String id) throws CommunityException {
        try {
            this.communityService.removeCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subjects"})
    @Operation(summary="associate a subject to a community", description="associate a subject to a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunitySubjects(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subjects"})
    @Operation(summary="remove subjects from a community", description="remove subjects from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            this.communityService.removeCommunitySubjects(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/fos"})
    @Operation(summary="associate a fos to a community", description="associate a fos to a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityFOS(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/fos"})
    @Operation(summary="remove fos from a community", description="remove fos from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityFOS(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/sdg"})
    @Operation(summary="associate a sdg to a community", description="associate a sdg to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            this.communityService.addCommunitySDG(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/sdg"})
    @Operation(summary="remove sdg from a community", description="remove sdg from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunitySDG(id, subjects);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/advancedConstraint"})
    @Operation(summary="the set of constraints to be used to extend the association between result and community", description="the set of constraints to be used to extend the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityAdvancedConstraint(@PathVariable String id, @RequestBody SelectionCriteria advancedConstraint) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityAdvancedConstraint(id, advancedConstraint);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/advancedConstraint"})
    @Operation(summary="remove the constraints to extend the association result community from a community", description="remove the constraints to extend the association result community from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityAdvancedConstraint(@PathVariable String id) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityAdvancedConstraint(id);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/removeConstraint"})
    @Operation(summary="the set of constraints to be used to remove the association between result and community", description="the set of constraints to be used to remove the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityRemoveConstraint(@PathVariable String id, @RequestBody SelectionCriteria removeConstraint) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityRemoveConstraint(id, removeConstraint);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/removeConstraint"})
    @Operation(summary="remove the constraints to remove the association beetween result and community", description="remove the constraints to remove the association beetween result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityRemoveConstraint(@PathVariable String id) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityRemoveConstraint(id);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/zenodocommunities"})
    @Operation(summary="associate a Zenodo community to a community", description="associate a Zenodo community to the community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityZenodoCommunity(id, zenodocommunity, main);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/zenodocommunities"})
    @Operation(summary="remove a Zenodo community from a community", description="remove a Zenodo community from a community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityZenodoCommunity(id, zenodocommunity, main);
            return this.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/projects/{page}/{size}"})
    @Operation(summary="get community projects", description="get community projects", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Page<CommunityProject> getCommunityProjects(@PathVariable String id, @PathVariable Integer page, @PathVariable Integer size, @RequestParam(required=false) String funder, @RequestParam(required=false) String searchFilter, @RequestParam(required=false) String orderBy) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return this.communityService.getCommunityProjects(id, funder, searchFilter, page.intValue(), size.intValue(), orderBy);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/projects"})
    @Operation(summary="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return this.communityService.addCommunityProject(id, project);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/projects"})
    @Operation(summary="remove a project from the community", description="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProject(@PathVariable String id, @RequestParam String projectId) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityProjects(id, new String[]{projectId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/projectList"})
    @Operation(summary="associate a list of project to the community", description="associate a list of project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject[] addCommunityProjectList(@PathVariable String id, @RequestBody CommunityProject[] projects) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityProjects(id, projects);
            return projects;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/projectList"})
    @Operation(summary="remove a list of projects from the community", description="remove a list of projects from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProjectList(@PathVariable String id, @RequestBody String[] projectIdList) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityProjects(id, projectIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/funders"})
    @Operation(summary="get the funders of the projects of a community", description="get the funders of the projects of a community", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> getCommunityFunders(@PathVariable String id) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return this.communityService.getCommunityFunders(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/datasources"})
    @Operation(summary="get the list of datasources associated to a given community", description="get the list of content providers associated to a given community", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityDatasources(@PathVariable String id, @RequestParam(required=false) Boolean deposit) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return deposit == null ? this.communityService.getCommunityDatasources(id) : this.communityService.getCommunityDatasourcesWithDeposit(id, deposit.booleanValue());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasources"})
    @Operation(summary="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasource(@PathVariable String id, @RequestBody CommunityContentprovider datasource) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityDatasources(id, new CommunityContentprovider[]{datasource});
            return datasource;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasources/deposit"})
    @Operation(summary="update the deposit and message filelds of a datasource associated to the community", description="update the deposit and message filelds of a datasource associated to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasourceDeposit(@PathVariable String id, @RequestBody DepositionInfo info) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return this.communityService.updateCommunityDatasourcesDeposit(id, info.getOpenaireId(), info.getDeposit(), info.getMessage());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/datasources"})
    @Operation(summary="remove the association between a datasource and the community", description="remove the association between a datasource and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityDatasource(@PathVariable String id, @RequestParam String dsId) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityDatasources(id, new String[]{dsId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasourcesList"})
    @Operation(summary="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider[] addCommunityDatasourcesList(@PathVariable String id, @RequestBody CommunityContentprovider[] dsList) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityDatasources(id, dsList);
            return dsList;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/datasourcesList"})
    @Operation(summary="remove a list of datasources from the community", description="remove a list of datasources from the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityDatasourcesList(@PathVariable String id, @RequestBody String[] dsIdList) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityDatasources(id, dsIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/organizations"})
    @Operation(summary="get the list of organizations for a given community", description="get the list of organizations for a given community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityOrganization> getCommunityOrganizations(@PathVariable String id) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            return this.communityService.getCommunityOrganizations(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/organizations"})
    @Operation(summary="associate an organization to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate an organization to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization addCommunityOrganization(@PathVariable String id, @RequestBody CommunityOrganization organization) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityOrganizations(id, new CommunityOrganization[]{organization});
            return organization;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/organizationList"})
    @Operation(summary="associate a list of organizations to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of organizations to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization[] addCommunityOrganizationList(@PathVariable String id, @RequestBody CommunityOrganization[] orgs) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.addCommunityOrganizations(id, orgs);
            return orgs;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/organizations"})
    @Operation(summary="remove the association between an organization and the community", description="remove the association between an organization and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganization(@PathVariable String id, @RequestParam String organizationName) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityOrganizations(id, new String[]{organizationName});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/organizationList"})
    @Operation(summary="remove a list of associations between some organizations and the community", description="remove a list of associations between some organizations and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganizationList(@PathVariable String id, @RequestBody String[] orgNames) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        try {
            this.communityService.removeCommunityOrganizations(id, orgNames);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="try { return the propagation organizations of a community", description="try { return the propagation organizations of a community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> getPropagationOrganizationsForCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationsForCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="add an organization to the propagationOrganizationCommunityMap", description="add an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> addPropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.addPropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="delete an organization to the propagationOrganizationCommunityMap", description="delete an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> removePropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.removePropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }
}

