/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.info.JdbcInfoDao;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.info"}, havingValue="true")
@Tag(name="OpenAIRE Info API", description="the OpenAIRE info API")
public class InfoController
extends AbstractExporterController {
    private static final Log log = LogFactory.getLog(InfoController.class);
    public static final String UTF8 = "UTF-8";
    @Autowired
    private JdbcInfoDao jdbcInfoDao;

    @RequestMapping(value={"/info/{infoKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get info date", description="get info date", tags={"Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public LocalDate getDate(@PathVariable String infoKey) {
        JdbcInfoDao.DATE_INFO info = JdbcInfoDao.DATE_INFO.valueOf((String)infoKey);
        if (info == null) {
            throw new RuntimeException(infoKey + " not recognized");
        }
        return this.jdbcInfoDao.getDate(info);
    }

    @RequestMapping(value={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get all the info date", description="get all the info date", tags={"Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Map<String, LocalDate> listInfo() {
        HashMap map = Maps.newHashMap();
        for (JdbcInfoDao.DATE_INFO dateInfo : JdbcInfoDao.DATE_INFO.values()) {
            map.put(dateInfo.name(), this.jdbcInfoDao.getDate(dateInfo));
        }
        return map;
    }

    @RequestMapping(value={"/info/keys"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the available keys", description="get the available keys", tags={"Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> listInfoKeys() {
        ArrayList keys = Lists.newArrayList();
        for (JdbcInfoDao.DATE_INFO dateInfo : JdbcInfoDao.DATE_INFO.values()) {
            keys.add(dateInfo.name());
        }
        return keys;
    }

    @RequestMapping(value={"/info/dropCache"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="Drops the info cache", description="Drops the info cache", tags={"Read"})
    public void dropCache() {
        this.jdbcInfoDao.dropCache();
    }
}

