/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import com.google.common.collect.Lists;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.dsm.dao.ApiDbEntryRepository;
import eu.dnetlib.openaire.dsm.dao.DatasourceApiDbEntryRepository;
import eu.dnetlib.openaire.dsm.dao.DatasourceDao;
import eu.dnetlib.openaire.dsm.dao.DatasourceDbEntryRepository;
import eu.dnetlib.openaire.dsm.dao.DatasourceSpecs;
import eu.dnetlib.openaire.dsm.domain.db.ApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import eu.dnetlib.openaire.exporter.model.dsm.RequestFilter;
import eu.dnetlib.openaire.exporter.model.dsm.RequestSort;
import eu.dnetlib.openaire.exporter.model.dsm.RequestSortOrder;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class DatasourceDaoImpl
implements DatasourceDao<DatasourceDbEntry, ApiDbEntry> {
    private static final Log log = LogFactory.getLog(DatasourceDao.class);
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private DatasourceDbEntryRepository dsRepository;
    @Autowired
    private ApiDbEntryRepository apiRepository;
    @Autowired
    private DatasourceApiDbEntryRepository dsApiRepository;

    public Page<DatasourceDbEntry> search(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        Specification spec = DatasourceSpecs.dsSpec((RequestSort)requestSortBy, (RequestSortOrder)order, (RequestFilter)requestFilter);
        return this.dsRepository.findAll(spec, (Pageable)PageRequest.of((int)page, (int)size));
    }

    public Page<DatasourceDbEntry> searchRegistered(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        Specification spec = DatasourceSpecs.dsSpec((RequestSort)requestSortBy, (RequestSortOrder)order, (RequestFilter)requestFilter).and(DatasourceSpecs.dsRegisteredbyNotNullSpec());
        return this.dsRepository.findAll(spec, (Pageable)PageRequest.of((int)page, (int)size));
    }

    public DatasourceDbEntry getDs(String dsId) throws DsmException {
        return (DatasourceDbEntry)this.dsRepository.findById((Object)dsId).orElseThrow(() -> new DsmException("Datasource not found. ID: " + dsId));
    }

    public DatasourceDbEntry getDsByNsPrefix(String prefix) throws DsmException {
        return (DatasourceDbEntry)this.dsRepository.findByNamespaceprefix(prefix).orElseThrow(() -> new DsmException("Datasource not found. NS Prefix: " + prefix));
    }

    public void setManaged(String id, boolean managed) {
        log.info((Object)String.format("setting managed = '%s' for ds '%s'", managed, id));
        this.dsRepository.setManaged(id, managed);
        this.apiRepository.setRemovable(id, true);
    }

    public boolean isManaged(String id) {
        return this.dsRepository.isManaged(id);
    }

    public void updateCompliance(String dsId, String apiId, String compliance, boolean override) {
        log.info((Object)String.format("setting compatibility = '%s' for ds '%s'", compliance, apiId));
        this.apiRepository.updateCompatibility(apiId, compliance);
    }

    public List<ApiDbEntry> getApis(String dsId) {
        return this.apiRepository.findByDatasource(dsId);
    }

    public void deleteApi(String dsId, String apiId) throws DsmForbiddenException, DsmNotFoundException {
        ApiDbEntry api = (ApiDbEntry)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new DsmNotFoundException("Api not found. ID: " + apiId));
        try {
            if (!api.getRemovable().booleanValue()) {
                throw new DsmForbiddenException(401, "api is not removable");
            }
            this.apiRepository.deleteById((Object)apiId);
            log.info((Object)String.format("deleted api '%s'", apiId));
        }
        catch (EntityNotFoundException e) {
            throw new DsmNotFoundException(404, "api not found");
        }
    }

    public void addApi(ApiDbEntry api) {
        this.apiRepository.save((Object)api);
    }

    public boolean existDs(String dsId) throws DsmException {
        return this.dsRepository.existsById((Object)dsId);
    }

    public void saveDs(DatasourceDbEntry d) {
        log.info((Object)String.format("saving datasource '%s'", d.getId()));
        DatasourceDbEntry datasource = (DatasourceDbEntry)this.dsRepository.save((Object)d);
        log.info((Object)String.format("saved datasource '%s'", datasource.getId()));
        this.ensureRegistrationDate(d.getId());
    }

    public void deleteDs(String dsId) {
        this.dsRepository.deleteById((Object)dsId);
        log.info((Object)String.format("deleted datasource '%s'", dsId));
    }

    public void updateName(String dsId, String officialname, String englishname) {
        this.dsRepository.setDatasourcename(dsId, officialname, englishname);
    }

    public void updateLogoUrl(String dsId, String logourl) throws DsmException {
        this.dsRepository.setLogoUrl(dsId, logourl);
    }

    public void updateCoordinates(String dsId, Double latitude, Double longitude) {
        this.dsRepository.setCoordinates(dsId, latitude, longitude);
    }

    public void updateApiBaseUrl(String apiId, String baseurl) {
        this.apiRepository.setBaseurl(apiId, baseurl);
    }

    @Transactional
    public boolean upsertApiOaiSet(String apiId, String oaiSet) throws DsmException {
        ApiDbEntry api = (ApiDbEntry)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new DsmNotFoundException("Api not found. ID: " + apiId));
        if ("oai".equalsIgnoreCase(api.getProtocol())) {
            Set apiParams = api.getApiParams();
            if (!apiParams.stream().anyMatch(ap -> "set".equals(ap.getParam()))) {
                this.apiRepository.addApiParam(apiId, "set", oaiSet);
                log.info((Object)String.format("added api '%s' oai set with '%s'", apiId, oaiSet));
                return true;
            }
            this.apiRepository.updateOaiSet(apiId, oaiSet);
            log.info((Object)String.format("updated api '%s' oai set with '%s'", apiId, oaiSet));
            return false;
        }
        throw new DsmException(String.format("won't add OAI set to a non OAI interface: '%s' has protocol '%s'", apiId, api.getProtocol()));
    }

    public List<String> findApiBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmException {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Specification spec = DatasourceSpecs.apiSpec((RequestFilter)requestFilter);
        Set set = this.dsApiRepository.findAll(spec, (Pageable)pageable).getContent().stream().map(DatasourceApiDbEntry::getBaseurl).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(HashSet::new));
        return Lists.newArrayList((Iterable)set);
    }

    public void updateTimezone(String dsId, String timezone) {
        this.dsRepository.setTimezone(dsId, timezone);
    }

    public void updateEoscDatasourceType(String dsId, String type) throws DsmException {
        this.dsRepository.setEoscDatasourceType(dsId, type);
    }

    public void updateRegisteringUser(String dsId, String registeredBy) throws DsmException {
        this.ensureRegistrationDate(dsId);
        this.dsRepository.setRegisteringUser(dsId, registeredBy);
    }

    public void updatePlatform(String dsId, String platform) throws DsmException {
        this.dsRepository.setPlatform(dsId, platform);
    }

    private void ensureRegistrationDate(String dsId) {
        if (!this.dsRepository.hasRegistrationdate(dsId).booleanValue()) {
            log.info((Object)("setting registration date for datasource: " + dsId));
            this.dsRepository.setRegistrationDate(dsId, new Date(System.currentTimeMillis()));
        }
    }
}

